/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.common.event.NamelessJoinEvent;
import com.namelessmc.plugin.common.event.NamelessPlayerQuitEvent;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.UnknownInitialization;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;

public abstract class AbstractDataSender
implements Runnable,
Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask dataSenderTask;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat InfoProvider> globalInfoProviders;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerInfoProvider> playerInfoProviders;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration configuredInterval;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Long> playerLoginTime = new HashMap<UUID, Long>();

    protected AbstractDataSender(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
        this.startLoginTimeTracking();
    }

    private void startLoginTimeTracking(@UnknownInitialization(value=AbstractDataSender.class) AbstractDataSender this) {
        this.plugin.registerReloadable(new Reloadable(){

            @Override
            public void unload() {
            }

            @Override
            public void load() {
                for (NamelessPlayer player : AbstractDataSender.this.plugin.audiences().onlinePlayers()) {
                    if (AbstractDataSender.this.playerLoginTime.containsKey(player.uuid())) continue;
                    AbstractDataSender.this.playerLoginTime.put(player.uuid(), System.currentTimeMillis());
                }
            }
        });
        this.plugin.events().subscribe(NamelessJoinEvent.class, event -> this.playerLoginTime.put(event.player().uuid(), System.currentTimeMillis()));
        this.plugin.events().subscribe(NamelessPlayerQuitEvent.class, event -> this.playerLoginTime.remove(event.uuid()));
    }

    protected @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void unload() {
        if (this.dataSenderTask != null) {
            this.playerInfoProviders = null;
            this.globalInfoProviders = null;
            this.dataSenderTask.cancel();
            this.dataSenderTask = null;
            this.configuredInterval = null;
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"server-data-sender"});
        if (!((CommentedConfigurationNode)config.node(new Object[]{"enabled"})).getBoolean()) {
            return;
        }
        this.serverId = ((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"api", "server-id"})).getInt();
        if (this.serverId <= 0) {
            this.plugin.logger().warning("Server data sender is enabled, but server-id is not configured. Please enter the correct server id in main.yaml.");
            return;
        }
        this.configuredInterval = ConfigurationHandler.getDuration((ConfigurationNode)config.node(new Object[]{"interval"}));
        if (this.configuredInterval == null) {
            this.plugin.logger().warning("Invalid server data sender interval.");
            return;
        }
        this.dataSenderTask = this.plugin.scheduler().runTimer(this, this.configuredInterval);
        this.globalInfoProviders = new ArrayList<InfoProvider>();
        this.playerInfoProviders = new ArrayList<PlayerInfoProvider>();
        this.registerBaseProviders();
        this.registerCustomProviders();
    }

    private @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject buildJsonBody() {
        List<InfoProvider> globalInfoProviders = this.globalInfoProviders;
        List<PlayerInfoProvider> playerInfoProviders = this.playerInfoProviders;
        if (globalInfoProviders == null || playerInfoProviders == null) {
            throw new IllegalStateException("Providers are null, is the data sender disabled?");
        }
        JsonObject data = new JsonObject();
        data.addProperty("server_id", (Number)this.serverId);
        data.addProperty("server-id", (Number)this.serverId);
        if (this.configuredInterval == null) {
            throw new IllegalStateException("Interval should never be null if task is running");
        }
        data.addProperty("interval_seconds", (Number)this.configuredInterval.toSeconds());
        data.addProperty("time", (Number)System.currentTimeMillis());
        for (InfoProvider infoProvider : globalInfoProviders) {
            try {
                infoProvider.addInfoToJson(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonObject players = new JsonObject();
        for (NamelessPlayer player : this.plugin.audiences().onlinePlayers()) {
            if (player.isVanished()) continue;
            JsonObject playerJson = new JsonObject();
            playerJson.addProperty("name", player.username());
            for (PlayerInfoProvider infoProvider : playerInfoProviders) {
                try {
                    infoProvider.addInfoToJson(playerJson, player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            players.add(NamelessAPI.javaUuidToWebsiteUuid(player.uuid()), (JsonElement)playerJson);
        }
        data.add("players", (JsonElement)players);
        return data;
    }

    @Override
    public void run() {
        JsonObject data = this.buildJsonBody();
        this.plugin.logger().fine(() -> "Sending server data to website: " + String.valueOf(data));
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            AbstractLogger logger = this.plugin.logger();
            try {
                api.submitServerInfo(data);
            }
            catch (NamelessException e) {
                if (e instanceof ApiException && ((ApiException)e).apiError() == ApiError.CORE_INVALID_SERVER_ID) {
                    logger.warning("Server ID is incorrect. Please enter a correct server ID or disable the server data sender.");
                }
                logger.logException(e);
            }
        });
    }

    protected void registerGlobalInfoProvider(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat InfoProvider globalInfoProvider) {
        if (this.globalInfoProviders == null) {
            throw new IllegalStateException("Cannot register info provider when data sender is disabled");
        }
        this.globalInfoProviders.add(globalInfoProvider);
    }

    protected void registerPlayerInfoProvider(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerInfoProvider playerInfoProvider) {
        if (this.playerInfoProviders == null) {
            throw new IllegalStateException("Cannot register info provider when data sender is disabled");
        }
        this.playerInfoProviders.add(playerInfoProvider);
    }

    protected abstract void registerCustomProviders();

    private void registerBaseProviders() {
        this.registerGlobalInfoProvider(json -> {
            json.addProperty("free_memory", (Number)Runtime.getRuntime().freeMemory());
            json.addProperty("max_memory", (Number)Runtime.getRuntime().maxMemory());
            json.addProperty("allocated_memory", (Number)Runtime.getRuntime().totalMemory());
            json.addProperty("free-memory", (Number)Runtime.getRuntime().freeMemory());
            json.addProperty("max-memory", (Number)Runtime.getRuntime().maxMemory());
            json.addProperty("allocated-memory", (Number)Runtime.getRuntime().totalMemory());
        });
        CommentedConfigurationNode commands = this.plugin.config().commands();
        if (commands.hasChild(new Object[]{"verify"})) {
            String verifyCommand = "/" + commands.node(new Object[]{"verify"}).getString();
            this.registerGlobalInfoProvider(json -> json.addProperty("verify_command", verifyCommand));
        }
        this.registerPlayerInfoProvider((json, player) -> {
            Long loginTime = this.playerLoginTime.get(player.uuid());
            if (loginTime == null) {
                this.plugin.logger().warning("Player " + player.username() + " is missing from login time map. If the plugin was loaded normally (e.g. not using a plugin manager), this is probably a bug.");
                loginTime = System.currentTimeMillis();
            }
            json.addProperty("login_time", (Number)loginTime);
        });
        AbstractPermissions permissions = this.plugin.permissions();
        if (permissions != null) {
            this.registerPlayerInfoProvider(permissions);
            this.registerGlobalInfoProvider(permissions);
        }
    }

    @FunctionalInterface
    public static interface PlayerInfoProvider {
        public void addInfoToJson(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject var1, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlayer var2);
    }

    @FunctionalInterface
    public static interface InfoProvider {
        public void addInfoToJson(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat JsonObject var1);
    }
}

