/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessConsole;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.Collections;
import java.util.List;

public class StoreViewCreditsCommand
extends CommonCommand {
    public StoreViewCreditsCommand(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "store-view-credits", LanguageHandler.Term.COMMAND_STORE_VIEW_CREDITS_USAGE, LanguageHandler.Term.COMMAND_STORE_VIEW_CREDITS_DESCRIPTION, Permission.COMMAND_STORE_VIEW_CREDITS);
    }

    @Override
    public void execute(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length > 1) {
            sender.sendMessage(this.usage());
            return;
        }
        if (sender instanceof NamelessConsole && args.length == 0) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_VIEW_CREDITS_OUTPUT_CONSOLE_MUST_PROVIDE_TARGET));
            return;
        }
        if (args.length == 1 && !sender.hasPermission(Permission.COMMAND_STORE_VIEW_CREDITS_OTHERS)) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_VIEW_CREDITS_OUTPUT_NO_PERMISSION_OTHER));
            return;
        }
        this.scheduler().runAsync(() -> {
            try {
                NamelessUser user;
                NamelessAPI api = this.apiProvider().api();
                if (api == null) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                    return;
                }
                if (args.length == 1) {
                    user = api.userByMinecraftUsername(args[0]);
                    if (user == null) {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_TARGET_NO_WEBSITE_ACCOUNT));
                        return;
                    }
                } else {
                    user = api.userByMinecraftUuid(((NamelessPlayer)sender).uuid());
                    if (user == null) {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_NOT_REGISTERED));
                        return;
                    }
                }
                String credits = user.store().creditsDisplay();
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_STORE_VIEW_CREDITS_OUTPUT_CREDITS, "credits", credits));
            }
            catch (NamelessException e) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
        });
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> complete(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            return this.plugin().userCache().minecraftUsernamesSearch(args[0]);
        }
        return Collections.emptyList();
    }
}

