/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.nameless-api.CustomProfileFieldValue;
import com.namelessmc.plugin.lib.nameless-api.Group;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.integrations.DetailedIntegrationData;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class UserInfoCommand
extends CommonCommand {
    public UserInfoCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "user-info", LanguageHandler.Term.COMMAND_USERINFO_USAGE, LanguageHandler.Term.COMMAND_USERINFO_DESCRIPTION, Permission.COMMAND_USER_INFO);
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 0 && sender instanceof NamelessPlayer) {
            this.scheduler().runAsync(() -> {
                try {
                    NamelessAPI api = this.apiProvider().api();
                    if (api == null) {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                        return;
                    }
                    NamelessUser user = api.userByMinecraftUuid(((NamelessPlayer)sender).uuid());
                    if (user != null) {
                        this.scheduler().runSync(() -> this.printInfo(sender, user));
                    } else {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_NOT_REGISTERED));
                    }
                }
                catch (NamelessException e) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                    this.logger().logException(e);
                }
            });
            return;
        }
        if (args.length == 1) {
            this.scheduler().runAsync(() -> {
                try {
                    NamelessAPI api = this.apiProvider().api();
                    if (api == null) {
                        sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                        return;
                    }
                    NamelessPlayer targetPlayer = this.plugin().audiences().playerByUsername(args[0]);
                    if (targetPlayer != null) {
                        NamelessUser user = api.userByMinecraftUuid(targetPlayer.uuid());
                        if (user == null) {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_TARGET_NO_WEBSITE_ACCOUNT));
                            return;
                        }
                    } else if (args[0].matches(".+#\\d{4}")) {
                        NamelessUser user = api.userByDiscordUsername(args[0]);
                        if (user == null) {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_DISCORD_USERNAME_NOT_EXIST));
                            return;
                        }
                    } else {
                        try {
                            NamelessUser user = api.userByMinecraftUuid(UUID.fromString(args[0]));
                            if (user == null) {
                                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_MINECRAFT_UUID_NOT_EXIST));
                                return;
                            }
                            this.printInfo(sender, user);
                        }
                        catch (IllegalArgumentException e) {
                            NamelessUser user = api.userByUsername(args[0]);
                            if (user == null) {
                                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_USERNAME_NOT_EXIST));
                                return;
                            }
                            this.printInfo(sender, user);
                        }
                    }
                }
                catch (NamelessException e) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                    this.logger().logException(e);
                }
            });
            return;
        }
        sender.sendMessage(this.usage());
    }

    private void printInfo(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessUser user) {
        try {
            Map<String, DetailedIntegrationData> integrations;
            LinkedList<Runnable> runSync = new LinkedList<Runnable>();
            String username = user.username();
            String displayName = user.displayName();
            runSync.add(() -> {
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_USERNAME, "username", username));
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_DISPLAY_NAME, "displayname", displayName));
            });
            Group primaryGroup = user.primaryGroup();
            if (primaryGroup != null) {
                runSync.add(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_PRIMARY_GROUP, "groupname", primaryGroup.getName(), "id", String.valueOf(primaryGroup.getId()))));
            }
            String groupCommaString = user.groups().stream().map(Group::getName).collect(Collectors.joining(", "));
            String registeredDate = this.plugin().dateFormatter().format(user.registeredDate());
            runSync.add(() -> {
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_ALL_GROUPS, "groups_names_list", groupCommaString));
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_REGISTER_DATE, "date", registeredDate));
            });
            boolean verified = user.isVerified();
            boolean banned = user.isBanned();
            runSync.add(() -> {
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_VALIDATED, new TagResolver[]{Placeholder.component((String)"validated", (ComponentLike)this.language().booleanText(verified, true))}));
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_BANNED, new TagResolver[]{Placeholder.component((String)"banned", (ComponentLike)this.language().booleanText(banned, false))}));
            });
            Collection<CustomProfileFieldValue> customFields = user.profileFields();
            runSync.add(() -> {
                for (CustomProfileFieldValue customField : customFields) {
                    String value = customField.value();
                    if (value == null) {
                        value = "-";
                    }
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_CUSTOM_FIELD, "name", customField.field().name(), "value", value));
                }
            });
            if (user.api().website().modules().contains(NamelessModule.STORE)) {
                try {
                    float credits = (float)user.store().creditsCents() / 100.0f;
                    runSync.add(() -> sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_STORE_MODULE_CREDITS, "credits", String.format("%.2f", Float.valueOf(credits)))));
                }
                catch (ApiException e) {
                    if (e.apiError() == ApiError.NAMELESS_INVALID_API_METHOD) {
                        this.logger().warning("Skipped showing store credits, you are using a store module version that does not have the endpoint yet.");
                    }
                    throw e;
                }
            }
            if (!(integrations = user.integrations()).isEmpty()) {
                runSync.add(() -> {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_INTEGRATIONS_HEADER));
                    integrations.forEach((name, data) -> {
                        sender.sendMessage((Component)Component.text((String)("  " + name + ":")));
                        TextComponent indent = Component.text((String)"    ");
                        sender.sendMessage(indent.append(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_INTEGRATIONS_IDENTIFIER, "identifier", data.identifier())));
                        sender.sendMessage(indent.append(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_INTEGRATIONS_USERNAME, "username", data.username())));
                        sender.sendMessage(indent.append(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_INTEGRATIONS_LINKED_DATE, "linked_date", this.plugin().dateFormatter().format(data.linkedDate()))));
                        sender.sendMessage(indent.append(this.language().get(LanguageHandler.Term.COMMAND_USERINFO_OUTPUT_INTEGRATIONS_VERIFIED, new TagResolver[]{Placeholder.component((String)"is_verified", (ComponentLike)this.language().booleanText(data.isVerified(), true))})));
                    });
                });
            }
            this.plugin().scheduler().runSync(() -> runSync.forEach(Runnable::run));
        }
        catch (NamelessException e) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
            this.logger().logException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> complete(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            return this.plugin().userCache().usernamesSearch(args[0]);
        }
        return Collections.emptyList();
    }
}

