/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.MimeBodyPublisher;
import com.namelessmc.plugin.lib.methanol.WritableBodyPublisher;
import com.namelessmc.plugin.lib.methanol.function.ThrowingConsumer;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.extensions.MimeBodyPublisherAdapter;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class MoreBodyPublishers {
    private MoreBodyPublishers() {
    }

    public static HttpRequest.BodyPublisher ofOutputStream(ThrowingConsumer<? super OutputStream> writerTask, Executor executor) {
        return MoreBodyPublishers.ofBodyWriter(WritableBodyPublisher::outputStream, writerTask, executor);
    }

    public static HttpRequest.BodyPublisher ofWritableByteChannel(ThrowingConsumer<? super WritableByteChannel> writerTask, Executor executor) {
        return MoreBodyPublishers.ofBodyWriter(WritableBodyPublisher::byteChannel, writerTask, executor);
    }

    public static MimeBodyPublisher ofMediaType(HttpRequest.BodyPublisher bodyPublisher, MediaType mediaType) {
        return new MimeBodyPublisherAdapter(bodyPublisher, mediaType);
    }

    public static HttpRequest.BodyPublisher ofObject(Object object, @Nullable MediaType mediaType) {
        return AdapterCodec.installed().publisherOf(object, Utils.hintsOf(mediaType));
    }

    private static <T extends AutoCloseable> HttpRequest.BodyPublisher ofBodyWriter(Function<WritableBodyPublisher, T> extractor, ThrowingConsumer<? super T> writerTask, Executor executor) {
        Objects.requireNonNull(extractor);
        Objects.requireNonNull(writerTask);
        Objects.requireNonNull(executor);
        return HttpRequest.BodyPublishers.fromPublisher(subscriber -> {
            Objects.requireNonNull(subscriber);
            WritableBodyPublisher publisher = WritableBodyPublisher.create();
            publisher.subscribe(subscriber);
            if (!publisher.isClosed()) {
                try {
                    executor.execute(() -> {
                        try (AutoCloseable out = (AutoCloseable)extractor.apply(publisher);){
                            try {
                                writerTask.accept(out);
                            }
                            catch (Throwable t) {
                                publisher.closeExceptionally(t);
                            }
                        }
                        catch (Throwable t) {
                            publisher.closeExceptionally(t);
                        }
                    });
                }
                catch (Throwable t) {
                    publisher.closeExceptionally(t);
                }
            }
        });
    }
}

