/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.CacheAwareResponse;
import com.namelessmc.plugin.lib.methanol.CacheControl;
import com.namelessmc.plugin.lib.methanol.HttpCache;
import com.namelessmc.plugin.lib.methanol.HttpStatus;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.methanol.ResponseBuilder;
import com.namelessmc.plugin.lib.methanol.TrackedResponse;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheResponse;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheResponseMetadata;
import com.namelessmc.plugin.lib.methanol.internal.cache.CacheStrategy;
import com.namelessmc.plugin.lib.methanol.internal.cache.ChainAdapter;
import com.namelessmc.plugin.lib.methanol.internal.cache.HttpDates;
import com.namelessmc.plugin.lib.methanol.internal.cache.LocalCache;
import com.namelessmc.plugin.lib.methanol.internal.cache.NetworkResponse;
import com.namelessmc.plugin.lib.methanol.internal.cache.RawResponse;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.CancellationPropagatingFuture;
import com.namelessmc.plugin.lib.methanol.internal.extensions.Handlers;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HeadersBuilder;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.text.CharMatcher;
import com.namelessmc.plugin.lib.methanol.internal.text.HeaderValueTokenizer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CacheInterceptor
implements Methanol.Interceptor {
    private static final System.Logger logger = System.getLogger(CacheInterceptor.class.getName());
    private static final Set<String> RETAINED_STORED_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> RETAINED_STORED_HEADER_PREFIXES;
    private static final CharMatcher ETAG_C_MATCHER;
    private static final Optional<Boolean> TRUE_OPTIONAL;
    private final LocalCache.Factory cacheFactory;
    private final HttpCache.Listener listener;
    private final Executor handlerExecutor;
    private final Clock clock;
    private final boolean synchronizeWrites;
    private final Predicate<String> implicitHeaderPredicate;

    public CacheInterceptor(LocalCache.Factory cacheFactory, HttpCache.Listener listener, Executor handlerExecutor, Clock clock, boolean synchronizeWrites, Predicate<String> implicitHeaderPredicate) {
        this.cacheFactory = Objects.requireNonNull(cacheFactory);
        this.listener = Objects.requireNonNull(listener);
        this.handlerExecutor = Objects.requireNonNull(handlerExecutor);
        this.clock = Objects.requireNonNull(clock);
        this.synchronizeWrites = synchronizeWrites;
        this.implicitHeaderPredicate = Objects.requireNonNull(implicitHeaderPredicate);
    }

    @Override
    public <T> HttpResponse<T> intercept(HttpRequest request, Methanol.Interceptor.Chain<T> chain) throws IOException, InterruptedException {
        return Utils.get(this.exchange(request, chain, false)).handle(chain.bodyHandler());
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Methanol.Interceptor.Chain<T> chain) {
        return ((CompletableFuture)this.exchange(request, chain, true).thenCompose(rawResponse -> rawResponse.handleAsync(chain.bodyHandler(), this.handlerExecutor))).thenApply(Function.identity());
    }

    private CompletableFuture<RawResponse> exchange(HttpRequest request, Methanol.Interceptor.Chain<?> chain, boolean async) {
        Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> publisherChain = Handlers.toPublisherChain(chain, this.handlerExecutor);
        return new Exchange(request, this.cacheFactory.instance(async), async ? ChainAdapter.async(publisherChain) : ChainAdapter.syncOnCaller(publisherChain)).exchange();
    }

    private boolean isCacheable(HttpRequest request, TrackedResponse<?> response) {
        Set<String> varyFields;
        CacheControl responseCacheControl;
        if (CacheInterceptor.isNotSupported(request) || !request.uri().equals(response.uri()) || !request.method().equalsIgnoreCase(response.request().method())) {
            return false;
        }
        if (response.statusCode() == 206) {
            return false;
        }
        try {
            responseCacheControl = CacheControl.parse(response.headers());
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.WARNING, "Invalid response Cache-Control", (Throwable)e);
            return false;
        }
        if (responseCacheControl.noStore() || CacheControl.parse(request.headers()).noStore()) {
            return false;
        }
        try {
            varyFields = CacheResponseMetadata.varyFields(response.headers());
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.WARNING, "Invalid response Vary", (Throwable)e);
            return false;
        }
        if (varyFields.contains("*") || varyFields.stream().anyMatch(this.implicitHeaderPredicate)) {
            return false;
        }
        return responseCacheControl.maxAge().isPresent() || responseCacheControl.isPublic() || responseCacheControl.isPrivate() || CacheInterceptor.isHeuristicallyCacheable(response.statusCode()) || response.headers().firstValue("Expires").filter(HttpDates::isHttpDate).isPresent();
    }

    private static boolean isNotSupported(HttpRequest request) {
        return !CacheInterceptor.isSupportedRequestMethod(request.method()) || !request.headers().map().keySet().stream().allMatch(CacheInterceptor::isSupportedRequestHeader);
    }

    private static boolean isSupportedRequestMethod(String method) {
        return method.equalsIgnoreCase("GET");
    }

    private static boolean isSupportedRequestHeader(String name) {
        return !name.startsWith("If-") || name.equalsIgnoreCase("If-None-Match") || name.equalsIgnoreCase("If-Modified-Since");
    }

    private static boolean isNetworkOrServerError(@Nullable NetworkResponse networkResponse, @Nullable Throwable exception) {
        assert (networkResponse != null ^ exception != null);
        if (networkResponse != null) {
            return HttpStatus.isServerError(networkResponse.get());
        }
        Throwable cause = Utils.getDeepCompletionCause(exception);
        if (cause instanceof UncheckedIOException) {
            cause = cause.getCause();
        }
        return cause instanceof ConnectException || cause instanceof UnknownHostException;
    }

    private static boolean isHeuristicallyCacheable(int statusCode) {
        switch (statusCode) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                return true;
            }
        }
        return false;
    }

    private static CacheResponse updateCacheResponse(CacheResponse cacheResponse, NetworkResponse networkResponse) {
        return cacheResponse.with(builder -> ((ResponseBuilder)((ResponseBuilder)builder.removeHeaders()).headers(CacheInterceptor.mergeHeaders(cacheResponse.get().headers(), networkResponse.get().headers()))).timeRequestSent(networkResponse.get().timeRequestSent()).timeResponseReceived(networkResponse.get().timeResponseReceived()));
    }

    private static HttpHeaders mergeHeaders(HttpHeaders storedHeaders, HttpHeaders networkHeaders) {
        HeadersBuilder builder = new HeadersBuilder();
        builder.addAllLenient(storedHeaders);
        networkHeaders.map().forEach((name, values) -> {
            if (CacheInterceptor.canReplaceStoredHeader(name)) {
                builder.setLenient((String)name, (List<String>)values);
            }
        });
        builder.removeIf((name, value) -> name.equalsIgnoreCase("Warning") && value.startsWith("1"));
        return builder.build();
    }

    public static boolean canReplaceStoredHeader(String name) {
        return !RETAINED_STORED_HEADERS.contains(name) && !RETAINED_STORED_HEADER_PREFIXES.stream().anyMatch(prefix -> Utils.startsWithIgnoreCase(name, prefix)) && !name.equals(":status");
    }

    private static List<URI> invalidatedUris(HttpRequest request, TrackedResponse<?> response) {
        if (CacheInterceptor.isUnsafe(request.method()) && (HttpStatus.isSuccessful(response) || HttpStatus.isRedirection(response))) {
            ArrayList<URI> invalidatedUris = new ArrayList<URI>();
            invalidatedUris.add(request.uri());
            CacheInterceptor.invalidatedLocationUri(request.uri(), response.headers(), "Location").ifPresent(invalidatedUris::add);
            CacheInterceptor.invalidatedLocationUri(request.uri(), response.headers(), "Content-Location").ifPresent(invalidatedUris::add);
            return Collections.unmodifiableList(invalidatedUris);
        }
        return List.of();
    }

    private static Optional<URI> invalidatedLocationUri(URI requestUri, HttpHeaders responseHeaders, String locationField) {
        return responseHeaders.firstValue(locationField).map(requestUri::resolve).filter(resolvedUri -> Objects.equals(requestUri.getHost(), resolvedUri.getHost()));
    }

    private static boolean isUnsafe(String method) {
        return !method.equalsIgnoreCase("GET") && !method.equalsIgnoreCase("HEAD") && !method.equalsIgnoreCase("OPTIONS") && !method.equalsIgnoreCase("TRACE");
    }

    private static boolean evaluatePreconditions(HttpRequest request, TrackedResponse<?> cacheResponse) {
        return CacheInterceptor.evaluateIfNoneMatch(request, cacheResponse).or(() -> CacheInterceptor.evaluateIfModifiedSince(request, cacheResponse)).orElse(true);
    }

    private static Optional<Boolean> evaluateIfNoneMatch(HttpRequest request, TrackedResponse<?> cacheResponse) {
        List<String> ifNoneMatch = request.headers().allValues("If-None-Match");
        if (!ifNoneMatch.isEmpty()) {
            return cacheResponse.headers().firstValue("ETag").map(etag -> !CacheInterceptor.anyMatch(ifNoneMatch, etag)).or(() -> TRUE_OPTIONAL);
        }
        return Optional.empty();
    }

    private static Optional<Boolean> evaluateIfModifiedSince(HttpRequest request, TrackedResponse<?> cacheResponse) {
        return request.headers().firstValue("If-Modified-Since").flatMap(HttpDates::tryParseHttpDate).map(value -> CacheInterceptor.isModifiedSince(cacheResponse, value));
    }

    private static boolean anyMatch(List<String> candidates, String target) {
        if (candidates.size() == 1 && !candidates.get(0).contains(",")) {
            return !candidates.get(0).equals("*") && CacheInterceptor.weaklyMatches(target, candidates.get(0));
        }
        try {
            for (String value : candidates) {
                HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value);
                do {
                    tokenizer.consumeIfPresent("W/");
                    tokenizer.requireCharacter('\"');
                    String candidate = tokenizer.nextMatching(ETAG_C_MATCHER);
                    tokenizer.requireCharacter('\"');
                    if (!CacheInterceptor.weaklyMatches(target, "\"" + candidate + "\"")) continue;
                    return true;
                } while (tokenizer.consumeDelimiter(','));
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.WARNING, "Exception while parsing candidate E-Tags, assuming a no-match", (Throwable)e);
        }
        return false;
    }

    private static boolean weaklyMatches(String firstTag, String secondTag) {
        int firstTagLength;
        int firstTagBegin = 0;
        if (firstTag.startsWith("W/")) {
            firstTagBegin += 2;
        }
        int secondTagBegin = 0;
        if (secondTag.startsWith("W/")) {
            secondTagBegin += 2;
        }
        if ((firstTagLength = firstTag.length() - firstTagBegin) != secondTag.length() - secondTagBegin) {
            return false;
        }
        if (firstTagLength < 2 || firstTag.charAt(firstTagBegin) != '\"' || firstTag.charAt(firstTag.length() - 1) != '\"' || secondTag.charAt(secondTagBegin) != '\"' || secondTag.charAt(secondTag.length() - 1) != '\"') {
            return false;
        }
        return firstTag.regionMatches(firstTagBegin, secondTag, secondTagBegin, firstTagLength);
    }

    private static boolean isModifiedSince(TrackedResponse<?> cacheResponse, LocalDateTime dateTime) {
        return cacheResponse.headers().firstValue("Last-Modified").or(() -> cacheResponse.headers().firstValue("Date")).flatMap(HttpDates::tryParseHttpDate).orElseGet(() -> HttpDates.toUtcDateTime(cacheResponse.timeResponseReceived())).isAfter(dateTime);
    }

    private static <T> TrackedResponse<T> toTrackedResponse(HttpResponse<T> response, Instant requestTime, Clock clock) {
        return response instanceof TrackedResponse ? (TrackedResponse<T>)response : ResponseBuilder.from(response).timeRequestSent(requestTime).timeResponseReceived(clock.instant()).buildTrackedResponse();
    }

    static {
        RETAINED_STORED_HEADERS.addAll(Set.of("Connection", "Proxy-Connection", "Keep-Alive", "WWW-Authenticate", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "Content-Location", "Content-MD5", "ETag", "Content-Encoding", "Content-Range", "Content-Type", "Content-Length", "X-Frame-Options", "X-XSS-Protection"));
        RETAINED_STORED_HEADER_PREFIXES = Set.of("X-Content-", "X-Webkit-");
        ETAG_C_MATCHER = CharMatcher.is(33).or(CharMatcher.withinClosedRange(35, 126)).or(CharMatcher.withinClosedRange(128, 255));
        TRUE_OPTIONAL = Optional.of(true);
    }

    private final class Exchange {
        final HttpRequest request;
        final CacheControl requestCacheControl;
        final LocalCache cache;
        final ChainAdapter chainAdapter;

        Exchange(HttpRequest request, LocalCache cache, ChainAdapter chainAdapter) {
            this.request = request;
            this.requestCacheControl = CacheControl.parse(request.headers());
            this.cache = cache;
            this.chainAdapter = chainAdapter;
        }

        CompletableFuture<RawResponse> exchange() {
            CacheInterceptor.this.listener.onRequest(this.request);
            Instant requestTime = CacheInterceptor.this.clock.instant();
            return ((CompletableFuture)CancellationPropagatingFuture.of(this.retrieveCacheResponse(requestTime)).thenCompose(optionalCacheRetrieval -> optionalCacheRetrieval.map(cacheRetrieval -> this.exchange(requestTime, (CacheRetrieval)cacheRetrieval).whenComplete((__, ex) -> {
                if (ex != null) {
                    cacheRetrieval.closeResponse();
                }
            })).orElseGet(() -> this.exchange(requestTime, null)))).thenApply(response -> {
                CacheInterceptor.this.listener.onResponse(this.request, (CacheAwareResponse)response.get());
                return response;
            });
        }

        private CompletableFuture<Optional<CacheRetrieval>> retrieveCacheResponse(Instant requestTime) {
            if (CacheInterceptor.isNotSupported(this.request) || this.chainAdapter.chain().pushPromiseHandler().isPresent()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return ((CompletableFuture)this.cache.get(this.request).exceptionally(exception -> {
                CacheInterceptor.this.listener.onReadFailure(this.request, (Throwable)exception);
                return Optional.empty();
            })).thenApply(optionalCacheResponse -> optionalCacheResponse.map(cacheResponse -> new CacheRetrieval((CacheResponse)cacheResponse, CacheStrategy.create(this.requestCacheControl, cacheResponse, requestTime))));
        }

        private CompletableFuture<RawResponse> exchange(Instant requestTime, @Nullable CacheRetrieval cacheRetrieval) {
            if (cacheRetrieval != null && cacheRetrieval.strategy.isCacheResponseServable()) {
                if (cacheRetrieval.strategy.requiresBackgroundRevalidation()) {
                    this.revalidateInBackground(requestTime, cacheRetrieval.unowned());
                }
                return CompletableFuture.completedFuture(this.serveFromCache(requestTime, cacheRetrieval));
            }
            if (this.requestCacheControl.onlyIfCached()) {
                return CompletableFuture.completedFuture(this.serveUnsatisfiableRequest(requestTime, cacheRetrieval));
            }
            CacheInterceptor.this.listener.onNetworkUse(this.request, cacheRetrieval != null ? cacheRetrieval.response.get() : null);
            return ((CompletableFuture)this.exchangeWithNetwork(cacheRetrieval != null ? cacheRetrieval.strategy.conditionalize(this.request) : this.request, requestTime).handle((networkResponse, exception) -> this.handleNetworkOrServerError((NetworkResponse)networkResponse, (Throwable)exception, cacheRetrieval))).thenCompose(networkResponse -> this.exchange(requestTime, cacheRetrieval, (NetworkResponse)networkResponse));
        }

        private CompletableFuture<RawResponse> exchange(Instant requestTime, @Nullable CacheRetrieval cacheRetrieval, @Nullable NetworkResponse networkResponse) {
            assert (cacheRetrieval != null || networkResponse != null);
            if (networkResponse == null) {
                return CompletableFuture.completedFuture(this.serveFromCache(requestTime, cacheRetrieval));
            }
            if (cacheRetrieval != null && networkResponse.get().statusCode() == 304) {
                networkResponse.discard(CacheInterceptor.this.handlerExecutor);
                return this.serveFromCacheAfterUpdating(cacheRetrieval, networkResponse);
            }
            if (CacheInterceptor.this.isCacheable(this.request, networkResponse.get())) {
                return ((CompletableFuture)this.cache.put(this.request, networkResponse, cacheRetrieval != null ? cacheRetrieval.response : null).exceptionally(exception -> {
                    CacheInterceptor.this.listener.onWriteFailure(this.request, (Throwable)exception);
                    return Optional.empty();
                })).thenApply(cacheUpdatingNetworkResponse -> this.serveFromNetwork(cacheUpdatingNetworkResponse.orElse(networkResponse), cacheRetrieval));
            }
            List<URI> invalidatedUris = CacheInterceptor.invalidatedUris(this.request, networkResponse.get());
            if (!invalidatedUris.isEmpty()) {
                this.cache.removeAll(invalidatedUris).whenComplete((__, ex) -> {
                    if (ex != null) {
                        logger.log(System.Logger.Level.WARNING, "Exception when removing entries", (Throwable)ex);
                    }
                });
            }
            return CompletableFuture.completedFuture(this.serveFromNetwork(networkResponse, cacheRetrieval));
        }

        private CompletableFuture<NetworkResponse> exchangeWithNetwork(HttpRequest request, Instant requestTime) {
            return this.exchangeWithNetwork(request, requestTime, this.chainAdapter::forward);
        }

        private CompletableFuture<NetworkResponse> exchangeWithNetworkInBackground(HttpRequest request, Instant requestTime) {
            return this.exchangeWithNetwork(request, requestTime, this.chainAdapter.chain()::forwardAsync);
        }

        private CompletableFuture<NetworkResponse> exchangeWithNetwork(HttpRequest request, Instant requestTime, Function<HttpRequest, CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>>> forwarder) {
            return forwarder.apply(request).thenApply(response -> NetworkResponse.of(CacheInterceptor.toTrackedResponse(response, requestTime, CacheInterceptor.this.clock)));
        }

        private void revalidateInBackground(Instant requestTime, CacheRetrieval cacheRetrieval) {
            CacheInterceptor.this.listener.onNetworkUse(this.request, cacheRetrieval.response.get());
            ((CompletableFuture)this.exchangeWithNetworkInBackground(cacheRetrieval.strategy.conditionalize(this.request), requestTime).thenCompose(networkResponse -> this.exchange(requestTime, cacheRetrieval, (NetworkResponse)networkResponse))).whenComplete(this::handleBackgroundRevalidation);
        }

        private void handleBackgroundRevalidation(@Nullable RawResponse response, @Nullable Throwable exception) {
            assert (response != null ^ exception != null);
            if (response instanceof NetworkResponse) {
                NetworkResponse networkResponse = (NetworkResponse)response;
                if (networkResponse.isCacheUpdating()) {
                    networkResponse.handleAsync(__ -> new DrainingBodySubscriber(), CacheInterceptor.this.handlerExecutor).whenComplete((__, ex) -> {
                        if (ex != null) {
                            logger.log(System.Logger.Level.WARNING, "Asynchronous revalidation failure", (Throwable)ex);
                        }
                    });
                } else {
                    networkResponse.discard(CacheInterceptor.this.handlerExecutor);
                }
            } else if (exception != null) {
                logger.log(System.Logger.Level.WARNING, "Asynchronous revalidation failure", exception);
            }
        }

        private @Nullable NetworkResponse handleNetworkOrServerError(@Nullable NetworkResponse networkResponse, @Nullable Throwable exception, @Nullable CacheRetrieval cacheRetrieval) {
            assert (networkResponse != null ^ exception != null);
            if (CacheInterceptor.isNetworkOrServerError(networkResponse, exception) && cacheRetrieval != null && cacheRetrieval.strategy.isCacheResponseServableOnError()) {
                if (networkResponse != null) {
                    networkResponse.discard(CacheInterceptor.this.handlerExecutor);
                }
                return null;
            }
            if (exception != null) {
                if (cacheRetrieval != null) {
                    cacheRetrieval.closeResponse();
                }
                throw Utils.toCompletionException(exception);
            }
            return networkResponse;
        }

        private RawResponse serveFromCache(Instant requestTime, CacheRetrieval cacheRetrieval) {
            CacheResponse cacheResponse = cacheRetrieval.response;
            if (cacheResponse.get().statusCode() != 200 || CacheInterceptor.evaluatePreconditions(this.request, cacheResponse.get())) {
                return cacheResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.HIT).cacheResponse(cacheResponse.get()).apply(cacheRetrieval.strategy::addCacheHeaders).timeRequestSent(requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()));
            }
            cacheRetrieval.closeResponse();
            return NetworkResponse.of(((ResponseBuilder)ResponseBuilder.create().uri(this.request.uri()).request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.HIT).statusCode(304).version(HttpClient.Version.HTTP_1_1).cacheResponse(cacheResponse.get()).headers(cacheResponse.get().headers())).apply(cacheRetrieval.strategy::addCacheHeaders).timeRequestSent(requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()).body(FlowSupport.emptyPublisher()).buildCacheAwareResponse());
        }

        private CompletableFuture<RawResponse> serveFromCacheAfterUpdating(CacheRetrieval cacheRetrieval, NetworkResponse networkResponse) {
            CacheResponse cacheResponse = cacheRetrieval.response;
            CacheResponse updatedCacheResponse = CacheInterceptor.updateCacheResponse(cacheResponse, networkResponse);
            CompletionStage cacheUpdateFuture = ((CompletableFuture)this.cache.update(updatedCacheResponse).thenAccept(updated -> {
                if (updated.booleanValue()) {
                    CacheInterceptor.this.listener.onWriteSuccess(this.request);
                }
            })).exceptionally(exception -> {
                CacheInterceptor.this.listener.onWriteFailure(this.request, (Throwable)exception);
                return null;
            });
            RawResponse servableResponse = updatedCacheResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.CONDITIONAL_HIT).cacheResponse(cacheResponse.get()).networkResponse(networkResponse.get()));
            return CacheInterceptor.this.synchronizeWrites ? ((CompletableFuture)cacheUpdateFuture).thenApply(arg_0 -> Exchange.lambda$serveFromCacheAfterUpdating$21((CacheResponse)servableResponse, arg_0)) : CompletableFuture.completedFuture(servableResponse);
        }

        private RawResponse serveFromNetwork(NetworkResponse networkResponse, @Nullable CacheRetrieval cacheRetrieval) {
            if (cacheRetrieval != null) {
                cacheRetrieval.closeResponse();
            }
            return networkResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.MISS).cacheResponse(cacheRetrieval != null ? cacheRetrieval.response.get() : null).networkResponse(networkResponse.get()));
        }

        private RawResponse serveUnsatisfiableRequest(Instant requestTime, @Nullable CacheRetrieval cacheRetrieval) {
            if (cacheRetrieval != null) {
                cacheRetrieval.closeResponse();
            }
            return NetworkResponse.of(ResponseBuilder.create().uri(this.request.uri()).request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.UNSATISFIABLE).cacheResponse(cacheRetrieval != null ? cacheRetrieval.response.get() : null).statusCode(504).version(HttpClient.Version.HTTP_1_1).timeRequestSent(requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()).body(FlowSupport.emptyPublisher()).buildCacheAwareResponse());
        }

        private static /* synthetic */ RawResponse lambda$serveFromCacheAfterUpdating$21(CacheResponse servableResponse, Void __) {
            return servableResponse;
        }
    }

    private static class CacheRetrieval {
        final CacheResponse response;
        final CacheStrategy strategy;
        final boolean owned;

        CacheRetrieval(CacheResponse response, CacheStrategy strategy) {
            this(response, strategy, true);
        }

        CacheRetrieval(CacheResponse response, CacheStrategy strategy, boolean owned) {
            this.response = response;
            this.strategy = strategy;
            this.owned = owned;
        }

        CacheRetrieval unowned() {
            return new CacheRetrieval(this.response, this.strategy, false);
        }

        void closeResponse() {
            if (this.owned) {
                this.response.close();
            }
        }
    }

    private static final class DrainingBodySubscriber
    implements HttpResponse.BodySubscriber<Void> {
        private final CompletableFuture<Void> completion = new CompletableFuture();
        private final AtomicBoolean subscribed = new AtomicBoolean();

        DrainingBodySubscriber() {
        }

        @Override
        public CompletionStage<Void> getBody() {
            return this.completion;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription);
            if (this.subscribed.compareAndSet(false, true)) {
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            Objects.requireNonNull(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.completion.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            this.completion.complete(null);
        }
    }
}

