/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.internal.cache.Store;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.flow.Upstream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class CacheWritingPublisher
implements Flow.Publisher<List<ByteBuffer>> {
    private static final System.Logger logger = System.getLogger(CacheWritingPublisher.class.getName());
    private static final int SOFT_MAX_BULK_WRITE_SIZE = 8;
    private final Flow.Publisher<List<ByteBuffer>> upstream;
    private final Store.Editor editor;
    private final ByteBuffer metadata;
    private final Executor executor;
    private final Listener listener;
    private final boolean waitForCommit;
    private final AtomicBoolean subscribed = new AtomicBoolean();

    public CacheWritingPublisher(Flow.Publisher<List<ByteBuffer>> upstream, Store.Editor editor, ByteBuffer metadata, Executor executor) {
        this(upstream, editor, metadata, executor, DisabledListener.INSTANCE, false);
    }

    public CacheWritingPublisher(Flow.Publisher<List<ByteBuffer>> upstream, Store.Editor editor, ByteBuffer metadata, Executor executor, Listener listener) {
        this(upstream, editor, metadata, executor, listener, false);
    }

    public CacheWritingPublisher(Flow.Publisher<List<ByteBuffer>> upstream, Store.Editor editor, ByteBuffer metadata, Executor executor, Listener listener, boolean waitForCommit) {
        this.upstream = Objects.requireNonNull(upstream);
        this.editor = Objects.requireNonNull(editor);
        this.metadata = Objects.requireNonNull(metadata);
        this.executor = Objects.requireNonNull(executor);
        this.listener = Objects.requireNonNull(listener);
        this.waitForCommit = waitForCommit;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super List<ByteBuffer>> subscriber) {
        Objects.requireNonNull(subscriber);
        if (this.subscribed.compareAndSet(false, true)) {
            this.upstream.subscribe(new CacheWritingSubscriber(subscriber, this.editor, this.metadata, this.executor, this.listener, this.waitForCommit));
        } else {
            FlowSupport.rejectMulticast(subscriber);
        }
    }

    static final class CacheWritingSubscription
    implements Flow.Subscription {
        private static final VarHandle DOWNSTREAM;
        private static final VarHandle STATE;
        private volatile  @Nullable Flow.Subscriber<? super List<ByteBuffer>> downstream;
        private final Store.Editor editor;
        private final ByteBuffer metadata;
        private final Store.EntryWriter writer;
        private final Executor executor;
        private final Listener listener;
        private final boolean waitForCommit;
        private final Upstream upstream = new Upstream();
        private final ConcurrentLinkedQueue<List<ByteBuffer>> writeQueue = new ConcurrentLinkedQueue();
        private volatile WritingState state = WritingState.IDLE;
        private volatile boolean receivedBodyCompletion;

        CacheWritingSubscription( @NonNull Flow.Subscriber<? super List<ByteBuffer>> downstream, Store.Editor editor, ByteBuffer metadata, Executor executor, Listener listener, boolean waitForCommit) {
            this.downstream = downstream;
            this.editor = editor;
            this.metadata = metadata;
            this.executor = executor;
            this.writer = editor.writer();
            this.listener = listener.guarded();
            this.waitForCommit = waitForCommit;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.getAndClearDownstream();
            this.upstream.cancel();
            if (!this.receivedBodyCompletion) {
                this.discardEdit();
            }
        }

        void onSubscribe(Flow.Subscription subscription) {
            if (this.upstream.setOrCancel(subscription)) {
                Flow.Subscriber<? super List<ByteBuffer>> subscriber = this.downstream;
                if (subscriber != null) {
                    subscriber.onSubscribe(this);
                } else {
                    logger.log(System.Logger.Level.WARNING, "Bad reactive-streams implementation: downstream is disposed (completed, errored) before calling onSubscribe");
                }
            }
        }

        void onNext(List<ByteBuffer> buffers) {
            Flow.Subscriber<? super List<ByteBuffer>> subscriber;
            if (this.state != WritingState.DONE) {
                this.writeQueue.add(buffers.stream().map(ByteBuffer::duplicate).collect(Collectors.toUnmodifiableList()));
                this.tryScheduleWrite(false);
            }
            if ((subscriber = this.downstream) != null) {
                subscriber.onNext(buffers);
            }
        }

        void onError(Throwable exception) {
            this.upstream.clear();
            this.writeQueue.clear();
            this.discardEdit();
            this.listener.onWriteFailure(exception);
            Flow.Subscriber<? super List<ByteBuffer>> subscriber = this.getAndClearDownstream();
            if (subscriber != null) {
                subscriber.onError(exception);
            } else {
                FlowSupport.onDroppedException(exception);
            }
        }

        void onComplete() {
            this.upstream.clear();
            this.receivedBodyCompletion = true;
            this.tryScheduleWrite(false);
            if (!this.waitForCommit || this.state == WritingState.DONE) {
                this.completeDownstream();
            }
        }

        private void completeDownstream() {
            Flow.Subscriber<? super List<ByteBuffer>> subscriber = this.getAndClearDownstream();
            if (subscriber != null) {
                subscriber.onComplete();
            }
        }

        private Flow.Subscriber<? super List<ByteBuffer>> getAndClearDownstream() {
            return DOWNSTREAM.getAndSet(this, null);
        }

        private boolean tryScheduleWrite(boolean maintainWritingState) {
            boolean queueWasEmpty;
            List<ByteBuffer> buffers = null;
            do {
                if ((buffers != null || (buffers = this.writeQueue.peek()) != null) && (maintainWritingState && this.state == WritingState.WRITING || STATE.compareAndSet(this, WritingState.IDLE, WritingState.WRITING))) {
                    List<ByteBuffer> moreBuffers;
                    this.writeQueue.poll();
                    boolean polledMoreBuffers = false;
                    while (buffers.size() < 8 && (moreBuffers = this.writeQueue.poll()) != null) {
                        if (!polledMoreBuffers) {
                            polledMoreBuffers = true;
                            buffers = new ArrayList<ByteBuffer>(buffers);
                        }
                        buffers.addAll(moreBuffers);
                    }
                    if (polledMoreBuffers) {
                        buffers = Collections.unmodifiableList(buffers);
                    }
                    try {
                        this.writer.write(buffers, this.executor).whenComplete((__, ex) -> this.onWriteCompletion((Throwable)ex));
                        return true;
                    }
                    catch (Throwable t) {
                        this.discardEdit();
                        this.listener.onWriteFailure(t);
                        this.completeDownstreamOnDiscardedEdit();
                        return false;
                    }
                }
                queueWasEmpty = buffers == null;
                if (!queueWasEmpty || !this.receivedBodyCompletion || (buffers = this.writeQueue.peek()) != null || !STATE.compareAndSet(this, (Object)(maintainWritingState ? WritingState.WRITING : WritingState.IDLE), WritingState.COMMITTING)) continue;
                try {
                    this.editor.commit(this.metadata, this.executor).whenComplete((__, ex) -> {
                        this.state = WritingState.DONE;
                        this.closeEditor();
                        if (ex != null) {
                            this.listener.onWriteFailure((Throwable)ex);
                        } else {
                            this.listener.onWriteSuccess();
                        }
                        this.completeDownstreamOnCommittedEdit();
                    });
                    return true;
                }
                catch (Throwable t) {
                    this.discardEdit();
                    this.listener.onWriteFailure(t);
                    this.completeDownstreamOnDiscardedEdit();
                    return false;
                }
            } while (queueWasEmpty && buffers != null);
            return false;
        }

        private void onWriteCompletion(@Nullable Throwable exception) {
            if (exception != null) {
                this.discardEdit();
                this.listener.onWriteFailure(exception);
                this.completeDownstreamOnDiscardedEdit();
            } else if (!this.tryScheduleWrite(true) && STATE.compareAndSet(this, WritingState.WRITING, WritingState.IDLE)) {
                this.tryScheduleWrite(false);
            }
        }

        private void discardEdit() {
            WritingState currentState;
            do {
                if ((currentState = this.state) != WritingState.COMMITTING && currentState != WritingState.DONE) continue;
                return;
            } while (!STATE.compareAndSet(this, currentState, WritingState.DONE));
            this.writeQueue.clear();
            this.closeEditor();
        }

        private void closeEditor() {
            try {
                this.editor.close();
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, "Exception thrown when closing the editor", t);
            }
        }

        private void completeDownstreamOnCommittedEdit() {
            if (this.waitForCommit) {
                this.completeDownstream();
            }
        }

        private void completeDownstreamOnDiscardedEdit() {
            if (this.waitForCommit && this.receivedBodyCompletion) {
                this.completeDownstream();
            }
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                DOWNSTREAM = lookup.findVarHandle(CacheWritingSubscription.class, "downstream", Flow.Subscriber.class);
                STATE = lookup.findVarHandle(CacheWritingSubscription.class, "state", WritingState.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        private static enum WritingState {
            IDLE,
            WRITING,
            COMMITTING,
            DONE;

        }
    }

    private static final class CacheWritingSubscriber
    implements Flow.Subscriber<List<ByteBuffer>> {
        private final CacheWritingSubscription downstreamSubscription;

        CacheWritingSubscriber(Flow.Subscriber<? super List<ByteBuffer>> downstream, Store.Editor editor, ByteBuffer metadata, Executor executor, Listener listener, boolean waitForCommit) {
            this.downstreamSubscription = new CacheWritingSubscription(downstream, editor, metadata, executor, listener, waitForCommit);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.downstreamSubscription.onSubscribe(Objects.requireNonNull(subscription));
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            this.downstreamSubscription.onNext(Objects.requireNonNull(item));
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstreamSubscription.onError(Objects.requireNonNull(throwable));
        }

        @Override
        public void onComplete() {
            this.downstreamSubscription.onComplete();
        }
    }

    private static enum DisabledListener implements Listener
    {
        INSTANCE;


        @Override
        public void onWriteSuccess() {
        }

        @Override
        public void onWriteFailure(Throwable exception) {
        }
    }

    public static interface Listener {
        public void onWriteSuccess();

        public void onWriteFailure(Throwable var1);

        default public Listener guarded() {
            return new Listener(){

                @Override
                public void onWriteSuccess() {
                    try {
                        this.onWriteSuccess();
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "Exception thrown by Listener::onWriteSuccess", e);
                    }
                }

                @Override
                public void onWriteFailure(Throwable exception) {
                    try {
                        this.onWriteFailure(exception);
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "Exception thrown by Listener::onWriteFailure", e);
                    }
                }
            };
        }

        public static Listener disabled() {
            return DisabledListener.INSTANCE;
        }
    }
}

