/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.concurrent;

import com.namelessmc.plugin.lib.methanol.internal.Utils;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;

public final class SerialExecutor
implements Executor {
    private static final int RUN = 1;
    private static final int KEEP_ALIVE = 2;
    private static final int SHUTDOWN = 4;
    private static final VarHandle SYNC;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final Executor delegate;
    private volatile int sync;

    public SerialExecutor(Executor delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void execute(Runnable task) {
        if (this.isShutdownBitSet()) {
            throw new RejectedExecutionException("shutdown");
        }
        RunnableDecorator decoratedTask = new RunnableDecorator(task);
        this.taskQueue.add(decoratedTask);
        while (true) {
            int s;
            if (SerialExecutor.isKeepAliveBitSet(s = this.sync)) {
                return;
            }
            if (!SerialExecutor.isRunningBitSet(s)) {
                if (!SYNC.compareAndSet(this, s, s | 1)) continue;
                this.tryStart(decoratedTask);
                return;
            }
            if (SYNC.compareAndSet(this, s, s | 2)) break;
        }
    }

    private void tryStart(RunnableDecorator task) {
        block2: {
            try {
                this.delegate.execute(this::drain);
            }
            catch (Error | RuntimeException e) {
                SYNC.getAndBitwiseAnd(this, -4);
                if (e instanceof RejectedExecutionException && !this.taskQueue.remove(task)) break block2;
                throw e;
            }
        }
    }

    public void shutdown() {
        SYNC.getAndBitwiseOr(this, 4);
    }

    private void drain() {
        boolean interrupted = false;
        while (true) {
            int s;
            Runnable task;
            if ((task = this.taskQueue.poll()) != null) {
                try {
                    interrupted |= Thread.interrupted();
                    task.run();
                }
                catch (Throwable t) {
                    SYNC.getAndBitwiseAnd(this, -4);
                    if (!this.taskQueue.isEmpty()) {
                        try {
                            ForkJoinPool.commonPool().execute(() -> this.execute(() -> {}));
                        }
                        catch (Error | RuntimeException e) {
                            t.addSuppressed(e);
                        }
                    }
                    throw t;
                }
            }
            int unsetBit = ((s = this.sync) & 2) != 0 ? 2 : 1;
            if (SYNC.weakCompareAndSet(this, s, s & ~unsetBit) && unsetBit == 1) break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    boolean isRunningBitSet() {
        return SerialExecutor.isRunningBitSet(this.sync);
    }

    boolean isShutdownBitSet() {
        return SerialExecutor.isShutdownBitSet(this.sync);
    }

    boolean isKeepAliveBitSet() {
        return SerialExecutor.isKeepAliveBitSet(this.sync);
    }

    public String toString() {
        return Utils.toStringIdentityPrefix(this) + "[delegate=" + this.delegate + ", running=" + this.isRunningBitSet() + ", keepAlive=" + this.isKeepAliveBitSet() + ", shutdown=" + this.isShutdownBitSet() + "]";
    }

    private static boolean isRunningBitSet(int s) {
        return (s & 1) != 0;
    }

    private static boolean isShutdownBitSet(int s) {
        return (s & 4) != 0;
    }

    private static boolean isKeepAliveBitSet(int s) {
        return (s & 2) != 0;
    }

    static {
        try {
            SYNC = MethodHandles.lookup().findVarHandle(SerialExecutor.class, "sync", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class RunnableDecorator
    implements Runnable {
        private final Runnable delegate;

        RunnableDecorator(Runnable delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

