/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Delayer;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.flow.SerializedForwardingSubscriber;
import com.namelessmc.plugin.lib.methanol.internal.flow.Upstream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public abstract class TimeoutSubscriber<T, S extends Flow.Subscriber<? super T>>
extends SerializedForwardingSubscriber<T> {
    private static final Future<Void> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private static final VarHandle DEMAND;
    private static final VarHandle TIMEOUT_TASK;
    private final S downstream;
    private final Duration timeout;
    private final Delayer delayer;
    private final Upstream unwrappedUpstream = new Upstream();
    private volatile long demand;
    private volatile TimeoutTask timeoutTask = new TimeoutTask(0L, COMPLETED_FUTURE);

    public TimeoutSubscriber(S downstream, Duration timeout, Delayer delayer) {
        this.downstream = (Flow.Subscriber)Objects.requireNonNull(downstream);
        this.timeout = Utils.requirePositiveDuration(timeout);
        this.delayer = Objects.requireNonNull(delayer);
    }

    protected S delegate() {
        return this.downstream;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (this.unwrappedUpstream.setOrCancel(subscription)) {
            super.onSubscribe(new TimeoutSubscription());
        }
    }

    @Override
    public void onNext(T item) {
        Objects.requireNonNull(item);
        TimeoutTask currentTimeoutTask = this.timeoutTask;
        if (currentTimeoutTask == TimeoutTask.TOMBSTONE) {
            this.upstream.cancel();
            return;
        }
        currentTimeoutTask.cancel();
        long currentDemand = FlowSupport.subtractAndGetDemand(this, DEMAND, 1L);
        if (currentDemand < 0L) {
            this.cancelOnError(this::onError, new IllegalStateException("Getting more items than requested"));
            return;
        }
        super.onNext(item);
        if (currentDemand > 0L) {
            try {
                this.scheduleTimeout(currentTimeoutTask.index + 1L);
            }
            catch (Error | RuntimeException e) {
                this.cancelOnError(this::onError, e);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (this.cancelTimeout()) {
            super.onError(throwable);
        } else {
            FlowSupport.onDroppedException(throwable);
        }
    }

    @Override
    public void onComplete() {
        if (this.cancelTimeout()) {
            super.onComplete();
        }
    }

    private boolean cancelTimeout() {
        TimeoutTask currentTimeoutTask = TIMEOUT_TASK.getAndSet(this, TimeoutTask.TOMBSTONE);
        currentTimeoutTask.cancel();
        return currentTimeoutTask != TimeoutTask.TOMBSTONE;
    }

    private void scheduleTimeout(long newTimeoutIndex) {
        TimeoutTask currentTimeoutTask;
        TimeoutTask newTimeoutTask = null;
        do {
            if ((currentTimeoutTask = this.timeoutTask) == TimeoutTask.TOMBSTONE || newTimeoutIndex <= currentTimeoutTask.index) {
                if (newTimeoutTask != null) {
                    newTimeoutTask.future.cancel(false);
                }
                return;
            }
            if (newTimeoutTask != null) continue;
            newTimeoutTask = new TimeoutTask(newTimeoutIndex, this.delayer.delay(() -> this.onTimeout(newTimeoutIndex), this.timeout, FlowSupport.SYNC_EXECUTOR));
        } while (!TIMEOUT_TASK.compareAndSet(this, currentTimeoutTask, newTimeoutTask));
        currentTimeoutTask.future.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelOnError(Consumer<Throwable> onError, Throwable exception) {
        Flow.Subscription subscription = this.upstream.get();
        try {
            onError.accept(exception);
        }
        finally {
            subscription.cancel();
        }
    }

    protected abstract Throwable timeoutError(long var1, Duration var3);

    private void onTimeout(long timeoutIndex) {
        TimeoutTask currentTimeoutTask = this.timeoutTask;
        if (currentTimeoutTask.index == timeoutIndex && TIMEOUT_TASK.compareAndSet(this, currentTimeoutTask, TimeoutTask.TOMBSTONE)) {
            this.cancelOnError(x$0 -> super.onError((Throwable)x$0), this.timeoutError(timeoutIndex, this.timeout));
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            DEMAND = lookup.findVarHandle(TimeoutSubscriber.class, "demand", Long.TYPE);
            TIMEOUT_TASK = lookup.findVarHandle(TimeoutSubscriber.class, "timeoutTask", TimeoutTask.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class TimeoutTask {
        static final int TOMBSTONE_INDEX = -1;
        static final TimeoutTask TOMBSTONE = new TimeoutTask(-1L, COMPLETED_FUTURE);
        final long index;
        final Future<?> future;

        TimeoutTask(long index, Future<?> future) {
            this.index = index;
            this.future = future;
        }

        void cancel() {
            this.future.cancel(false);
        }
    }

    private final class TimeoutSubscription
    implements Flow.Subscription {
        TimeoutSubscription() {
        }

        @Override
        public void request(long n) {
            long currentIndex = TimeoutSubscriber.this.timeoutTask.index;
            if (currentIndex == -1L) {
                return;
            }
            if (n > 0L && FlowSupport.getAndAddDemand(TimeoutSubscriber.this, DEMAND, n) == 0L) {
                try {
                    TimeoutSubscriber.this.scheduleTimeout(currentIndex + 1L);
                }
                catch (Error | RuntimeException e) {
                    this.cancel();
                    throw e;
                }
            }
            TimeoutSubscriber.this.unwrappedUpstream.request(n);
        }

        @Override
        public void cancel() {
            TimeoutSubscriber.this.cancelTimeout();
            TimeoutSubscriber.this.unwrappedUpstream.cancel();
        }
    }
}

