/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.sponge8;

import com.google.inject.Inject;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.sponge8.Log4jLogger;
import com.namelessmc.plugin.sponge8.SpongeCommandProxy;
import com.namelessmc.plugin.sponge8.SpongeDataSender;
import com.namelessmc.plugin.sponge8.SpongeEventProxy;
import com.namelessmc.plugin.sponge8.SpongeScheduler;
import com.namelessmc.plugin.sponge8.audiences.SpongeAudienceProvider;
import java.nio.file.Path;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartedEngineEvent;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="namelessmc")
public class SpongeNamelessPlugin {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PluginContainer container;

    @Inject
    public SpongeNamelessPlugin(@ConfigDir(sharedRoot=false) @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Logger logger, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PluginContainer container) {
        this.container = container;
        this.plugin = new NamelessPlugin(dataDirectory, new SpongeScheduler(container), config -> new Log4jLogger((ConfigurationHandler)config, logger), Path.of("logs", "latest.log"), "sponge8", Sponge.platform().minecraftVersion().name());
        this.plugin.setAudienceProvider(new SpongeAudienceProvider(this.plugin.config()));
        this.plugin.registerReloadable(new SpongeDataSender(this.plugin));
        Sponge.eventManager().registerListeners(container, (Object)new SpongeEventProxy(this.plugin));
    }

    @Listener
    public void registerCommands(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RegisterCommandEvent<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Command> event) {
        SpongeCommandProxy commandProxy = new SpongeCommandProxy(this.plugin);
        commandProxy.registerCommands(event, this.container);
    }

    @Listener
    public void onStarted(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StartedEngineEvent<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Server> event) {
        this.plugin.load();
    }

    @Listener
    public void reload(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RefreshGameEvent event) {
        this.plugin.unload();
        this.plugin.load();
    }
}

