/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.namelessmc.plugin.bukkit.BukkitNamelessPlugin;
import com.namelessmc.plugin.bukkit.audiences.BukkitNamelessPlayer;
import com.namelessmc.plugin.bukkit.hooks.PapiHook;
import com.namelessmc.plugin.bukkit.hooks.maintenance.MaintenanceStatusProvider;
import com.namelessmc.plugin.common.AbstractDataSender;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.configurate.serialize.SerializationException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public abstract class BukkitDataSender
extends AbstractDataSender {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin;

    protected BukkitDataSender(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin) {
        super(plugin);
        this.plugin = plugin;
        this.bukkitPlugin = bukkitPlugin;
    }

    @Override
    protected void registerCustomProviders() {
        Statistic playStat;
        this.registerGlobalInfoProvider(json -> json.addProperty("max_players", (Number)Bukkit.getServer().getMaxPlayers()));
        MaintenanceStatusProvider maintenance = this.bukkitPlugin.getMaintenanceStatusProvider();
        if (maintenance != null) {
            this.registerGlobalInfoProvider(json -> json.addProperty("maintenance", Boolean.valueOf(maintenance.maintenanceEnabled())));
        }
        ConfigurationNode config = this.getPlugin().config().main().node(new Object[]{"server-data-sender", "placeholders"});
        if (config.node("enabled").getBoolean()) {
            PapiHook papi = this.bukkitPlugin.papi();
            this.registerGlobalInfoProvider(json -> {
                try {
                    JsonObject placeholders = new JsonObject();
                    config.node("global").getList(String.class).forEach(key -> placeholders.addProperty(key, ChatColor.stripColor((String)papi.parse(null, "%" + key + "%"))));
                    json.add("placeholders", (JsonElement)placeholders);
                }
                catch (SerializationException e) {
                    this.plugin.logger().warning("Invalid global placeholders list");
                }
            });
            this.registerPlayerInfoProvider((json, player) -> {
                try {
                    Player bukkitPlayer = ((BukkitNamelessPlayer)player).bukkitPlayer();
                    JsonObject placeholders = new JsonObject();
                    config.node("player").getList(String.class).forEach(key -> placeholders.addProperty(key, ChatColor.stripColor((String)papi.parse(bukkitPlayer, "%" + key + "%"))));
                    json.add("placeholders", (JsonElement)placeholders);
                }
                catch (SerializationException e) {
                    this.plugin.logger().warning("Invalid player placeholders list");
                }
            });
        }
        this.registerPlayerInfoProvider((json, player) -> {
            Player bukkitPlayer = ((BukkitNamelessPlayer)player).bukkitPlayer();
            JsonObject location = new JsonObject();
            Location loc = bukkitPlayer.getLocation();
            location.addProperty("world", loc.getWorld().getName());
            location.addProperty("x", (Number)loc.getBlockX());
            location.addProperty("y", (Number)loc.getBlockY());
            location.addProperty("z", (Number)loc.getBlockZ());
            json.add("location", (JsonElement)location);
        });
        try {
            playStat = Statistic.PLAY_ONE_TICK;
        }
        catch (NoSuchFieldError ignored) {
            try {
                playStat = (Statistic)Statistic.class.getField("PLAY_ONE_MINUTE").get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        Statistic finalPlayStat = Objects.requireNonNull(playStat);
        this.registerPlayerInfoProvider((json, player) -> {
            Player bukkitPlayer = ((BukkitNamelessPlayer)player).bukkitPlayer();
            json.addProperty("playtime", (Number)(bukkitPlayer.getStatistic(finalPlayStat) / 120));
            json.addProperty("ip", bukkitPlayer.getAddress().toString());
        });
    }
}

