/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.event.NamelessJoinEvent;
import com.namelessmc.plugin.common.event.NamelessPlayerBanEvent;
import com.namelessmc.plugin.common.event.NamelessPlayerQuitEvent;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class BukkitEventProxy
implements Listener {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;

    BukkitEventProxy(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerJoinEvent event) {
        Player bukkitPlayer = event.getPlayer();
        NamelessPlayer player = this.plugin.audiences().player(bukkitPlayer.getUniqueId());
        if (player == null) {
            this.plugin.logger().severe("Skipped join event for " + bukkitPlayer.getName() + ", audience is null");
            return;
        }
        this.plugin.events().post(new NamelessJoinEvent(player));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.plugin.events().post(new NamelessPlayerQuitEvent(uuid));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBan(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerKickEvent event) {
        if (event.getPlayer().isBanned()) {
            this.plugin.events().post(new NamelessPlayerBanEvent(event.getPlayer().getUniqueId()));
        }
    }
}

