/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.namelessmc.plugin.bukkit.BukkitCommandProxy;
import com.namelessmc.plugin.bukkit.BukkitEventProxy;
import com.namelessmc.plugin.bukkit.BukkitScheduler;
import com.namelessmc.plugin.bukkit.UserSyncTask;
import com.namelessmc.plugin.bukkit.VaultPermissions;
import com.namelessmc.plugin.bukkit.hooks.PapiHook;
import com.namelessmc.plugin.bukkit.hooks.maintenance.KennyMaintenance;
import com.namelessmc.plugin.bukkit.hooks.maintenance.MaintenanceStatusProvider;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.logger.JulLogger;
import com.namelessmc.plugin.lib.bstats.bukkit.Metrics;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public abstract class BukkitNamelessPlugin
extends JavaPlugin {
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat MaintenanceStatusProvider maintenanceStatusProvider;
    protected final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PapiHook papiHook;

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat MaintenanceStatusProvider getMaintenanceStatusProvider() {
        return this.maintenanceStatusProvider;
    }

    public BukkitNamelessPlugin(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformInternalName) {
        Path dataDirectory = this.getDataFolder().toPath();
        this.plugin = new NamelessPlugin(dataDirectory, new BukkitScheduler(this), config -> new JulLogger((ConfigurationHandler)config, this.getLogger()), Path.of("logs", "latest.log"), platformInternalName, Bukkit.getVersion());
        this.plugin.registerReloadable(new UserSyncTask(this.plugin, this));
        this.plugin.registerPermissionAdapter(new VaultPermissions(this.plugin));
        this.papiHook = this.plugin.registerReloadable(new PapiHook(this, this.plugin));
    }

    public void onEnable() {
        this.configureAudiences();
        this.plugin.load();
        this.initMaintenance();
        new Metrics((Plugin)this, 13396);
        BukkitCommandProxy.registerCommands(this.plugin, this);
        this.getServer().getPluginManager().registerEvents((Listener)new BukkitEventProxy(this.plugin), (Plugin)this);
    }

    public void onDisable() {
        this.plugin.unload();
    }

    protected abstract void configureAudiences();

    public abstract void kickPlayer(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Player var1,  @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat LanguageHandler.Term var2);

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PapiHook papi() {
        return this.papiHook;
    }

    private void initMaintenance() {
        if (!Bukkit.getPluginManager().isPluginEnabled("Maintenance")) {
            return;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Maintenance");
        if (!plugin.getDescription().getAuthors().contains("kennytv")) {
            return;
        }
        String version = plugin.getDescription().getVersion();
        if (!version.startsWith("4")) {
            this.plugin.logger().warning("Ignoring unsupported KennyTV Maintenance version: " + version);
            return;
        }
        this.maintenanceStatusProvider = new KennyMaintenance();
    }
}

