/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.namelessmc.plugin.bukkit.BukkitNamelessPlugin;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.common.command.AbstractScheduler;
import java.time.Duration;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class BukkitScheduler
extends AbstractScheduler {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin plugin;

    BukkitScheduler(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runAsync(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
    }

    @Override
    public void runSync(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitScheduledTask runTimer(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Runnable runnable, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration interval) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        long ticks = interval.toMillis() / 50L;
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, ticks, ticks);
        return new BukkitScheduledTask(task);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitScheduledTask runDelayed(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Runnable runnable, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration delay) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        long ticks = delay.toMillis() / 50L;
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, ticks);
        return new BukkitScheduledTask(task);
    }

    public static class BukkitScheduledTask
    extends AbstractScheduledTask {
        private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitTask task;

        private BukkitScheduledTask(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitTask task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            this.task.cancel();
        }
    }
}

