/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.namelessmc.plugin.bukkit.BukkitNamelessPlugin;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.configurate.serialize.SerializationException;
import com.namelessmc.plugin.lib.nameless-api.FilteredUserListBuilder;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.UserFilter;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class UserSyncTask
implements Runnable,
Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask task;

    UserSyncTask(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin) {
        this.plugin = plugin;
        this.bukkitPlugin = bukkitPlugin;
    }

    @Override
    public void unload() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"user-sync"});
        if (((CommentedConfigurationNode)config.node(new Object[]{"enabled"})).getBoolean()) {
            Duration interval = ConfigurationHandler.getDuration(config.node(new Object[]{"poll-interval"}));
            if (interval == null) {
                this.plugin.logger().warning("User sync poll interval invalid");
                return;
            }
            this.task = this.plugin.scheduler().runTimer(this, interval);
        }
        if (config.hasChild("log")) {
            this.plugin.logger().warning("The 'user-sync' -> 'log' configuration option is no longer used, please remove it from your config file.");
        }
    }

    @Override
    public void run() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"user-sync"});
        Runnable runAfter = null;
        if (((CommentedConfigurationNode)config.node(new Object[]{"whitelist", "enabled"})).getBoolean()) {
            runAfter = this::syncWhitelist;
        }
        if (((CommentedConfigurationNode)config.node(new Object[]{"bans", "enabled"})).getBoolean()) {
            this.syncBans(runAfter);
        } else if (runAfter != null) {
            runAfter.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID> getUuids(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Consumer<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat FilteredUserListBuilder> builderConfigurator) {
        List<NamelessUser> users;
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"user-sync"});
        AbstractLogger logger = this.plugin.logger();
        try {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                logger.warning("Skipped sync, it looks like the API is not working properly.");
                return null;
            }
            FilteredUserListBuilder builder = api.users();
            builder.withFilter(UserFilter.INTEGRATION, "Minecraft");
            builderConfigurator.accept(builder);
            users = builder.makeRequest();
        }
        catch (NamelessException e) {
            logger.warning("An error occurred while getting a list of registered users from the website for the bans sync feature.");
            logger.logException(e);
            return null;
        }
        HashSet<UUID> uuids = new HashSet<UUID>();
        try {
            HashSet<String> excludes = new HashSet<String>(((CommentedConfigurationNode)config.node(new Object[]{"exclude"})).getList(String.class));
            for (NamelessUser user : users) {
                try {
                    UUID uuid = user.minecraftUuid();
                    if (uuid == null) {
                        throw new IllegalStateException("User does not have UUID even though we specifically requested users with Minecraft integration");
                    }
                    if (!excludes.contains(uuid.toString())) {
                        uuids.add(uuid);
                        continue;
                    }
                    logger.fine("Ignoring user " + String.valueOf(uuid));
                }
                catch (NamelessException e) {
                    throw new IllegalStateException("Getting a user uuid should never fail with a network error, it is cached from the listUsers response", e);
                    return uuids;
                }
            }
        }
        catch (SerializationException e) {
            logger.warning("Ignoring invalid excludes");
        }
        return uuids;
    }

    private void syncBans(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Runnable onComplete) {
        AbstractLogger logger = this.plugin.logger();
        logger.fine("Starting bans sync, retrieving list of banned users...");
        this.plugin.scheduler().runAsync(() -> {
            Set<UUID> bannedUuids = this.getUuids(b -> b.withFilter(UserFilter.BANNED, true));
            if (bannedUuids == null) {
                return;
            }
            this.plugin.scheduler().runSync(() -> {
                Set banned = Bukkit.getBannedPlayers();
                for (UUID bannedUuid : bannedUuids) {
                    OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((UUID)bannedUuid);
                    if (banned.contains(bannedPlayer)) continue;
                    banned.add(bannedPlayer);
                    logger.fine("Added " + String.valueOf(bannedUuid) + " to the ban list");
                    if (!bannedPlayer.isOnline()) continue;
                    this.bukkitPlugin.kickPlayer((Player)bannedPlayer, LanguageHandler.Term.USER_SYNC_KICK);
                }
                logger.fine("Retrieving list of unbanned players...");
                this.plugin.scheduler().runAsync(() -> {
                    Set<UUID> unbannedUuids = this.getUuids(b -> b.withFilter(UserFilter.BANNED, false));
                    if (unbannedUuids == null) {
                        return;
                    }
                    this.plugin.scheduler().runSync(() -> {
                        Set banned2 = Bukkit.getBannedPlayers();
                        for (UUID unbannedUuid : unbannedUuids) {
                            OfflinePlayer unbannedPlayer = Bukkit.getOfflinePlayer((UUID)unbannedUuid);
                            if (!banned2.contains(unbannedPlayer)) continue;
                            banned2.remove(unbannedPlayer);
                            logger.fine("Removed " + String.valueOf(unbannedUuid) + " from the ban list");
                        }
                        if (onComplete != null) {
                            onComplete.run();
                        }
                    });
                });
            });
        });
    }

    private void syncWhitelist() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"user-sync", "whitelist"});
        AbstractLogger logger = this.plugin.logger();
        boolean verifiedOnly = ((CommentedConfigurationNode)config.node(new Object[]{"verified-only"})).getBoolean();
        int groupIdOnly = ((CommentedConfigurationNode)config.node(new Object[]{"only-with-group"})).getInt();
        logger.fine("Starting auto-whitelist, retrieving list of registered users...");
        this.plugin.scheduler().runAsync(() -> {
            Set<UUID> websiteUuids = this.getUuids(b -> {
                b.withFilter(UserFilter.BANNED, false);
                if (verifiedOnly) {
                    b.withFilter(UserFilter.VERIFIED, true);
                }
                if (groupIdOnly >= 0) {
                    b.withFilter(UserFilter.GROUP_ID, groupIdOnly);
                }
            });
            if (websiteUuids == null) {
                return;
            }
            this.plugin.scheduler().runSync(() -> {
                logger.fine("Done, updating bukkit whitelist...");
                for (UUID websiteUuid : websiteUuids) {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)websiteUuid);
                    if (player.isWhitelisted()) continue;
                    player.setWhitelisted(true);
                    logger.fine("Added " + (player.getName() == null ? websiteUuid.toString() : player.getName()) + " to the whitelist.");
                }
                logger.fine("Done, now retrieving a list of all users to un-whitelist users who shouldn't be whitelisted...");
                this.plugin.scheduler().runAsync(() -> {
                    Set<UUID> allUuids = this.getUuids(b -> {});
                    if (allUuids == null) {
                        return;
                    }
                    allUuids.removeAll(websiteUuids);
                    this.plugin.scheduler().runSync(() -> {
                        for (UUID toRemove : allUuids) {
                            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)toRemove);
                            if (!player.isWhitelisted()) continue;
                            player.setWhitelisted(false);
                            logger.fine("Removed " + (player.getName() == null ? toRemove.toString() : player.getName()) + " from the whitelist");
                            if (!player.isOnline()) continue;
                            this.bukkitPlugin.kickPlayer((Player)player, LanguageHandler.Term.USER_SYNC_KICK);
                        }
                    });
                });
            });
        });
    }
}

