/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit;

import com.namelessmc.plugin.bukkit.audiences.BukkitNamelessPlayer;
import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class VaultPermissions
extends AbstractPermissions {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Permission permission;

    public VaultPermissions(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        this.permission = null;
    }

    @Override
    public void load() {
        AbstractLogger log = this.plugin.logger();
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            log.fine("Vault is not installed.");
            return;
        }
        RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider == null) {
            log.warning("Vault is installed, but no vault-compatible permissions system is loaded. Is your permissions plugin compatible with Vault?");
            return;
        }
        Permission permission = (Permission)permissionProvider.getProvider();
        if (permission == null) {
            log.warning("Vault is installed, but no vault-compatible permissions system is loaded. Is your permissions plugin compatible with Vault?");
            return;
        }
        if (!permission.hasGroupSupport()) {
            log.warning("Vault is installed, but the loaded permissions system ('" + permission.getName() + "') does not support groups. Is your permissions plugin compatible with Vault?");
            return;
        }
        log.fine("Vault permissions seem to work");
        this.permission = permission;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isUsable() {
        return this.permission != null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> getGroups() {
        if (this.permission == null) {
            throw new AbstractPermissions.ProviderNotUsableException(this);
        }
        return Arrays.stream(this.permission.getGroups()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> getPlayerGroups(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlayer player) {
        if (this.permission == null) {
            throw new AbstractPermissions.ProviderNotUsableException(this);
        }
        Player bukkitPlayer = ((BukkitNamelessPlayer)player).bukkitPlayer();
        return Arrays.stream(this.permission.getPlayerGroups(bukkitPlayer)).collect(Collectors.toUnmodifiableSet());
    }
}

