/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.bukkit.hooks;

import com.namelessmc.plugin.bukkit.BukkitNamelessPlugin;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import com.namelessmc.plugin.lib.nameless-api.modules.store.PaymentsFilter;
import com.namelessmc.plugin.lib.nameless-api.modules.store.StorePayment;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class PapiHook
implements Reloadable,
Listener {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask task;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AtomicBoolean isRunning;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PapiHook. @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Expansion placeholderExpansion;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BiFunction<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Player, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> placeholderParser = new NoopParser();
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Integer> cachedNotificationCount;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Integer> cachedStoreCredits;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StorePayment cachedLastStorePayment;

    public PapiHook(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat BukkitNamelessPlugin bukkitPlugin, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.bukkitPlugin = bukkitPlugin;
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.isRunning = null;
        this.cachedNotificationCount = null;
        this.cachedStoreCredits = null;
        this.cachedLastStorePayment = null;
        HandlerList.unregisterAll((Listener)this);
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
            this.placeholderExpansion = null;
        }
    }

    @Override
    public void load() {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.plugin.logger().fine("PlaceholderAPI plugin is not loaded");
            this.placeholderParser = new NoopParser();
            return;
        }
        this.placeholderParser = PlaceholderAPI::setPlaceholders;
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"retrieve-placeholders"});
        if (((CommentedConfigurationNode)config.node(new Object[]{"enabled"})).getBoolean()) {
            Expansion expansion = new Expansion();
            expansion.register();
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.bukkitPlugin);
            Duration interval = ConfigurationHandler.getDuration(config.node(new Object[]{"interval"}));
            if (interval == null) {
                this.plugin.logger().warning("Placeholder caching interval invalid");
                return;
            }
            this.task = this.plugin.scheduler().runTimer(this::updateCache, interval);
            this.plugin.scheduler().runAsync(this::updateCache);
            this.isRunning = new AtomicBoolean();
            this.cachedNotificationCount = new ConcurrentHashMap<UUID, Integer>();
            this.cachedStoreCredits = new ConcurrentHashMap<UUID, Integer>();
        }
    }

    private void updateCache() {
        if (this.isRunning == null) {
            throw new IllegalStateException("Placeholder caching is disabled");
        }
        Set uuids = Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toUnmodifiableSet());
        this.plugin.scheduler().runAsync(() -> {
            if (this.isRunning.compareAndSet(false, true)) {
                try {
                    NamelessAPI api = this.plugin.apiProvider().api();
                    if (api == null) {
                        this.plugin.logger().fine("Skipped placeholder caching, API connection is broken");
                        return;
                    }
                    if (api.website().modules().contains(NamelessModule.STORE)) {
                        List<StorePayment> payments = api.store().payments(PaymentsFilter.limit(1));
                        if (payments.isEmpty()) {
                            this.cachedLastStorePayment = null;
                        } else if (payments.size() == 1) {
                            this.cachedLastStorePayment = payments.get(0);
                        } else {
                            throw new IllegalStateException(String.valueOf(payments.size()));
                        }
                    }
                    for (UUID uuid : uuids) {
                        this.updatePlayerCache(api, uuid);
                    }
                }
                catch (NamelessException e) {
                    this.plugin.logger().logException(e);
                }
                this.isRunning.set(false);
            }
        });
    }

    private void updatePlayerCache(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID uuid) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        if (this.cachedNotificationCount == null || this.cachedStoreCredits == null) {
            throw new IllegalStateException("Placeholder caching is disabled");
        }
        this.plugin.logger().fine(() -> "Updating notification count placeholder for " + String.valueOf(uuid));
        NamelessUser user = api.userByMinecraftUuid(uuid);
        if (user != null) {
            this.cachedNotificationCount.put(uuid, user.notificationCount());
            if (api.website().modules().contains(NamelessModule.STORE)) {
                this.cachedStoreCredits.put(uuid, user.store().creditsCents());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerQuitEvent event) {
        if (this.cachedNotificationCount == null) {
            this.plugin.logger().severe("On join event called while placeholder caching disabled");
            return;
        }
        this.cachedNotificationCount.remove(event.getPlayer().getUniqueId());
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api != null) {
                try {
                    this.updatePlayerCache(api, event.getPlayer().getUniqueId());
                }
                catch (NamelessException e) {
                    this.plugin.logger().logException(e);
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PlayerQuitEvent event) {
        if (this.cachedNotificationCount == null) {
            this.plugin.logger().severe("On quit event called while placeholder caching disabled");
            return;
        }
        this.cachedNotificationCount.remove(event.getPlayer().getUniqueId());
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String parse(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Player player, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String text) {
        return this.placeholderParser.apply(player, text);
    }

    private class NoopParser
    implements BiFunction<Player, String, String> {
        private NoopParser() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String apply(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Player player, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String text) {
            PapiHook.this.plugin.logger().warning("Attempted to parse placeholder %" + text + "% but PlaceholderAPI integration is not working");
            return text;
        }
    }

    private class Expansion
    extends PlaceholderExpansion {
        private Expansion() {
        }

        public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String onPlaceholderRequest(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Player player, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String identifier) {
            switch (identifier) {
                case "notifications": {
                    if (player == null || PapiHook.this.cachedNotificationCount == null || !PapiHook.this.cachedNotificationCount.containsKey(player.getUniqueId())) {
                        return "?";
                    }
                    return String.valueOf(PapiHook.this.cachedNotificationCount.get(player.getUniqueId()));
                }
                case "store_last_payment_received_username": {
                    return PapiHook.this.cachedLastStorePayment == null ? "" : PapiHook.this.cachedLastStorePayment.receivingCustomer().username();
                }
                case "store_last_payment_paid_username": {
                    return PapiHook.this.cachedLastStorePayment == null ? "" : PapiHook.this.cachedLastStorePayment.payingCustomer().username();
                }
                case "store_last_payment_amount": {
                    return PapiHook.this.cachedLastStorePayment == null ? "" : PapiHook.this.cachedLastStorePayment.amount();
                }
                case "store_last_payment_currency": {
                    return PapiHook.this.cachedLastStorePayment == null ? "" : PapiHook.this.cachedLastStorePayment.currency();
                }
                case "store_last_payment_date": {
                    return PapiHook.this.cachedLastStorePayment == null ? "" : PapiHook.this.plugin.dateFormatter().format(PapiHook.this.cachedLastStorePayment.creationDate());
                }
                case "store_credits": {
                    if (player == null || PapiHook.this.cachedStoreCredits == null || !PapiHook.this.cachedStoreCredits.containsKey(player.getUniqueId())) {
                        return "?";
                    }
                    return String.format("%.2f", Float.valueOf((float)PapiHook.this.cachedStoreCredits.get(player.getUniqueId()).intValue() / 100.0f));
                }
            }
            return null;
        }

        public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getAuthor() {
            return "Derkades";
        }

        public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getIdentifier() {
            return "nameless";
        }

        public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getVersion() {
            return "3.4.2";
        }

        public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean persist() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean canRegister() {
            return true;
        }
    }
}

