/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class GroupSync
implements Reloadable {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String>> playerGroups = new HashMap<UUID, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask task = null;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int serverId;

    GroupSync(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode config = this.plugin.config().main();
        if (!config.node("group-sync", "enabled").getBoolean()) {
            this.plugin.logger().fine("New group sync disabled");
            return;
        }
        this.plugin.logger().fine("Enabling new group sync system");
        this.serverId = config.node("api", "server-id").getInt(0);
        if (this.serverId == 0) {
            this.plugin.logger().warning("Group sync is enabled but server-id is missing or zero. Group sync will not work until server-id is configured in main.yaml.");
            return;
        }
        AbstractPermissions permissions = this.plugin.permissions();
        if (permissions == null) {
            this.plugin.logger().warning("Group sync is enabled, but no permissions adapter is active. Is a supported permissions system installed, like LuckPerms or Vault?");
            return;
        }
        this.plugin.scheduler().runAsync(() -> {
            try {
                NamelessAPI api = this.plugin.apiProvider().api();
                if (api == null) {
                    return;
                }
                if (api.website().parsedVersion().minor() < 1) {
                    this.plugin.logger().warning("Website version is older than v2.1.0+, refusing to enable new group sync system");
                    return;
                }
                this.task = this.plugin.scheduler().runTimer(this::syncGroups, Duration.ofSeconds(10L));
            }
            catch (NamelessException e) {
                this.plugin.logger().logException(e);
            }
        });
    }

    private void syncGroups() {
        AbstractPermissions permissions = this.plugin.permissions();
        if (permissions == null) {
            throw new IllegalStateException("Permissions adapter cannot be null, or this task shouldn't have been registered");
        }
        HashMap<UUID, Set<String>> groupsToSend = new HashMap<UUID, Set<String>>();
        for (NamelessPlayer player : this.plugin.audiences().onlinePlayers()) {
            Set<String> newGroups = permissions.getPlayerGroups(player);
            if (newGroups == null) {
                this.plugin.logger().fine(() -> "Cannot retrieve groups for player: " + player.username());
                continue;
            }
            Set<String> previousGroups = this.playerGroups.get(player.uuid());
            if (previousGroups == null) {
                this.plugin.logger().fine(() -> "Groups not previously known, or manually re-queued for player: " + player.username());
                this.playerGroups.put(player.uuid(), newGroups);
                groupsToSend.put(player.uuid(), newGroups);
                continue;
            }
            if (newGroups.equals(previousGroups)) continue;
            this.plugin.logger().fine(() -> "Groups have changed for player: " + player.username());
            this.playerGroups.put(player.uuid(), newGroups);
            groupsToSend.put(player.uuid(), newGroups);
        }
        if (groupsToSend.isEmpty()) {
            this.plugin.logger().fine("No group changes");
            return;
        }
        this.plugin.logger().fine(() -> "Sending groups for " + groupsToSend.size() + " players");
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            try {
                api.sendMinecraftGroups(this.serverId, groupsToSend);
            }
            catch (NamelessException e) {
                this.plugin.logger().warning("An error occurred while sending player groups to the website, for group sync. The plugin will try again later.");
                if (e instanceof ApiException && ((ApiException)e).apiError() == ApiError.CORE_INVALID_SERVER_ID) {
                    this.plugin.logger().warning("The server id configured in main.yaml is incorrect, or no correct group sync server is selected in StaffCP > Integrations > Minecraft > Minecraft Servers.");
                } else {
                    this.plugin.logger().logException(e);
                }
                for (UUID uuid : groupsToSend.keySet()) {
                    this.playerGroups.remove(uuid);
                }
            }
        });
    }

    public void resetGroups(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlayer player) {
        this.playerGroups.remove(player.uuid());
    }
}

