/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.AbstractScheduledTask;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiError;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.store.PendingCommandsResponse;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class Store
implements Reloadable {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduledTask commandTask;

    public Store(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.commandTask != null) {
            this.commandTask.cancel();
            this.commandTask = null;
        }
    }

    @Override
    public void load() {
        ConfigurationNode commandExecutor = this.plugin.config().modules().node(new Object[]{"store", "command-executor"});
        if (!commandExecutor.node("enabled").getBoolean()) {
            return;
        }
        Duration interval = ConfigurationHandler.getDuration(commandExecutor.node("interval"));
        if (interval == null) {
            this.plugin.logger().warning("Invalid interval for store module command executor");
            return;
        }
        this.commandTask = this.plugin.scheduler().runTimer(this::retrievePendingCommands, interval);
    }

    public void retrievePendingCommands() {
        int connectionId = ((CommentedConfigurationNode)this.plugin.config().modules().node(new Object[]{"store", "connection-id"})).getInt();
        this.plugin.logger().fine("Store: Retrieving pending commands");
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                this.plugin.logger().fine("Store: API is not available");
                return;
            }
            try {
                PendingCommandsResponse pendingCommands = api.store().pendingCommands(connectionId);
                if (pendingCommands.customers().isEmpty()) {
                    this.plugin.logger().fine("Store: nothing to do");
                    return;
                }
                this.plugin.scheduler().runSync(() -> this.runPendingCommands(api, pendingCommands.shouldUseUuids(), pendingCommands.customers()));
            }
            catch (NamelessException e) {
                if (e instanceof ApiException && ((ApiException)e).apiError() == ApiError.STORE_CONNECTION_NOT_FOUND) {
                    this.plugin.logger().warning("Unable to retrieve commands for the Store module, because it is configured with an invalid connection id.");
                }
                this.plugin.logger().logException(e);
            }
        });
    }

    public void runPendingCommands(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean useUuids, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PendingCommandsResponse.PendingCommandsCustomer> customers) {
        ArrayDeque<PendingCommandsResponse.PendingCommand> completedCommands = new ArrayDeque<PendingCommandsResponse.PendingCommand>();
        for (PendingCommandsResponse.PendingCommandsCustomer customer : customers) {
            this.plugin.logger().fine(() -> "Processing commands for customer: " + customer.username());
            NamelessPlayer player = useUuids ? this.plugin.audiences().player(customer.identifierAsUuid()) : this.plugin.audiences().playerByUsername(customer.username());
            for (PendingCommandsResponse.PendingCommand pendingCommand : customer.pendingCommands()) {
                String username;
                String uuid;
                String command = pendingCommand.command();
                if (pendingCommand.isOnlineRequired() && player == null) {
                    this.plugin.logger().fine("Skipped command, player needs to be online: " + command);
                    continue;
                }
                if (player != null) {
                    uuid = NamelessAPI.javaUuidToWebsiteUuid(player.uuid());
                    username = player.username();
                } else {
                    uuid = customer.identifier();
                    username = customer.username();
                }
                if (command.contains("{uuid}")) {
                    if (uuid == null) {
                        this.plugin.logger().warning("Skipped command, contains {uuid} placeholder while UUID is unknown.");
                        continue;
                    }
                    command = command.replace("{uuid}", uuid);
                }
                command = command.replace("{username}", username);
                this.plugin.logger().info("Running command: " + command);
                this.plugin.audiences().console().dispatchCommand(command);
                completedCommands.add(pendingCommand);
            }
        }
        if (completedCommands.isEmpty()) {
            this.plugin.logger().fine("No completed commands");
            return;
        }
        this.plugin.logger().fine(() -> "Sending " + completedCommands.size() + " completed commands to website");
        this.plugin.scheduler().runAsync(() -> this.submitCompletedCommands(api, completedCommands));
    }

    public void submitCompletedCommands(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PendingCommandsResponse.PendingCommand> complete) {
        block2: {
            try {
                api.store().markCommandsExecuted(complete);
            }
            catch (NamelessException e) {
                this.plugin.logger().warning("Failed to mark commands as executed!");
                this.plugin.logger().warning("To prevent commands running in a loop, the store system will shut down (until the next reload).");
                this.plugin.logger().logException(e);
                if (this.commandTask == null) break block2;
                this.commandTask.cancel();
            }
        }
    }
}

