/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.configurate.reactive;

import com.namelessmc.plugin.lib.configurate.reactive.Disposable;
import com.namelessmc.plugin.lib.configurate.reactive.NoOpDisposable;
import com.namelessmc.plugin.lib.configurate.reactive.Processor;
import com.namelessmc.plugin.lib.configurate.reactive.Subscriber;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractProcessor<V, R extends Registration<V>>
implements Processor.Iso<V> {
    private static final int CLOSED_VALUE = -1073741824;
    final AtomicInteger subscriberCount = new AtomicInteger();
    volatile @Nullable Subscriber<V> fallbackHandler;
    protected final Set<R> registrations = ConcurrentHashMap.newKeySet();
    protected final Executor executor;

    protected AbstractProcessor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    protected abstract R createRegistration(Subscriber<? super V> var1);

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        if (this.subscriberCount.get() < 0 || this.subscriberCount.incrementAndGet() <= 0) {
            subscriber.onError(new IllegalStateException("Processor " + this + " is already closed!"));
            this.subscriberCount.set(-1073741824);
            return NoOpDisposable.INSTANCE;
        }
        R reg = this.createRegistration(subscriber);
        this.registrations.add(reg);
        return reg;
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscriberCount.get() > 0;
    }

    @Override
    public void onError(Throwable thrown) {
        Processor.Iso.super.onError(thrown);
        this.onClose();
    }

    @Override
    public void onClose() {
        this.executor.execute(() -> {
            this.subscriberCount.set(-1073741824);
            for (Registration reg : this.registrations) {
                try {
                    reg.onClose();
                }
                catch (Exception exception) {}
            }
            this.registrations.clear();
        });
    }

    protected void forEachOrRemove(Consumer<R> processor) {
        Iterator<R> it = this.registrations.iterator();
        while (it.hasNext()) {
            Registration reg = (Registration)it.next();
            try {
                processor.accept(reg);
            }
            catch (Exception t) {
                it.remove();
                this.subscriberCount.getAndDecrement();
                try {
                    reg.onError(t);
                }
                catch (Exception t2) {
                    Processor.Iso.super.onError(t2);
                }
            }
        }
    }

    @Override
    public void fallbackHandler(@Nullable Subscriber<V> subscriber) {
        this.fallbackHandler = subscriber;
    }

    @Override
    public boolean closeIfUnsubscribed() {
        this.executor.execute(() -> {
            if (this.subscriberCount.compareAndSet(0, -1073741824)) {
                for (Registration reg : this.registrations) {
                    reg.onClose();
                }
                this.registrations.clear();
            }
        });
        return this.subscriberCount.get() <= 0;
    }

    protected static interface Registration<V>
    extends Disposable {
        public void submit(V var1);

        public void onClose();

        public void onError(Throwable var1);
    }
}

