/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.event;

import com.namelessmc.plugin.lib.event.Cancellable;
import com.namelessmc.plugin.lib.event.EventBusImpl;
import com.namelessmc.plugin.lib.event.EventSubscriber;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.event.PostResult;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface EventBus<E> {
    public static <E> @NonNull EventBus<E> create(@NonNull Class<E> type) {
        return EventBus.create(type, Accepts.nonCancelledWhenNotAcceptingCancelled());
    }

    public static <E> @NonNull EventBus<E> create(@NonNull Class<E> type, @NonNull Accepts<E> accepts) {
        return new EventBusImpl<E>(type, accepts);
    }

    public @NonNull Class<E> type();

    public @NonNull PostResult post(@NonNull E var1);

    public boolean subscribed(@NonNull Class<? extends E> var1);

    public <T extends E> @NonNull EventSubscription subscribe(@NonNull Class<T> var1, @NonNull EventSubscriber<? super T> var2);

    public void unsubscribeIf(@NonNull Predicate<EventSubscriber<? super E>> var1);

    public static interface Accepts<E> {
        public static <E> @NonNull Accepts<E> nonCancelledWhenNotAcceptingCancelled() {
            return (type, event, subscriber) -> subscriber.acceptsCancelled() || !(event instanceof Cancellable) || !((Cancellable)event).cancelled();
        }

        public boolean accepts(Class<E> var1, @NonNull E var2, @NonNull EventSubscriber<? super E> var3);
    }
}

