/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.adapter;

import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.MoreBodySubscribers;
import com.namelessmc.plugin.lib.methanol.ResponsePayload;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.adapter.AbstractBodyAdapter;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.adapter.BodyDiscardTimeoutHint;
import com.namelessmc.plugin.lib.methanol.internal.adapter.PayloadHandlerExecutor;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Delayer;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.FallbackExecutorProvider;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Timeout;
import com.namelessmc.plugin.lib.methanol.internal.extensions.ByteBufferBodyPublisher;
import com.namelessmc.plugin.lib.methanol.internal.extensions.Handlers;
import com.namelessmc.plugin.lib.methanol.internal.extensions.PublisherBodySubscriber;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.flow.Upstream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BasicAdapter
extends AbstractBodyAdapter {
    private static final System.Logger logger = System.getLogger(BasicAdapter.class.getName());

    BasicAdapter() {
        super(MediaType.ANY);
    }

    public static BodyAdapter.Encoder encoder() {
        return BasicEncoder.INSTANCE;
    }

    public static BodyAdapter.Decoder decoder() {
        return BasicDecoder.INSTANCE;
    }

    private static final class CancelOnTimeoutBodySubscriber
    implements HttpResponse.BodySubscriber<Void> {
        private final Upstream upstream = new Upstream();
        private final Future<Void> timeoutFuture;

        CancelOnTimeoutBodySubscriber(Timeout bodyDiscardTimeout) {
            this.timeoutFuture = bodyDiscardTimeout.onTimeout(this.upstream::cancel, FlowSupport.SYNC_EXECUTOR);
        }

        @Override
        public CompletionStage<Void> getBody() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.upstream.setOrCancel(subscription)) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            Objects.requireNonNull(item);
        }

        @Override
        public void onError(Throwable throwable) {
            FlowSupport.onDroppedException(Objects.requireNonNull(throwable));
            this.timeoutFuture.cancel(false);
            this.upstream.clear();
        }

        @Override
        public void onComplete() {
            this.timeoutFuture.cancel(false);
            this.upstream.clear();
        }
    }

    private static enum CancellingBodySubscriber implements HttpResponse.BodySubscriber<Void>
    {
        INSTANCE;


        @Override
        public CompletionStage<Void> getBody() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            subscription.cancel();
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
        }

        @Override
        public void onError(Throwable throwable) {
            FlowSupport.onDroppedException(throwable);
        }

        @Override
        public void onComplete() {
        }
    }

    private static final class ResponsePayloadImpl
    implements ResponsePayload {
        private static final Timeout DEFAULT_BODY_DISCARD_TIMEOUT = new Timeout(Duration.ofMillis(500L), Delayer.systemDelayer());
        private final Flow.Publisher<List<ByteBuffer>> publisher;
        private final HttpResponse.ResponseInfo responseInfo;
        private final Supplier<Executor> executorSupplier;
        private final AdapterCodec adapterCodec;
        private final BodyAdapter.Hints hints;
        private boolean closed;

        ResponsePayloadImpl(Flow.Publisher<List<ByteBuffer>> publisher, HttpResponse.ResponseInfo responseInfo, Supplier<Executor> executorSupplier, AdapterCodec adapterCodec, BodyAdapter.Hints hints) {
            this.publisher = Objects.requireNonNull(publisher);
            this.responseInfo = Objects.requireNonNull(responseInfo);
            this.executorSupplier = Objects.requireNonNull(executorSupplier);
            this.adapterCodec = Objects.requireNonNull(adapterCodec);
            this.hints = Objects.requireNonNull(hints);
        }

        @Override
        public boolean is(MediaType mediaType) {
            return mediaType.includes(this.responseInfo.headers().firstValue("Content-Type").map(MediaType::parse).orElse(MediaType.ANY));
        }

        @Override
        public <T> T to(TypeRef<T> typeRef) throws IOException, InterruptedException {
            return Utils.get(this.handleAsync(this.adapterCodec.handlerOf(typeRef, this.hints), FlowSupport.SYNC_EXECUTOR));
        }

        @Override
        public <T> T handleWith(HttpResponse.BodyHandler<T> bodyHandler) throws IOException, InterruptedException {
            return Utils.get(this.handleAsync(Objects.requireNonNull(bodyHandler), FlowSupport.SYNC_EXECUTOR));
        }

        @Override
        public <T> CompletableFuture<T> toAsync(TypeRef<T> typeRef) {
            return this.handleAsync(this.adapterCodec.handlerOf(typeRef, this.hints), this.executorSupplier.get());
        }

        @Override
        public <T> CompletableFuture<T> handleWithAsync(HttpResponse.BodyHandler<T> bodyHandler) {
            return this.handleAsync(Objects.requireNonNull(bodyHandler), this.executorSupplier.get());
        }

        private <T> CompletableFuture<T> handleAsync(HttpResponse.BodyHandler<T> bodyHandler, Executor executor) {
            Validate.requireState(!this.closed, "Closed");
            this.closed = true;
            return Handlers.handleAsync(this.responseInfo, this.publisher, bodyHandler, executor);
        }

        @Override
        public void close() {
            boolean wasOpen = !this.closed;
            this.closed = true;
            if (wasOpen) {
                HttpResponse.BodyHandler discardingBodyHandler = this.responseInfo.version() == HttpClient.Version.HTTP_2 ? __ -> CancellingBodySubscriber.INSTANCE : __ -> new CancelOnTimeoutBodySubscriber(this.hints.get(BodyDiscardTimeoutHint.class).map(BodyDiscardTimeoutHint::timeout).orElse(DEFAULT_BODY_DISCARD_TIMEOUT));
                Handlers.handleAsync(this.responseInfo, this.publisher, discardingBodyHandler, this.executorSupplier.get()).whenComplete((__, ex) -> {
                    if (ex != null) {
                        logger.log(System.Logger.Level.WARNING, "Exception while discarding response body", (Throwable)ex);
                    }
                });
            }
        }
    }

    private static final class BasicDecoder
    extends BasicAdapter
    implements AbstractBodyAdapter.BaseDecoder {
        static final BasicDecoder INSTANCE = new BasicDecoder();
        private static final Map<TypeRef<?>, Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<?>>> DECODERS;

        private static <T> void putDecoder(Map<TypeRef<?>, Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<?>>> decoders, Class<T> type, Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<T>> decoder) {
            decoders.put(TypeRef.of(type), decoder);
        }

        private static <T> void putDecoder(Map<TypeRef<?>, Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<?>>> decoders, TypeRef<T> typeRef, Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<T>> decoder) {
            decoders.put(typeRef, decoder);
        }

        private BasicDecoder() {
        }

        @Override
        public boolean supportsType(TypeRef<?> typeRef) {
            return DECODERS.containsKey(typeRef);
        }

        @Override
        public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> typeRef, BodyAdapter.Hints hints) {
            this.requireSupport(typeRef, hints);
            return Validate.castNonNull(BasicDecoder.decoderOf(typeRef)).apply(hints);
        }

        private static <T> @Nullable Function<? super BodyAdapter.Hints, ? extends HttpResponse.BodySubscriber<T>> decoderOf(TypeRef<T> typeRef) {
            return DECODERS.get(typeRef);
        }

        static {
            LinkedHashMap decoders = new LinkedHashMap();
            BasicDecoder.putDecoder(decoders, String.class, (? super BodyAdapter.Hints hints) -> HttpResponse.BodySubscribers.ofString(hints.mediaTypeOrAny().charsetOrUtf8()));
            BasicDecoder.putDecoder(decoders, InputStream.class, (? super BodyAdapter.Hints __) -> HttpResponse.BodySubscribers.ofInputStream());
            BasicDecoder.putDecoder(decoders, Reader.class, (? super BodyAdapter.Hints hints) -> MoreBodySubscribers.ofReader(hints.mediaTypeOrAny().charsetOrUtf8()));
            BasicDecoder.putDecoder(decoders, byte[].class, (? super BodyAdapter.Hints __) -> HttpResponse.BodySubscribers.ofByteArray());
            BasicDecoder.putDecoder(decoders, ByteBuffer.class, (? super BodyAdapter.Hints __) -> HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofByteArray(), ByteBuffer::wrap));
            BasicDecoder.putDecoder(decoders, ResponsePayload.class, (? super BodyAdapter.Hints hints) -> HttpResponse.BodySubscribers.mapping(new PublisherBodySubscriber(), publisher -> new ResponsePayloadImpl((Flow.Publisher<List<ByteBuffer>>)publisher, hints.responseInfo().orElseThrow(() -> new UnsupportedOperationException("Expected a ResponseInfo hint")), () -> hints.get(PayloadHandlerExecutor.class).map(PayloadHandlerExecutor::get).orElseGet(FallbackExecutorProvider::get), hints.get(AdapterCodec.class).orElseGet(AdapterCodec::installed), (BodyAdapter.Hints)hints)));
            BasicDecoder.putDecoder(decoders, new TypeRef<Stream<String>>(){}, (? super BodyAdapter.Hints hints) -> HttpResponse.BodySubscribers.ofLines(hints.mediaTypeOrAny().charsetOrUtf8()));
            BasicDecoder.putDecoder(decoders, new TypeRef<Flow.Publisher<List<ByteBuffer>>>(){}, (? super BodyAdapter.Hints __) -> new PublisherBodySubscriber());
            BasicDecoder.putDecoder(decoders, Void.class, (? super BodyAdapter.Hints __) -> HttpResponse.BodySubscribers.discarding());
            DECODERS = Collections.unmodifiableMap(decoders);
        }
    }

    private static final class BasicEncoder
    extends BasicAdapter
    implements AbstractBodyAdapter.BaseEncoder {
        static final BasicEncoder INSTANCE = new BasicEncoder();
        private static final Map<TypeRef<?>, BiFunction<?, ? super Charset, ? extends HttpRequest.BodyPublisher>> ENCODERS;

        private static <T> void putEncoder(Map<TypeRef<?>, BiFunction<?, ? super Charset, ? extends HttpRequest.BodyPublisher>> encoders, Class<T> type, BiFunction<? super T, ? super Charset, ? extends HttpRequest.BodyPublisher> encoder) {
            encoders.put(TypeRef.of(type), encoder);
        }

        private static <T> void putEncoder(Map<TypeRef<?>, BiFunction<?, ? super Charset, ? extends HttpRequest.BodyPublisher>> encoders, TypeRef<T> typeRef, BiFunction<? super T, ? super Charset, ? extends HttpRequest.BodyPublisher> encoder) {
            encoders.put(typeRef, encoder);
        }

        private BasicEncoder() {
        }

        @Override
        public boolean supportsType(TypeRef<?> typeRef) {
            return BasicEncoder.encoderOf(typeRef) != null;
        }

        private static HttpRequest.BodyPublisher encodeFile(Path path) {
            try {
                return HttpRequest.BodyPublishers.ofFile(path);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static <T> @Nullable BiFunction<T, Charset, HttpRequest.BodyPublisher> encoderOf(TypeRef<T> right) {
            for (Map.Entry<TypeRef<?>, BiFunction<?, Charset, HttpRequest.BodyPublisher>> entry : ENCODERS.entrySet()) {
                TypeRef<?> left = entry.getKey();
                if (!left.rawType().isAssignableFrom(right.rawType())) continue;
                if (left.isRawType()) {
                    return entry.getValue();
                }
                assert (left.isParameterizedType());
                if (!right.resolveSupertype(left.rawType()).typeArgumentAt(0).flatMap(rightArg -> left.typeArgumentAt(0).map(leftArg -> leftArg.rawType().isAssignableFrom(rightArg.rawType()))).orElse(false).booleanValue()) continue;
                return entry.getValue();
            }
            return null;
        }

        @Override
        public <T> HttpRequest.BodyPublisher toBody(T value, TypeRef<T> typeRef, BodyAdapter.Hints hints) {
            this.requireSupport(typeRef, hints);
            return BasicEncoder.attachMediaType(Validate.castNonNull(BasicEncoder.encoderOf(typeRef)).apply(value, hints.mediaTypeOrAny().charsetOrUtf8()), hints.mediaTypeOrAny());
        }

        static {
            LinkedHashMap encoders = new LinkedHashMap();
            BasicEncoder.putEncoder(encoders, CharSequence.class, (? super T value, ? super Charset charset) -> HttpRequest.BodyPublishers.ofString(value.toString(), charset));
            BasicEncoder.putEncoder(encoders, InputStream.class, (? super T in, ? super Charset __) -> HttpRequest.BodyPublishers.ofInputStream(() -> in));
            BasicEncoder.putEncoder(encoders, byte[].class, (? super T bytes, ? super Charset __) -> HttpRequest.BodyPublishers.ofByteArray(bytes));
            BasicEncoder.putEncoder(encoders, ByteBuffer.class, (? super T buffer, ? super Charset __) -> new ByteBufferBodyPublisher((ByteBuffer)buffer));
            BasicEncoder.putEncoder(encoders, Path.class, (? super T file, ? super Charset __) -> BasicEncoder.encodeFile(file));
            BasicEncoder.putEncoder(encoders, new TypeRef<Supplier<? extends InputStream>>(){}, (? super T supplier, ? super Charset __) -> HttpRequest.BodyPublishers.ofInputStream(supplier));
            BasicEncoder.putEncoder(encoders, new TypeRef<Iterable<byte[]>>(){}, (? super T bytes, ? super Charset __) -> HttpRequest.BodyPublishers.ofByteArrays(bytes));
            ENCODERS = Collections.unmodifiableMap(encoders);
        }
    }
}

