/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.cache.Store;
import com.namelessmc.plugin.lib.methanol.internal.flow.AbstractPollableSubscription;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheReadingPublisher
implements Flow.Publisher<List<ByteBuffer>> {
    private static final System.Logger logger = System.getLogger(CacheReadingPublisher.class.getName());
    private final Store.Viewer viewer;
    private final Executor executor;
    private final Listener listener;
    private final int bufferSize;
    private final AtomicBoolean subscribed = new AtomicBoolean();

    public CacheReadingPublisher(Store.Viewer viewer, Executor executor) {
        this(viewer, executor, DisabledListener.INSTANCE);
    }

    public CacheReadingPublisher(Store.Viewer viewer, Executor executor, Listener listener) {
        this(viewer, executor, listener, Utils.BUFFER_SIZE);
    }

    public CacheReadingPublisher(Store.Viewer viewer, Executor executor, Listener listener, int bufferSize) {
        this.viewer = Objects.requireNonNull(viewer);
        this.executor = Objects.requireNonNull(executor);
        this.listener = Objects.requireNonNull(listener);
        this.bufferSize = bufferSize;
        Validate.requireArgument(bufferSize > 0, "Expected a positive buffer size: %d", bufferSize);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super List<ByteBuffer>> subscriber) {
        Objects.requireNonNull(subscriber);
        if (this.subscribed.compareAndSet(false, true)) {
            new CacheReadingSubscription(subscriber, this.executor, this.viewer, this.listener, this.bufferSize).fireOrKeepAlive();
        } else {
            FlowSupport.rejectMulticast(subscriber);
        }
    }

    static final class CacheReadingSubscription
    extends AbstractPollableSubscription<List<ByteBuffer>> {
        private static final int MAX_BULK_READ_SIZE = 4;
        private static final int PREFETCH = 8;
        private static final VarHandle STATE;
        private final Store.Viewer viewer;
        private final Executor executor;
        private final Store.EntryReader reader;
        private final Listener listener;
        private final int bufferSize;
        private final ConcurrentLinkedQueue<List<ByteBuffer>> readQueue = new ConcurrentLinkedQueue();
        private final AtomicInteger buffersPromised = new AtomicInteger();
        private volatile State state = State.INITIAL;
        private volatile boolean exhausted;

        CacheReadingSubscription(Flow.Subscriber<? super List<ByteBuffer>> downstream, Executor executor, Store.Viewer viewer, Listener listener, int bufferSize) {
            super(downstream, FlowSupport.SYNC_EXECUTOR);
            this.viewer = viewer;
            this.executor = executor;
            this.reader = viewer.newReader();
            this.listener = listener.guarded();
            this.bufferSize = bufferSize;
        }

        @Override
        protected @Nullable List<ByteBuffer> poll() {
            List<ByteBuffer> batch = this.readQueue.poll();
            if (batch != null) {
                this.buffersPromised.getAndAdd(-batch.size());
                batch = this.sliceReadableBuffers(batch);
            }
            if (!this.exhausted) {
                this.tryScheduleRead(false);
            }
            return batch;
        }

        @Override
        protected boolean isComplete() {
            return this.exhausted && this.readQueue.isEmpty();
        }

        @Override
        protected long emit(Flow.Subscriber<? super List<ByteBuffer>> downstream, long emit) {
            if (this.state == State.INITIAL && STATE.compareAndSet(this, State.INITIAL, State.IDLE)) {
                this.tryScheduleRead(false);
            }
            return super.emit(downstream, emit);
        }

        @Override
        protected void abort(boolean flowInterrupted) {
            this.state = State.DONE;
            try {
                this.viewer.close();
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, "Exception while closing viewer", t);
            }
        }

        private boolean tryScheduleRead(boolean maintainReadingState) {
            if (this.buffersPromised.get() < 8 && (maintainReadingState && this.state == State.READING || STATE.compareAndSet(this, State.IDLE, State.READING))) {
                int buffersNeeded = Math.min(8 - this.buffersPromised.get(), 4);
                if (buffersNeeded == 0) {
                    STATE.compareAndSet(this, State.READING, State.IDLE);
                    return false;
                }
                if (buffersNeeded < 0) {
                    throw new AssertionError((Object)("Negative buffersNeeded: " + buffersNeeded));
                }
                List<ByteBuffer> buffers = Stream.generate(() -> ByteBuffer.allocate(this.bufferSize)).limit(buffersNeeded).collect(Collectors.toUnmodifiableList());
                this.buffersPromised.getAndAdd(buffersNeeded);
                try {
                    this.reader.read(buffers, this.executor).whenComplete((read, exception) -> this.onReadCompletion(buffers, (Long)read, (Throwable)exception));
                    return true;
                }
                catch (Throwable t) {
                    this.state = State.DONE;
                    this.listener.onReadFailure(t);
                    this.fireOrKeepAliveOnError(t);
                    return false;
                }
            }
            return false;
        }

        private void onReadCompletion(List<ByteBuffer> buffers, @Nullable Long read, @Nullable Throwable exception) {
            assert (read != null ^ exception != null);
            assert (!buffers.isEmpty());
            if (exception != null) {
                this.state = State.DONE;
                this.listener.onReadFailure(exception);
                this.fireOrKeepAliveOnError(exception);
            } else if (read < 0L) {
                this.state = State.DONE;
                this.exhausted = true;
                this.listener.onReadSuccess();
                this.fireOrKeepAlive();
            } else {
                this.readQueue.add(buffers.stream().map(buffer -> buffer.flip().asReadOnlyBuffer()).collect(Collectors.toUnmodifiableList()));
                if (!this.tryScheduleRead(true) && STATE.compareAndSet(this, State.READING, State.IDLE)) {
                    this.tryScheduleRead(false);
                }
                this.fireOrKeepAliveOnNext();
            }
        }

        private List<ByteBuffer> sliceReadableBuffers(List<ByteBuffer> buffers) {
            if (buffers.get(buffers.size() - 1).hasRemaining()) {
                return buffers;
            }
            ArrayList<ByteBuffer> nonEmptyBuffers = new ArrayList<ByteBuffer>(buffers);
            for (int i = buffers.size() - 1; i >= 0 && !buffers.get(i).hasRemaining(); --i) {
                nonEmptyBuffers.remove(i);
            }
            return Collections.unmodifiableList(nonEmptyBuffers);
        }

        static {
            try {
                STATE = MethodHandles.lookup().findVarHandle(CacheReadingSubscription.class, "state", State.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }

        static enum State {
            INITIAL,
            IDLE,
            READING,
            DONE;

        }
    }

    private static enum DisabledListener implements Listener
    {
        INSTANCE;


        @Override
        public void onReadSuccess() {
        }

        @Override
        public void onReadFailure(Throwable exception) {
        }
    }

    public static interface Listener {
        public void onReadSuccess();

        public void onReadFailure(Throwable var1);

        default public Listener guarded() {
            return new Listener(){

                @Override
                public void onReadSuccess() {
                    try {
                        this.onReadSuccess();
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "Exception thrown by Listener::onReadSuccess", e);
                    }
                }

                @Override
                public void onReadFailure(Throwable exception) {
                    try {
                        this.onReadFailure(exception);
                    }
                    catch (Throwable e) {
                        logger.log(System.Logger.Level.WARNING, "Exception thrown by Listener::onReadFailure", e);
                    }
                }
            };
        }

        public static Listener disabled() {
            return DisabledListener.INSTANCE;
        }
    }
}

