/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CancellationPropagatingFuture<T>
extends CompletableFuture<T> {
    private static final boolean PROPAGATE_CANCELLATION = Boolean.parseBoolean(System.getProperty("com.namelessmc.plugin.lib.methanol.future.propagateCancellation", "true"));
    private final CompletableFuture<Boolean> cancellation;

    private CancellationPropagatingFuture() {
        this.cancellation = new CompletableFuture();
    }

    private CancellationPropagatingFuture(CompletableFuture<Boolean> cancellation) {
        this.cancellation = cancellation;
    }

    private void propagateCancellationTo(CompletionStage<?> stage) {
        this.cancellation.thenAccept(stage.toCompletableFuture()::cancel);
    }

    private void propagateCancellationTo(Consumer<Boolean> cancellable) {
        this.cancellation.thenAccept((Consumer)cancellable);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new CancellationPropagatingFuture<T>(this.cancellation);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenCompose(this.attachTo(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenComposeAsync(this.attachTo(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync(this.attachTo(fn), executor);
    }

    private <U> Function<T, CompletionStage<U>> attachTo(Function<? super T, ? extends CompletionStage<U>> fn) {
        return result -> {
            CompletionStage stage = (CompletionStage)fn.apply(result);
            this.propagateCancellationTo(stage);
            return stage;
        };
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        this.cancellation.complete(mayInterruptIfRunning);
        return true;
    }

    public static <T> CancellationPropagatingFuture<T> create() {
        CancellationPropagatingFuture<T> future = new CancellationPropagatingFuture<T>();
        future.propagateCancellationTo(future::cancel);
        return future;
    }

    public static <T> CompletionStage<T> of(CompletionStage<T> upstream) {
        return !PROPAGATE_CANCELLATION || upstream instanceof CancellationPropagatingFuture ? upstream : CancellationPropagatingFuture.downstreamOf(upstream);
    }

    public static <T> CompletableFuture<T> of(CompletableFuture<T> upstream) {
        return !PROPAGATE_CANCELLATION || upstream instanceof CancellationPropagatingFuture ? upstream : CancellationPropagatingFuture.downstreamOf(upstream);
    }

    private static <T> CancellationPropagatingFuture<T> downstreamOf(CompletionStage<T> upstream) {
        CancellationPropagatingFuture downstream = new CancellationPropagatingFuture();
        downstream.propagateCancellationTo(upstream);
        upstream.whenComplete((? super T result, ? super Throwable exception) -> {
            if (exception != null) {
                downstream.completeExceptionally((Throwable)exception);
            } else {
                downstream.complete(result);
            }
        });
        return downstream;
    }
}

