/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.extensions;

import com.namelessmc.plugin.lib.methanol.HeadersAccumulator;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import java.net.http.HttpHeaders;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class HeadersBuilder {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private @MonotonicNonNull HeadersAccumulatorView lazyAccumulatorView;

    public void add(String name, String value) {
        Utils.requireValidHeader(name, value);
        this.addLenient(name, value);
    }

    public void addAll(String ... headers) {
        Validate.requireArgument(headers.length > 0 && headers.length % 2 == 0, "Expected a even-numbered, positive array length: %d", headers.length);
        for (int i = 0; i < headers.length; i += 2) {
            this.add(headers[i], headers[i + 1]);
        }
    }

    public void addAll(HttpHeaders headers) {
        headers.map().forEach((name, values) -> {
            List myValues = this.headers.computeIfAbsent(Utils.requireValidHeaderName(name), __ -> new ArrayList());
            values.forEach(value -> myValues.add(Utils.requireValidHeaderValue(value)));
        });
    }

    public void addAll(HeadersBuilder builder) {
        this.addAllLenient(builder.headers);
    }

    public void addLenient(String name, String value) {
        this.headers.computeIfAbsent(Objects.requireNonNull(name), __ -> new ArrayList()).add(Objects.requireNonNull(value));
    }

    public void addAllLenient(HttpHeaders headers) {
        this.addAllLenient(headers.map());
    }

    private void addAllLenient(Map<String, List<String>> headers) {
        headers.forEach((name, values) -> this.headers.computeIfAbsent((String)name, __ -> new ArrayList()).addAll(values));
    }

    public void set(String name, String value) {
        this.set(name, List.of(value));
    }

    public void set(String name, List<String> values) {
        Utils.requireValidHeaderName(name);
        List myValues = this.headers.computeIfAbsent(name, __ -> new ArrayList());
        myValues.clear();
        values.forEach(value -> myValues.add(Utils.requireValidHeaderValue(value)));
    }

    public void setIfAbsent(String name, String value) {
        this.setIfAbsent(name, List.of(value));
    }

    public void setIfAbsent(String name, List<String> values) {
        Utils.requireValidHeaderName(name);
        this.headers.computeIfAbsent(name, __ -> {
            ArrayList myValues = new ArrayList();
            values.forEach(value -> myValues.add(Utils.requireValidHeaderValue(value)));
            return myValues;
        });
    }

    public void setLenient(String name, List<String> values) {
        List myValues = this.headers.computeIfAbsent(name, __ -> new ArrayList());
        myValues.clear();
        myValues.addAll(values);
    }

    public boolean remove(String name) {
        return this.headers.remove(Objects.requireNonNull(name)) != null;
    }

    public boolean removeIf(BiPredicate<String, String> filter) {
        Objects.requireNonNull(filter);
        boolean mutated = false;
        Iterator<Map.Entry<String, List<String>>> iterator = this.headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            String name = entry.getKey();
            List<String> values = entry.getValue();
            mutated |= values.removeIf((? super E value) -> filter.test(name, (String)value));
            if (!values.isEmpty()) continue;
            iterator.remove();
        }
        return mutated;
    }

    public void clear() {
        this.headers.clear();
    }

    public Optional<String> lastValue(String name) {
        List<String> values = this.headers.get(name);
        return values != null ? Optional.of(values.get(values.size() - 1)) : Optional.empty();
    }

    public HttpHeaders build() {
        return HttpHeaders.of(this.headers, (n, v) -> true);
    }

    public HeadersAccumulator<?> asHeadersAccumulator() {
        return this.lazyAccumulatorView != null ? this.lazyAccumulatorView : (this.lazyAccumulatorView = new HeadersAccumulatorView());
    }

    private final class HeadersAccumulatorView
    implements HeadersAccumulator<HeadersAccumulatorView> {
        private HeadersAccumulatorView() {
        }

        @Override
        public HeadersAccumulatorView header(String name, String value) {
            HeadersBuilder.this.add(name, value);
            return this;
        }

        @Override
        public HeadersAccumulatorView headers(String ... headers) {
            HeadersBuilder.this.addAll(headers);
            return this;
        }

        @Override
        public HeadersAccumulatorView headers(HttpHeaders headers) {
            HeadersBuilder.this.addAll(headers);
            return this;
        }

        @Override
        public HeadersAccumulatorView setHeader(String name, String value) {
            HeadersBuilder.this.set(name, value);
            return this;
        }

        @Override
        public HeadersAccumulatorView setHeader(String name, List<String> values) {
            HeadersBuilder.this.set(name, values);
            return this;
        }

        @Override
        public HeadersAccumulatorView setHeaderIfAbsent(String name, String value) {
            HeadersBuilder.this.setIfAbsent(name, value);
            return this;
        }

        @Override
        public HeadersAccumulatorView setHeaderIfAbsent(String name, List<String> values) {
            HeadersBuilder.this.setIfAbsent(name, values);
            return this;
        }

        @Override
        public HeadersAccumulatorView removeHeaders() {
            HeadersBuilder.this.clear();
            return this;
        }

        @Override
        public HeadersAccumulatorView removeHeader(String name) {
            HeadersBuilder.this.remove(name);
            return this;
        }

        @Override
        public HeadersAccumulatorView removeHeadersIf(BiPredicate<String, String> filter) {
            HeadersBuilder.this.removeIf(filter);
            return this;
        }
    }
}

