/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public abstract class AbstractSubscription<T>
implements Flow.Subscription {
    private static final System.Logger logger = System.getLogger(AbstractSubscription.class.getName());
    private static final int RUNNING = 1;
    private static final int KEEP_ALIVE = 2;
    private static final int SUBSCRIBED = 4;
    private static final int ERROR = 8;
    private static final int CANCELLED = 16;
    private static final VarHandle SYNC;
    private static final VarHandle PENDING_EXCEPTION;
    private static final VarHandle DEMAND;
    private final Flow.Subscriber<? super T> downstream;
    private final Executor executor;
    private volatile int sync;
    private volatile long demand;
    private volatile @MonotonicNonNull Throwable pendingException;

    protected AbstractSubscription(Flow.Subscriber<? super T> downstream, Executor executor) {
        this.downstream = Objects.requireNonNull(downstream);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public final void request(long n) {
        if (n > 0L) {
            FlowSupport.getAndAddDemand(this, DEMAND, n);
            this.fireOrKeepAlive();
        } else {
            this.fireOrKeepAliveOnError(FlowSupport.illegalRequest());
        }
    }

    @Override
    public final void cancel() {
        if ((this.getAndBitwiseOrSync(16) & 0x10) == 0) {
            this.guardedAbort(true);
            this.consumePendingException();
        }
    }

    public void fireOrKeepAlive() {
        if ((this.sync & 2) == 0 && (this.getAndBitwiseOrSync(3) & 0x11) == 0) {
            this.fire();
        }
    }

    public void fireOrKeepAliveOnNext() {
        if (this.demand > 0L) {
            this.fireOrKeepAlive();
        }
    }

    public void fireOrKeepAliveOnError(Throwable exception) {
        Objects.requireNonNull(exception);
        boolean produced = PENDING_EXCEPTION.compareAndSet(this, null, exception);
        if (produced && (this.getAndBitwiseOrSync(11) & 0x11) == 0) {
            this.fire();
        } else if (!produced) {
            FlowSupport.onDroppedException(exception);
        }
    }

    private void fire() {
        try {
            this.executor.execute(this::drain);
        }
        catch (Error | RuntimeException e) {
            logger.log(System.Logger.Level.ERROR, "Couldn't execute subscription's signaller task", e);
            this.cancel();
            throw e;
        }
    }

    protected abstract long emit(Flow.Subscriber<? super T> var1, long var2);

    private long guardedEmit(Flow.Subscriber<? super T> downstream, long emit) {
        try {
            return this.emit(downstream, emit);
        }
        catch (Throwable t) {
            this.cancelOnError(downstream, t, true);
            return -1L;
        }
    }

    protected void abort(boolean flowInterrupted) {
    }

    private void guardedAbort(boolean flowInterrupted) {
        try {
            this.abort(flowInterrupted);
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.WARNING, "Exception thrown during subscription cancellation", t);
        }
    }

    private void consumePendingException() {
        Throwable exception = PENDING_EXCEPTION.getAndSet(this, ConsumedPendingException.INSTANCE);
        if (exception != null && exception != ConsumedPendingException.INSTANCE) {
            FlowSupport.onDroppedException(exception);
        }
    }

    protected final boolean isCancelled() {
        return (this.sync & 0x10) != 0;
    }

    protected final boolean hasPendingErrors() {
        return (this.sync & 8) != 0;
    }

    protected final void cancelOnError(Flow.Subscriber<? super T> downstream, Throwable exception, boolean flowInterrupted) {
        if ((this.getAndBitwiseOrSync(16) & 0x10) == 0) {
            this.guardedAbort(flowInterrupted);
            if (flowInterrupted) {
                this.consumePendingException();
            }
            try {
                downstream.onError(exception);
            }
            catch (Throwable t) {
                t.addSuppressed(exception);
                logger.log(System.Logger.Level.WARNING, "Exception thrown by subscriber's onError", t);
            }
        } else {
            FlowSupport.onDroppedException(exception);
        }
    }

    protected final void cancelOnComplete(Flow.Subscriber<? super T> downstream) {
        if ((this.getAndBitwiseOrSync(16) & 0x10) == 0) {
            this.guardedAbort(false);
            this.consumePendingException();
            try {
                downstream.onComplete();
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, () -> "Exception thrown by subscriber's onComplete: " + downstream, t);
            }
        }
    }

    protected final boolean submitOnNext(Flow.Subscriber<? super T> downstream, T item) {
        if ((this.sync & 0x18) == 0) {
            try {
                downstream.onNext(item);
                return true;
            }
            catch (Throwable t) {
                this.cancelOnError(downstream, t, true);
            }
        }
        return false;
    }

    private void drain() {
        int s;
        Flow.Subscriber<? super T> d = this.downstream;
        this.subscribeOnDrain(d);
        long x = 0L;
        long r = this.demand;
        while (((s = this.sync) & 0x10) == 0) {
            int unsetBit;
            if ((s & 8) != 0) {
                Throwable exception = PENDING_EXCEPTION.getAndSet(this, ConsumedPendingException.INSTANCE);
                this.cancelOnError(d, Validate.castNonNull(exception), false);
                continue;
            }
            long emitted = this.guardedEmit(d, r - x);
            if (emitted > 0L) {
                x += emitted;
                continue;
            }
            if (emitted < 0L) {
                return;
            }
            if (x > 0L) {
                r = FlowSupport.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                continue;
            }
            if (r != (r = this.demand) || !SYNC.compareAndSet(this, s, s & ~(unsetBit = (s & 2) == 0 ? 1 : 2)) || unsetBit != 1) continue;
            return;
        }
    }

    private void subscribeOnDrain(Flow.Subscriber<? super T> downstream) {
        if ((this.sync & 4) == 0 && (this.getAndBitwiseOrSync(4) & 0x14) == 0) {
            try {
                downstream.onSubscribe(this);
            }
            catch (Throwable t) {
                this.cancelOnError(downstream, t, true);
            }
        }
    }

    private int getAndBitwiseOrSync(int bits) {
        return SYNC.getAndBitwiseOr(this, bits);
    }

    protected long currentDemand() {
        return this.demand;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            SYNC = lookup.findVarHandle(AbstractSubscription.class, "sync", Integer.TYPE);
            DEMAND = lookup.findVarHandle(AbstractSubscription.class, "demand", Long.TYPE);
            PENDING_EXCEPTION = lookup.findVarHandle(AbstractSubscription.class, "pendingException", Throwable.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class ConsumedPendingException
    extends Exception {
        static final ConsumedPendingException INSTANCE = new ConsumedPendingException();

        private ConsumedPendingException() {
            super("", null, false, false);
        }
    }
}

