/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.flow;

import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.flow.Upstream;

public final class Prefetcher {
    private final int prefetch;
    private final int consumedLimit;
    private int consumed;

    public Prefetcher() {
        this(FlowSupport.prefetch(), FlowSupport.prefetchThreshold());
    }

    public Prefetcher(int prefetch, int prefetchThreshold) {
        Validate.requireArgument(prefetch > 0 && prefetchThreshold >= 0 && prefetchThreshold <= prefetch, "Illegal prefetch and/or prefetchThreshold");
        this.prefetch = prefetch;
        this.consumedLimit = prefetch - prefetchThreshold;
    }

    public void initialize(Upstream upstream) {
        upstream.request(this.prefetch);
    }

    public void update(Upstream upstream) {
        int c;
        if ((c = ++this.consumed) >= this.consumedLimit) {
            this.consumed = 0;
            upstream.request(c);
        }
    }

    int prefetch() {
        return this.prefetch;
    }

    int prefetchThreshold() {
        return this.prefetch - this.consumedLimit;
    }

    int currentWindow() {
        return this.prefetch - this.consumed;
    }
}

