/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api.modules.store;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.RequestHandler;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.modules.NamelessModule;
import com.namelessmc.plugin.lib.nameless-api.modules.store.PaymentsFilter;
import com.namelessmc.plugin.lib.nameless-api.modules.store.PendingCommandsResponse;
import com.namelessmc.plugin.lib.nameless-api.modules.store.StoreCategory;
import com.namelessmc.plugin.lib.nameless-api.modules.store.StorePayment;
import com.namelessmc.plugin.lib.nameless-api.modules.store.StoreProduct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class StoreAPI {
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat RequestHandler requests;

    public StoreAPI(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        this.api = api;
        this.requests = api.requests();
        this.api.ensureModuleInstalled(NamelessModule.STORE);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StoreProduct> products() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("store/products", new Object[0]);
        JsonArray productsJson = response.getAsJsonArray("products");
        ArrayList<StoreProduct> products = new ArrayList<StoreProduct>(productsJson.size());
        for (JsonElement productElement : productsJson) {
            products.add(new StoreProduct(productElement.getAsJsonObject()));
        }
        return Collections.unmodifiableList(products);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StorePayment> payments(PaymentsFilter ... filters) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        Object[] params = new Object[filters.length * 2];
        for (int i = 0; i < filters.length; ++i) {
            params[i * 2] = filters[i].name();
            params[i * 2 + 1] = filters[i].value();
        }
        JsonObject response = this.requests.get("store/payments", params);
        JsonArray paymentsJson = response.getAsJsonArray("payments");
        ArrayList<StorePayment> payments = new ArrayList<StorePayment>(paymentsJson.size());
        for (JsonElement productElement : paymentsJson) {
            payments.add(new StorePayment(this.api, productElement.getAsJsonObject()));
        }
        return Collections.unmodifiableList(payments);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat StoreCategory> categories() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("store/products", new Object[0]);
        JsonArray array = response.getAsJsonArray("categories");
        ArrayList<StoreCategory> categories = new ArrayList<StoreCategory>(array.size());
        for (JsonElement element : array) {
            categories.add(new StoreCategory(element.getAsJsonObject()));
        }
        return Collections.unmodifiableList(categories);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PendingCommandsResponse pendingCommands(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int connectionId) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonObject response = this.requests.get("store/pending-commands", "connection_id", connectionId);
        return new PendingCommandsResponse(this.api, response);
    }

    public void markCommandsExecuted(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PendingCommandsResponse.PendingCommand> commands) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessException {
        JsonArray array = new JsonArray(commands.size());
        for (PendingCommandsResponse.PendingCommand command : commands) {
            array.add((Number)command.id());
        }
        JsonObject body = new JsonObject();
        body.add("commands", (JsonElement)array);
        this.requests.post("store/commands-executed", body);
    }
}

