/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.namelessmc.plugin.bukkit.BukkitDataSender;
import com.namelessmc.plugin.bukkit.audiences.BukkitNamelessPlayer;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.paper.PaperNamelessPlugin;
import java.net.URL;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.profile.PlayerTextures;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class PaperDataSender
extends BukkitDataSender {
    protected PaperDataSender(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat PaperNamelessPlugin bukkitPlugin) {
        super(plugin, bukkitPlugin);
    }

    @Override
    protected void registerCustomProviders() {
        super.registerCustomProviders();
        this.registerPlayerInfoProvider((json, namelessPlayer) -> {
            Player player = ((BukkitNamelessPlayer)namelessPlayer).bukkitPlayer();
            if (player == null) {
                throw new IllegalStateException();
            }
            PlayerProfile profile = player.getPlayerProfile();
            PlayerTextures textures = profile.getTextures();
            JsonObject skinJson = new JsonObject();
            skinJson.addProperty("model", textures.getSkinModel().toString().toLowerCase());
            URL skin = textures.getSkin();
            URL cape = textures.getCape();
            if (skin != null) {
                skinJson.addProperty("skin", skin.toString());
            }
            if (cape != null) {
                skinJson.addProperty("cape", cape.toString());
            }
            json.add("skin", (JsonElement)skinJson);
        });
        this.registerGlobalInfoProvider(json -> {
            Component motd = Bukkit.getServer().motd();
            String legacyMotd = LegacyComponentSerializer.legacySection().serialize(motd);
            json.addProperty("motd", legacyMotd);
        });
    }
}

