/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.event.NamelessJoinEvent;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.UUID;

public class JoinNotRegisteredMessage
implements Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventSubscription subscription;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String registerCommand;

    JoinNotRegisteredMessage(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode conf = this.plugin.config().main();
        if (!conf.node("not-registered-join-message").getBoolean()) {
            return;
        }
        CommentedConfigurationNode commands = this.plugin.config().commands();
        if (!commands.hasChild("register")) {
            this.plugin.logger().warning("not-registered-join-message is enabled, but the register command is disabled");
            return;
        }
        this.registerCommand = commands.node("register").getString();
        this.subscription = this.plugin.events().subscribe(NamelessJoinEvent.class, event -> this.onJoin(event.player().uuid()));
    }

    private void onJoin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID uuid) {
        String registerCommand = this.registerCommand;
        if (registerCommand == null) {
            throw new IllegalStateException("Register command cannot be null");
        }
        this.plugin.scheduler().runAsync(() -> {
            NamelessUser user;
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            try {
                user = api.userByMinecraftUuid(uuid);
            }
            catch (NamelessException e) {
                this.plugin.logger().logException(e);
                return;
            }
            if (user == null) {
                this.plugin.scheduler().runSync(() -> {
                    NamelessPlayer audience = this.plugin.audiences().player(uuid);
                    if (audience != null) {
                        Component message = this.plugin.language().get(LanguageHandler.Term.JOIN_NOT_REGISTERED, "register_command", registerCommand);
                        audience.sendMessage(message);
                    }
                });
            }
        });
    }
}

