/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.adventure.text.minimessage.MiniMessage;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.resolver.Placeholder;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.configurate.yaml.YamlConfigurationLoader;
import com.namelessmc.plugin.lib.derkutils.FileUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class LanguageHandler
implements Reloadable {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int VERSION = 36;
    public static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> LANGUAGES = Set.of("ar_SA", "cs_CZ", "da_DK", "de_DE", "el_GR", "en_UK", "en_US", "es_419", "es_ES", "fa_IR", "fr_FR", "he_IL", "hr_HR", "hu_HU", "id_ID", "it_IT", "ja_JP", "ko_KR", "lt_LT", "nb_NO", "nl_NL_form", "nl_NL", "pl_PL", "pt_BR", "ro_RO", "ru_RU", "sk_SK", "sq_AL", "sr_RS", "sv_SE", "tr_TR", "uk_UA", "vi_VN", "zh_CN");
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String DEFAULT_LANGUAGE = "en_UK";
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String VERSION_FILE_NAME = ".VERSION_DO_NOT_DELETE.dat";
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String activeLanguageCode;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationNode fallbackLanguageFile;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationNode activeLanguageFile;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path languageDirectory;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger;

    public LanguageHandler(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger) {
        this.dataDirectory = dataDirectory;
        this.languageDirectory = dataDirectory.resolve("languages");
        this.config = config;
        this.logger = logger;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String getActiveLanguageCode() {
        return this.activeLanguageCode;
    }

    @Override
    public void unload() {
        this.activeLanguageCode = null;
        this.fallbackLanguageFile = null;
        this.activeLanguageFile = null;
    }

    @Override
    public void load() {
        try {
            this.updateFiles();
            this.setActiveLanguage(((CommentedConfigurationNode)this.config.main().node(new Object[]{"language"})).getString(DEFAULT_LANGUAGE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String raw(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Term term) {
        String message = this.activeLanguageFile.node(term.path).getString();
        if (message == null) {
            this.logger.warning("Message '" + Arrays.toString(term.path) + "' missing from language file, using EnglishUK as fallback. Please help translate: https://translate.namelessmc.com");
            message = this.fallbackLanguageFile.node(term.path).getString();
        }
        return Objects.requireNonNull(message, "Message '" + Arrays.toString(term.path) + "' missing from base language file. This is a bug, please report it.");
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Component get(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Term term) {
        return MiniMessage.miniMessage().deserialize(this.raw(term));
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Component get(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Term term, String ... placeholders) {
        TagResolver[] resolvers = new TagResolver[placeholders.length / 2];
        for (int i = 0; i < placeholders.length; i += 2) {
            resolvers[i / 2] = Placeholder.parsed(placeholders[i], placeholders[i + 1]);
        }
        return MiniMessage.miniMessage().deserialize(this.raw(term), resolvers);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Component get(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Term term, TagResolver ... resolvers) {
        return MiniMessage.miniMessage().deserialize(this.raw(term), resolvers);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Component booleanText(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isYes, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean yesIsPositive) {
        if (isYes) {
            if (yesIsPositive) {
                return this.get(Term.BOOLEAN_YES_POSITIVE);
            }
            return this.get(Term.BOOLEAN_YES_NEGATIVE);
        }
        if (yesIsPositive) {
            return this.get(Term.BOOLEAN_NO_NEGATIVE);
        }
        return this.get(Term.BOOLEAN_NO_POSITIVE);
    }

    private void updateFiles() throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat IOException {
        Files.createDirectories(this.languageDirectory, new FileAttribute[0]);
        Path versionFile = this.languageDirectory.resolve(VERSION_FILE_NAME);
        if (Files.exists(versionFile, new LinkOption[0])) {
            String versionContent = Files.readString(versionFile);
            if (versionContent.equals(String.valueOf(36))) {
                return;
            }
            this.logger.warning("Language files are outdated!");
            this.logger.info("Making backup of old languages directory");
            Path dest = this.dataDirectory.resolve("languages-backup-" + System.currentTimeMillis());
            Files.move(this.languageDirectory, dest, new CopyOption[0]);
            Files.createDirectory(this.languageDirectory, new FileAttribute[0]);
        } else {
            this.logger.info("Languages appear to not be installed yet.");
        }
        this.logger.info("Installing language files");
        for (String languageName : LANGUAGES) {
            String languagePathInJar = "languages/" + languageName + ".yaml";
            Path dest = this.languageDirectory.resolve(languageName + ".yaml");
            FileUtils.copyOutOfJar(LanguageHandler.class, languagePathInJar, dest);
        }
        this.logger.info("Creating version file");
        byte[] bytes = String.valueOf(36).getBytes(StandardCharsets.UTF_8);
        Files.write(versionFile, bytes, new OpenOption[0]);
        this.logger.info("Done");
    }

    private @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat CommentedConfigurationNode readLanguageFile(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String languageName) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat IOException {
        Path path = this.languageDirectory.resolve(languageName + ".yaml");
        return (CommentedConfigurationNode)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).build().load();
    }

    private void setActiveLanguage(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String languageCode) throws @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat IOException {
        if (!LANGUAGES.contains(languageCode)) {
            this.logger.severe("Language '" + languageCode + "' not known, using default language.");
            this.setActiveLanguage(DEFAULT_LANGUAGE);
            return;
        }
        this.activeLanguageCode = languageCode;
        this.activeLanguageFile = this.readLanguageFile(languageCode);
        this.fallbackLanguageFile = languageCode.equals(DEFAULT_LANGUAGE) ? this.activeLanguageFile : this.readLanguageFile(DEFAULT_LANGUAGE);
    }

    public static enum Term {
        ERROR_WEBSITE_USERNAME_NOT_EXIST("error", "website-username-not-exist"),
        ERROR_DISCORD_USERNAME_NOT_EXIST("error", "discord-username-not-exist"),
        ERROR_MINECRAFT_UUID_NOT_EXIST("error", "minecraft-uuid-not-exist"),
        ERROR_TARGET_NO_WEBSITE_ACCOUNT("error", "target-no-website-account"),
        ERROR_WEBSITE_CONNECTION("error", "website-connection"),
        ERROR_USERNAME_NOT_ONLINE("error", "username-not-online"),
        PLAYER_SELF_NOT_REGISTERED("player", "self", "not-registered"),
        PLAYER_SELF_COMMAND_BANNED("player", "self", "command-banned"),
        BOOLEAN_YES_POSITIVE("boolean", "yes-positive"),
        BOOLEAN_YES_NEGATIVE("boolean", "yes-negative"),
        BOOLEAN_NO_POSITIVE("boolean", "no-positive"),
        BOOLEAN_NO_NEGATIVE("boolean", "no-negative"),
        COMMAND_NOT_A_PLAYER("command", "not-a-player"),
        COMMAND_NO_PERMISSION("command", "no-permission"),
        COMMAND_NOTIFICATIONS_USAGE("command", "notifications", "usage"),
        COMMAND_NOTIFICATIONS_DESCRIPTION("command", "notifications", "description"),
        COMMAND_NOTIFICATIONS_OUTPUT_NO_NOTIFICATIONS("command", "notifications", "output", "no-notifications"),
        COMMAND_NOTIFICATIONS_OUTPUT_NOTIFICATION("command", "notifications", "output", "notification"),
        COMMAND_PLUGIN_USAGE("command", "plugin", "usage"),
        COMMAND_PLUGIN_DESCRIPTION("command", "plugin", "description"),
        COMMAND_PLUGIN_OUTPUT_RELOAD_SUCCESSFUL("command", "plugin", "output", "reload-successful"),
        COMMAND_REGISTER_USAGE("command", "register", "usage"),
        COMMAND_REGISTER_DESCRIPTION("command", "register", "description"),
        COMMAND_REGISTER_OUTPUT_SUCCESS_EMAIL("command", "register", "output", "success", "email"),
        COMMAND_REGISTER_OUTPUT_SUCCESS_LINK("command", "register", "output", "success", "link"),
        COMMAND_REGISTER_OUTPUT_FAIL_USERNAME_USED("command", "register", "output", "fail", "username-used"),
        COMMAND_REGISTER_OUTPUT_FAIL_EMAIL_USED("command", "register", "output", "fail", "email-used"),
        COMMAND_REGISTER_OUTPUT_FAIL_MINECRAFT_USED("command", "register", "output", "fail", "minecraft-used"),
        COMMAND_REGISTER_OUTPUT_FAIL_EMAIL_INVALID("command", "register", "output", "fail", "email-invalid"),
        COMMAND_REGISTER_OUTPUT_FAIL_USERNAME_INVALID("command", "register", "output", "fail", "username-invalid"),
        COMMAND_REGISTER_OUTPUT_FAIL_CANNOT_SEND_EMAIL("command", "register", "output", "fail", "cannot-send-email"),
        COMMAND_REGISTER_OUTPUT_FAIL_CONSOLE_MUST_SPECIFY_USERNAME("command", "register", "output", "fail", "console-must-specify-username"),
        COMMAND_REGISTER_OUTPUT_FAIL_CUSTOM_USERNAME_DISABLED("command", "register", "output", "fail", "custom-username-disabled"),
        COMMAND_REPORT_USAGE("command", "report", "usage"),
        COMMAND_REPORT_DESCRIPTION("command", "report", "description"),
        COMMAND_REPORT_OUTPUT_SUCCESS("command", "report", "output", "success"),
        COMMAND_REPORT_OUTPUT_FAIL_ALREADY_OPEN("command", "report", "output", "fail", "already-open"),
        COMMAND_REPORT_OUTPUT_FAIL_REPORT_SELF("command", "report", "output", "fail", "report-self"),
        COMMAND_REPORT_OUTPUT_NOTIFY_BROADCAST("command", "report", "output", "notify-broadcast"),
        COMMAND_STORE_CHANGE_CREDITS_USAGE("command", "store-change-credits", "usage"),
        COMMAND_STORE_CHANGE_CREDITS_DESCRIPTION("command", "store-change-credits", "description"),
        COMMAND_STORE_CHANGE_CREDITS_OUTPUT_ADDED("command", "store-change-credits", "output", "added"),
        COMMAND_STORE_CHANGE_CREDITS_OUTPUT_REMOVED("command", "store-change-credits", "output", "removed"),
        COMMAND_STORE_CHANGE_CREDITS_OUTPUT_NOTHING("command", "store-change-credits", "output", "nothing"),
        COMMAND_STORE_VIEW_CREDITS_USAGE("command", "store-view-credits", "usage"),
        COMMAND_STORE_VIEW_CREDITS_DESCRIPTION("command", "store-view-credits", "description"),
        COMMAND_STORE_VIEW_CREDITS_OUTPUT_CREDITS("command", "store-view-credits", "output", "credits"),
        COMMAND_STORE_VIEW_CREDITS_OUTPUT_CONSOLE_MUST_PROVIDE_TARGET("command", "store-view-credits", "output", "console-must-provide-target"),
        COMMAND_STORE_VIEW_CREDITS_OUTPUT_NO_PERMISSION_OTHER("command", "store-view-credits", "output", "no-permission-other"),
        COMMAND_VALIDATE_USAGE("command", "validate", "usage"),
        COMMAND_VALIDATE_DESCRIPTION("command", "validate", "description"),
        COMMAND_VALIDATE_OUTPUT_SUCCESS("command", "validate", "output", "success"),
        COMMAND_VALIDATE_OUTPUT_FAIL_INVALID_CODE("command", "validate", "output", "fail", "invalid-code"),
        COMMAND_VALIDATE_OUTPUT_FAIL_ALREADY_VALIDATED("command", "validate", "output", "fail", "already-validated"),
        COMMAND_VALIDATE_OUTPUT_FAIL_MINECRAFT_ACCOUNT_LINKED("command", "validate", "output", "fail", "minecraft-account-linked"),
        COMMAND_SUGGEST_USAGE("command", "suggest", "usage"),
        COMMAND_SUGGEST_DESCRIPTION("command", "suggest", "description"),
        COMMAND_SUGGEST_OUTPUT_SUCCESS("command", "suggest", "output", "success"),
        COMMAND_SUGGEST_OUTPUT_TOO_SHORT("command", "suggest", "output", "too-short"),
        COMMAND_USERINFO_USAGE("command", "user-info", "usage"),
        COMMAND_USERINFO_DESCRIPTION("command", "user-info", "description"),
        COMMAND_USERINFO_OUTPUT_USERNAME("command", "user-info", "output", "username"),
        COMMAND_USERINFO_OUTPUT_DISPLAY_NAME("command", "user-info", "output", "displayname"),
        COMMAND_USERINFO_OUTPUT_PRIMARY_GROUP("command", "user-info", "output", "primary-group"),
        COMMAND_USERINFO_OUTPUT_ALL_GROUPS("command", "user-info", "output", "all-groups"),
        COMMAND_USERINFO_OUTPUT_REGISTER_DATE("command", "user-info", "output", "registered-date"),
        COMMAND_USERINFO_OUTPUT_VALIDATED("command", "user-info", "output", "validated"),
        COMMAND_USERINFO_OUTPUT_BANNED("command", "user-info", "output", "banned"),
        COMMAND_USERINFO_OUTPUT_CUSTOM_FIELD("command", "user-info", "output", "custom-field"),
        COMMAND_USERINFO_OUTPUT_STORE_MODULE_CREDITS("command", "user-info", "output", "store-module-credits"),
        COMMAND_USERINFO_OUTPUT_INTEGRATIONS_HEADER("command", "user-info", "output", "integrations", "header"),
        COMMAND_USERINFO_OUTPUT_INTEGRATIONS_IDENTIFIER("command", "user-info", "output", "integrations", "identifier"),
        COMMAND_USERINFO_OUTPUT_INTEGRATIONS_USERNAME("command", "user-info", "output", "integrations", "username"),
        COMMAND_USERINFO_OUTPUT_INTEGRATIONS_LINKED_DATE("command", "user-info", "output", "integrations", "linked-date"),
        COMMAND_USERINFO_OUTPUT_INTEGRATIONS_VERIFIED("command", "user-info", "output", "integrations", "verified"),
        JOIN_NOT_REGISTERED("join-not-registered"),
        JOIN_NOTIFICATIONS("join-notifications"),
        WEBSITE_ANNOUNCEMENT("website-announcement"),
        USER_SYNC_KICK("user-sync-kick");

        private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Object @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] path;

        private Term(Object ... path) {
            this.path = path;
        }

        public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Object @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] path() {
            return this.path;
        }
    }
}

