/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common.command;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Permission;
import com.namelessmc.plugin.common.audiences.NamelessCommandSender;
import com.namelessmc.plugin.common.audiences.NamelessConsole;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.command.CommonCommand;
import com.namelessmc.plugin.lib.adventure.text.Component;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ReportCommand
extends CommonCommand {
    public ReportCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        super(plugin, "report", LanguageHandler.Term.COMMAND_REPORT_USAGE, LanguageHandler.Term.COMMAND_REPORT_DESCRIPTION, Permission.COMMAND_REPORT);
    }

    @Override
    public void execute(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length < 2) {
            sender.sendMessage(this.usage());
            return;
        }
        if (sender instanceof NamelessConsole) {
            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_NOT_A_PLAYER));
            return;
        }
        this.scheduler().runAsync(() -> {
            NamelessAPI api = this.apiProvider().api();
            if (api == null) {
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                return;
            }
            try {
                String targetUsername = args[0];
                NamelessPlayer target = this.plugin().audiences().playerByUsername(targetUsername);
                if (target == null) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_USERNAME_NOT_ONLINE));
                    return;
                }
                String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                NamelessUser user = api.userByMinecraftUuid(((NamelessPlayer)sender).uuid());
                if (user == null) {
                    sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_NOT_REGISTERED));
                    return;
                }
                int serverId = ((CommentedConfigurationNode)this.plugin().config().main().node(new Object[]{"api.server-id", 0})).getInt();
                user.createReport(target.uuid(), target.username(), reason, serverId);
                sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REPORT_OUTPUT_SUCCESS));
                this.reportNotify(target.username(), ((NamelessPlayer)sender).username());
            }
            catch (NamelessException e) {
                if (e instanceof ApiException) {
                    switch (((ApiException)e).apiError()) {
                        case CORE_BANNED_FROM_WEBSITE: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.PLAYER_SELF_COMMAND_BANNED));
                            return;
                        }
                        case CORE_OPEN_REPORT_ALREADY: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REPORT_OUTPUT_FAIL_ALREADY_OPEN));
                            return;
                        }
                        case CORE_CANNOT_REPORT_YOURSELF: {
                            sender.sendMessage(this.language().get(LanguageHandler.Term.COMMAND_REPORT_OUTPUT_FAIL_REPORT_SELF));
                            return;
                        }
                    }
                }
                sender.sendMessage(this.language().get(LanguageHandler.Term.ERROR_WEBSITE_CONNECTION));
                this.logger().logException(e);
            }
        });
    }

    private void reportNotify(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reporterUsername, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String reportedUsername) {
        Component message = this.language().get(LanguageHandler.Term.COMMAND_REPORT_OUTPUT_NOTIFY_BROADCAST, "reporter_username", reporterUsername, "reported_username", reportedUsername);
        this.plugin().audiences().console().sendMessage(message);
        for (NamelessPlayer player : this.plugin().audiences().onlinePlayers()) {
            if (!player.hasPermission(Permission.COMMAND_REPORT_NOTIFY_BROADCAST)) continue;
            player.sendMessage(message);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> complete(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessCommandSender sender, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat [] args) {
        if (args.length == 1) {
            return this.plugin().audiences().onlinePlayers().stream().map(NamelessPlayer::username).filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

