/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.adventure.text.format;

import com.namelessmc.plugin.lib.adventure.key.Key;
import com.namelessmc.plugin.lib.adventure.text.event.ClickEvent;
import com.namelessmc.plugin.lib.adventure.text.event.HoverEvent;
import com.namelessmc.plugin.lib.adventure.text.format.DecorationMap;
import com.namelessmc.plugin.lib.adventure.text.format.TextColor;
import com.namelessmc.plugin.lib.adventure.text.format.TextDecoration;
import com.namelessmc.plugin.lib.jetbrains-annotations.ApiStatus;
import com.namelessmc.plugin.lib.jetbrains-annotations.NotNull;
import com.namelessmc.plugin.lib.jetbrains-annotations.Nullable;
import com.namelessmc.plugin.lib.jetbrains-annotations.Unmodifiable;
import java.util.EnumMap;
import java.util.Map;

@ApiStatus.NonExtendable
public interface StyleGetter {
    @Nullable
    public Key font();

    @Nullable
    public TextColor color();

    default public boolean hasDecoration(@NotNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NotNull TextDecoration.State decoration(@NotNull TextDecoration var1);

    default public @Unmodifiable @NotNull Map<TextDecoration, TextDecoration.State> decorations() {
        EnumMap<TextDecoration, TextDecoration.State> decorations = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration decoration : DecorationMap.DECORATIONS) {
            TextDecoration.State value = this.decoration(decoration);
            decorations.put(decoration, value);
        }
        return decorations;
    }

    @Nullable
    public ClickEvent clickEvent();

    @Nullable
    public HoverEvent<?> hoverEvent();

    @Nullable
    public String insertion();
}

