/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard;

import com.namelessmc.plugin.lib.adventure.text.event.ClickEvent;
import com.namelessmc.plugin.lib.adventure.text.format.Style;
import com.namelessmc.plugin.lib.adventure.text.minimessage.Context;
import com.namelessmc.plugin.lib.adventure.text.minimessage.ParsingException;
import com.namelessmc.plugin.lib.adventure.text.minimessage.internal.serializer.QuotingOverride;
import com.namelessmc.plugin.lib.adventure.text.minimessage.internal.serializer.SerializableResolver;
import com.namelessmc.plugin.lib.adventure.text.minimessage.internal.serializer.StyleClaim;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.Tag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import com.namelessmc.plugin.lib.jetbrains-annotations.Nullable;

final class ClickTag {
    private static final String CLICK = "click";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("click", ClickTag::create, StyleClaim.claim("click", Style::clickEvent, (event, emitter) -> emitter.tag(CLICK).argument(ClickEvent.Action.NAMES.key(event.action())).argument(event.value(), QuotingOverride.QUOTED)));

    private ClickTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        String actionName = args.popOr(() -> "A click tag requires an action of one of " + ClickEvent.Action.NAMES.keys()).lowerValue();
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(actionName);
        if (action == null) {
            throw ctx.newException("Unknown click event action '" + actionName + "'", args);
        }
        String value = args.popOr("Click event actions require a value").value();
        return Tag.styling(ClickEvent.clickEvent(action, value));
    }
}

