/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard;

import com.namelessmc.plugin.lib.adventure.text.format.TextDecoration;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.ClickTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.ColorTagResolver;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.DecorationTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.FontTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.GradientTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.HoverTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.InsertionTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.KeybindTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.NewlineTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.RainbowTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.ResetTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.SelectorTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.TransitionTag;
import com.namelessmc.plugin.lib.adventure.text.minimessage.tag.standard.TranslatableTag;
import com.namelessmc.plugin.lib.jetbrains-annotations.NotNull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class StandardTags {
    private static final TagResolver ALL = TagResolver.builder().resolvers(HoverTag.RESOLVER, ClickTag.RESOLVER, ColorTagResolver.INSTANCE, KeybindTag.RESOLVER, TranslatableTag.RESOLVER, InsertionTag.RESOLVER, FontTag.RESOLVER, DecorationTag.RESOLVER, GradientTag.RESOLVER, RainbowTag.RESOLVER, ResetTag.RESOLVER, NewlineTag.RESOLVER, TransitionTag.RESOLVER, SelectorTag.RESOLVER).build();

    private StandardTags() {
    }

    @NotNull
    public static TagResolver decorations(@NotNull TextDecoration decoration) {
        return Objects.requireNonNull(DecorationTag.RESOLVERS.get(decoration), "No resolver found for decoration (this should not be possible?)");
    }

    @NotNull
    public static TagResolver decorations() {
        return DecorationTag.RESOLVER;
    }

    @NotNull
    public static TagResolver color() {
        return ColorTagResolver.INSTANCE;
    }

    @NotNull
    public static TagResolver hoverEvent() {
        return HoverTag.RESOLVER;
    }

    @NotNull
    public static TagResolver clickEvent() {
        return ClickTag.RESOLVER;
    }

    @NotNull
    public static TagResolver keybind() {
        return KeybindTag.RESOLVER;
    }

    @NotNull
    public static TagResolver translatable() {
        return TranslatableTag.RESOLVER;
    }

    @NotNull
    public static TagResolver insertion() {
        return InsertionTag.RESOLVER;
    }

    @NotNull
    public static TagResolver font() {
        return FontTag.RESOLVER;
    }

    @NotNull
    public static TagResolver gradient() {
        return GradientTag.RESOLVER;
    }

    @NotNull
    public static TagResolver rainbow() {
        return RainbowTag.RESOLVER;
    }

    public static TagResolver transition() {
        return TransitionTag.RESOLVER;
    }

    @NotNull
    public static TagResolver reset() {
        return ResetTag.RESOLVER;
    }

    @NotNull
    public static TagResolver newline() {
        return NewlineTag.RESOLVER;
    }

    @NotNull
    public static TagResolver selector() {
        return SelectorTag.RESOLVER;
    }

    @NotNull
    public static TagResolver defaults() {
        return ALL;
    }

    static Set<String> names(String ... names) {
        return new HashSet<String>(Arrays.asList(names));
    }
}

