/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.configurate.serialize;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.configurate.BasicConfigurationNode;
import com.namelessmc.plugin.lib.configurate.ConfigurationNode;
import com.namelessmc.plugin.lib.configurate.ConfigurationOptions;
import com.namelessmc.plugin.lib.configurate.serialize.SerializationException;
import com.namelessmc.plugin.lib.configurate.serialize.TypeSerializer;
import com.namelessmc.plugin.lib.geantyref.TypeToken;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class MapSerializer
implements TypeSerializer.Annotated<Map<?, ?>> {
    static final TypeToken<Map<?, ?>> TYPE = new TypeToken<Map<?, ?>>(){};

    MapSerializer() {
    }

    @Override
    public Map<?, ?> deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        LinkedHashMap ret = new LinkedHashMap();
        if (node.isMap()) {
            if (!(type instanceof AnnotatedParameterizedType)) {
                throw new SerializationException(type, "Raw types are not supported for collections");
            }
            AnnotatedParameterizedType param = (AnnotatedParameterizedType)type;
            AnnotatedType[] typeArgs = param.getAnnotatedActualTypeArguments();
            if (typeArgs.length != 2) {
                throw new SerializationException(type, "Map expected two type arguments!");
            }
            AnnotatedType key = typeArgs[0];
            AnnotatedType value = typeArgs[1];
            @Nullable TypeSerializer<?> keySerial = node.options().serializers().get(key);
            @Nullable TypeSerializer<?> valueSerial = node.options().serializers().get(value);
            if (keySerial == null) {
                throw new SerializationException(type, "No type serializer available for key type " + key);
            }
            if (valueSerial == null) {
                throw new SerializationException(type, "No type serializer available for value type " + value);
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.childrenMap().entrySet()) {
                ret.put(Objects.requireNonNull(keySerial.deserialize(key, keyNode.set(ent.getKey())), "key"), Objects.requireNonNull(valueSerial.deserialize(value, ent.getValue()), "value"));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(AnnotatedType type, @Nullable Map<?, ?> obj, ConfigurationNode node) throws SerializationException {
        if (!(type instanceof AnnotatedParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        AnnotatedParameterizedType param = (AnnotatedParameterizedType)type;
        AnnotatedType[] typeArgs = param.getAnnotatedActualTypeArguments();
        if (typeArgs.length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        AnnotatedType key = typeArgs[0];
        AnnotatedType value = typeArgs[1];
        @Nullable TypeSerializer<?> keySerial = node.options().serializers().get(key);
        @Nullable TypeSerializer<?> valueSerial = node.options().serializers().get(value);
        if (keySerial == null) {
            throw new SerializationException(type, "No type serializer available for key type " + key);
        }
        if (valueSerial == null) {
            throw new SerializationException(type, "No type serializer available for value type " + value);
        }
        if (obj == null || obj.isEmpty()) {
            node.set(Collections.emptyMap());
        } else {
            Set<Map.Entry<Object, Object>> unvisitedKeys;
            if (node.empty()) {
                node.raw(Collections.emptyMap());
                unvisitedKeys = Collections.emptySet();
            } else {
                unvisitedKeys = new HashSet<Object>(node.childrenMap().keySet());
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            for (Map.Entry<?, ?> ent : obj.entrySet()) {
                keySerial.serialize(key, ent.getKey(), (ConfigurationNode)keyNode);
                Object keyObj = Objects.requireNonNull(keyNode.raw(), "Key must not be null!");
                ConfigurationNode child = node.node(keyObj);
                try {
                    valueSerial.serialize(value, ent.getValue(), child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                }
                finally {
                    unvisitedKeys.remove(keyObj);
                }
            }
            for (Map.Entry<Object, Object> unusedChild : unvisitedKeys) {
                node.removeChild(unusedChild);
            }
        }
    }

    @Override
    public Map<?, ?> emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        return new LinkedHashMap();
    }
}

