/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.MimeAwareRequest;
import com.namelessmc.plugin.lib.methanol.MimeBody;
import com.namelessmc.plugin.lib.methanol.MoreBodySubscribers;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.adapter.BasicAdapter;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface BodyAdapter {
    public boolean isCompatibleWith(MediaType var1);

    public boolean supportsType(TypeRef<?> var1);

    public static interface Hints {
        public Map<Class<?>, Object> toMap();

        default public Optional<MediaType> mediaType() {
            return this.get(MediaType.class);
        }

        default public MediaType mediaTypeOrAny() {
            return this.mediaType().orElse(MediaType.ANY);
        }

        default public Optional<HttpRequest> request() {
            return this.get(HttpRequest.class);
        }

        default public Optional<HttpResponse.ResponseInfo> responseInfo() {
            return this.get(HttpResponse.ResponseInfo.class);
        }

        public <T> Optional<T> get(Class<T> var1);

        default public Builder mutate() {
            return new Builder(this);
        }

        public boolean equals(Object var1);

        public int hashCode();

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Hints empty() {
            return Builder.EMPTY_HINTS;
        }

        public static Hints of(MediaType mediaType) {
            return new Builder.KnownHints(Objects.requireNonNull(mediaType), null, null);
        }

        public static class Builder {
            static final Hints EMPTY_HINTS = new AbstractHints(){

                @Override
                public Map<Class<?>, Object> toMap() {
                    return Map.of();
                }

                @Override
                public Optional<MediaType> mediaType() {
                    return Optional.empty();
                }

                @Override
                public MediaType mediaTypeOrAny() {
                    return MediaType.ANY;
                }

                @Override
                public Optional<HttpRequest> request() {
                    return Optional.empty();
                }

                @Override
                public Optional<HttpResponse.ResponseInfo> responseInfo() {
                    return Optional.empty();
                }

                @Override
                public <T> Optional<T> get(Class<T> type) {
                    return Optional.empty();
                }

                @Override
                public Builder mutate() {
                    return new Builder();
                }
            };
            private final Map<Class<?>, Object> unknownHints = new HashMap();
            private @Nullable MediaType mediaType;
            private @Nullable HttpRequest request;
            private  @Nullable HttpResponse.ResponseInfo responseInfo;

            Builder() {
            }

            Builder(Hints hints) {
                this.putAll(hints);
            }

            @CanIgnoreReturnValue
            Builder putAll(Hints hints) {
                if (hints instanceof KnownHints) {
                    KnownHints knownHints = (KnownHints)hints;
                    this.mediaType = knownHints.mediaType.orElse(null);
                    this.request = knownHints.request.orElse(null);
                    this.responseInfo = knownHints.responseInfo.orElse(null);
                } else {
                    this.unknownHints.putAll(hints.toMap());
                    this.mediaType = (MediaType)this.unknownHints.remove(MediaType.class);
                    this.request = (HttpRequest)this.unknownHints.remove(HttpRequest.class);
                    this.responseInfo = (HttpResponse.ResponseInfo)this.unknownHints.remove(HttpResponse.ResponseInfo.class);
                }
                return this;
            }

            @CanIgnoreReturnValue
            Builder putAll(Builder other) {
                this.unknownHints.putAll(other.unknownHints);
                this.mediaType = other.mediaType;
                this.request = other.request;
                this.responseInfo = other.responseInfo;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder forEncoder(HttpRequest request) {
                this.request = Objects.requireNonNull(request);
                this.mediaType = (request instanceof MimeAwareRequest ? ((MimeAwareRequest)((Object)request)).mimeBody().map(MimeBody::mediaType) : Optional.empty()).or(() -> request.headers().firstValue("Content-Type").map(MediaType::parse)).orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder forDecoder(HttpResponse.ResponseInfo responseInfo) {
                this.responseInfo = Objects.requireNonNull(responseInfo);
                this.mediaType = responseInfo.headers().firstValue("Content-Type").map(MediaType::parse).orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public <T> Builder put(Class<T> type, T value) {
                Validate.requireArgument(type.isInstance(value), "Expected %s to be an instance of %s", value, type);
                if (type == MediaType.class) {
                    this.mediaType = (MediaType)value;
                } else if (type == HttpRequest.class) {
                    this.request = (HttpRequest)value;
                } else if (type == HttpResponse.ResponseInfo.class) {
                    this.responseInfo = (HttpResponse.ResponseInfo)value;
                } else {
                    this.unknownHints.put(type, value);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public <T> Builder remove(Class<T> type) {
                if (type == MediaType.class) {
                    this.mediaType = null;
                } else if (type == HttpRequest.class) {
                    this.request = null;
                } else if (type == HttpResponse.ResponseInfo.class) {
                    this.responseInfo = null;
                } else {
                    this.unknownHints.remove(type);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public Builder removeAll() {
                this.unknownHints.clear();
                this.mediaType = null;
                this.request = null;
                this.responseInfo = null;
                return this;
            }

            public Hints build() {
                if (this.unknownHints.isEmpty()) {
                    return this.mediaType != null || this.request != null || this.responseInfo != null ? new KnownHints(this.mediaType, this.request, this.responseInfo) : EMPTY_HINTS;
                }
                HashMap hints = new HashMap(this.unknownHints);
                if (this.mediaType != null) {
                    hints.put(MediaType.class, this.mediaType);
                }
                if (this.request != null) {
                    hints.put(HttpRequest.class, this.request);
                }
                if (this.responseInfo != null) {
                    hints.put(HttpResponse.ResponseInfo.class, this.responseInfo);
                }
                return new MapHints(hints);
            }

            private static final class MapHints
            extends AbstractHints {
                private final Map<Class<?>, Object> hints;

                MapHints(Map<Class<?>, Object> hints) {
                    this.hints = Map.copyOf(hints);
                }

                @Override
                public Map<Class<?>, Object> toMap() {
                    return this.hints;
                }

                @Override
                public <T> Optional<T> get(Class<T> type) {
                    return Optional.ofNullable(this.hints.get(type));
                }
            }

            private static final class KnownHints
            extends AbstractHints {
                private final Optional<MediaType> mediaType;
                private final Optional<HttpRequest> request;
                private final Optional<HttpResponse.ResponseInfo> responseInfo;
                private @MonotonicNonNull Map<Class<?>, Object> lazyMap;

                KnownHints(@Nullable MediaType mediaType, @Nullable HttpRequest request,  @Nullable HttpResponse.ResponseInfo responseInfo) {
                    this.mediaType = Optional.ofNullable(mediaType);
                    this.request = Optional.ofNullable(request);
                    this.responseInfo = Optional.ofNullable(responseInfo);
                }

                @Override
                public Map<Class<?>, Object> toMap() {
                    Map<Class<?>, Object> map = this.lazyMap;
                    if (map == null) {
                        map = new HashMap();
                        HashMap lambdaMap = map;
                        this.mediaType.ifPresent(mediaType -> lambdaMap.put(MediaType.class, mediaType));
                        this.request.ifPresent(request -> lambdaMap.put(HttpRequest.class, request));
                        this.responseInfo.ifPresent(responseInfo -> lambdaMap.put(HttpResponse.ResponseInfo.class, responseInfo));
                        this.lazyMap = map;
                    }
                    return map;
                }

                @Override
                public <T> Optional<T> get(Class<T> type) {
                    Optional<Object> result = type == MediaType.class ? this.mediaType : (type == HttpRequest.class ? this.request : (type == HttpResponse.ResponseInfo.class ? this.responseInfo : Optional.empty()));
                    Optional<MediaType> castResult = result;
                    return castResult;
                }

                @Override
                public Optional<MediaType> mediaType() {
                    return this.mediaType;
                }

                @Override
                public Optional<HttpRequest> request() {
                    return this.request;
                }

                @Override
                public Optional<HttpResponse.ResponseInfo> responseInfo() {
                    return this.responseInfo;
                }
            }

            private static abstract class AbstractHints
            implements Hints {
                AbstractHints() {
                }

                public String toString() {
                    return "Hints" + this.toMap();
                }

                @Override
                public boolean equals(@Nullable Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    return obj instanceof Hints && this.toMap().equals(((Hints)obj).toMap());
                }

                @Override
                public int hashCode() {
                    return this.toMap().hashCode() * 31;
                }
            }
        }
    }

    public static interface Decoder
    extends BodyAdapter {
        public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> var1, @Nullable MediaType var2);

        default public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> typeRef, Hints hints) {
            return this.toObject(typeRef, hints.mediaTypeOrAny());
        }

        default public <T> HttpResponse.BodySubscriber<Supplier<T>> toDeferredObject(TypeRef<T> typeRef, @Nullable MediaType mediaType) {
            return MoreBodySubscribers.fromAsyncSubscriber(this.toObject(typeRef, mediaType), subscriber -> CompletableFuture.completedStage(() -> subscriber.getBody().toCompletableFuture().join()));
        }

        default public <T> HttpResponse.BodySubscriber<Supplier<T>> toDeferredObject(TypeRef<T> typeRef, Hints hints) {
            return this.toDeferredObject(typeRef, hints.mediaTypeOrAny());
        }

        public static List<Decoder> installed() {
            return AdapterCodec.installed().decoders();
        }

        public static Optional<Decoder> getDecoder(TypeRef<?> typeRef, @Nullable MediaType mediaType) {
            return AdapterCodec.installed().lookupDecoder(typeRef, Utils.hintsOf(mediaType));
        }

        public static Decoder basic() {
            return BasicAdapter.decoder();
        }
    }

    public static interface Encoder
    extends BodyAdapter {
        public HttpRequest.BodyPublisher toBody(Object var1, @Nullable MediaType var2);

        default public <T> HttpRequest.BodyPublisher toBody(T value, TypeRef<T> typeRef, Hints hints) {
            return this.toBody(value, hints.mediaTypeOrAny());
        }

        public static List<Encoder> installed() {
            return AdapterCodec.installed().encoders();
        }

        public static Optional<Encoder> getEncoder(TypeRef<?> typeRef, @Nullable MediaType mediaType) {
            return AdapterCodec.installed().lookupEncoder(typeRef, Utils.hintsOf(mediaType));
        }

        public static Encoder basic() {
            return BasicAdapter.encoder();
        }
    }
}

