/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.errorprone-annotations.InlineMe;
import com.namelessmc.plugin.lib.methanol.AdapterCodec;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.BodyDecoder;
import com.namelessmc.plugin.lib.methanol.HeadersAccumulator;
import com.namelessmc.plugin.lib.methanol.HttpCache;
import com.namelessmc.plugin.lib.methanol.HttpHeadersTimeoutException;
import com.namelessmc.plugin.lib.methanol.MimeBody;
import com.namelessmc.plugin.lib.methanol.MoreBodyHandlers;
import com.namelessmc.plugin.lib.methanol.MutableRequest;
import com.namelessmc.plugin.lib.methanol.ResponseBuilder;
import com.namelessmc.plugin.lib.methanol.ResponsePayload;
import com.namelessmc.plugin.lib.methanol.TaggableRequest;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.adapter.PayloadHandlerExecutor;
import com.namelessmc.plugin.lib.methanol.internal.cache.RedirectingInterceptor;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Delayer;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.FallbackExecutorProvider;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HeadersBuilder;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HttpResponsePublisher;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import com.namelessmc.plugin.lib.methanol.internal.function.Unchecked;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class Methanol
extends HttpClient {
    private static final System.Logger logger;
    private static final @Nullable MethodHandle SHUTDOWN;
    private static final @Nullable MethodHandle AWAIT_TERMINATION;
    private static final @Nullable MethodHandle IS_TERMINATED;
    private static final @Nullable MethodHandle SHUTDOWN_NOW;
    private static final @Nullable MethodHandle CLOSE;
    private final HttpClient backend;
    private final HttpClient.Redirect redirectPolicy;
    private final HttpHeaders defaultHeaders;
    private final Optional<String> userAgent;
    private final Optional<URI> baseUri;
    private final Optional<Duration> headersTimeout;
    private final Optional<Duration> requestTimeout;
    private final Optional<Duration> readTimeout;
    private final Optional<AdapterCodec> adapterCodec;
    private final boolean autoAcceptEncoding;
    private final List<Interceptor> interceptors;
    private final List<Interceptor> backendInterceptors;
    private final List<HttpCache> caches;
    private final List<Interceptor> mergedInterceptors;

    private Methanol(BaseBuilder<?> builder) {
        this.backend = builder.buildBackend();
        this.redirectPolicy = Objects.requireNonNullElse(builder.redirectPolicy, this.backend.followRedirects());
        this.defaultHeaders = builder.defaultHeadersBuilder.build();
        this.userAgent = Optional.ofNullable(builder.userAgent);
        this.baseUri = Optional.ofNullable(builder.baseUri);
        this.headersTimeout = Optional.ofNullable(builder.headersTimeout);
        this.requestTimeout = Optional.ofNullable(builder.requestTimeout);
        this.readTimeout = Optional.ofNullable(builder.readTimeout);
        this.adapterCodec = Optional.ofNullable(builder.adapterCodec);
        this.autoAcceptEncoding = builder.autoAcceptEncoding;
        this.interceptors = List.copyOf(builder.interceptors);
        this.backendInterceptors = List.copyOf(builder.backendInterceptors);
        this.caches = builder.caches;
        ArrayList<Interceptor> mergedInterceptors = new ArrayList<Interceptor>(this.interceptors);
        mergedInterceptors.add(new RewritingInterceptor(this.baseUri, this.requestTimeout, this.adapterCodec, this.defaultHeaders, this.autoAcceptEncoding));
        this.headersTimeout.ifPresent(timeout -> mergedInterceptors.add(new HeadersTimeoutInterceptor((Duration)timeout, Validate.castNonNull(builder.headersTimeoutDelayer))));
        this.readTimeout.ifPresent(timeout -> mergedInterceptors.add(new ReadTimeoutInterceptor((Duration)timeout, Validate.castNonNull(builder.readTimeoutDelayer))));
        if (!this.caches.isEmpty()) {
            mergedInterceptors.add(new RedirectingInterceptor(this.redirectPolicy, this.backend.executor().orElseGet(FallbackExecutorProvider::get)));
        }
        this.caches.forEach(cache -> mergedInterceptors.add(cache.interceptor(Methanol.implicitHeaderPredicateOf(this.backend))));
        mergedInterceptors.addAll(this.backendInterceptors);
        this.mergedInterceptors = Collections.unmodifiableList(mergedInterceptors);
    }

    private static Predicate<String> implicitHeaderPredicateOf(HttpClient client) {
        Predicate<String> predicate = name -> name.equalsIgnoreCase("Host");
        if (client.authenticator().isPresent()) {
            predicate = predicate.or(name -> name.equalsIgnoreCase("Authorization") || name.equalsIgnoreCase("Proxy-Authorization"));
        }
        if (client.cookieHandler().isPresent()) {
            predicate = predicate.or(name -> name.equalsIgnoreCase("Cookie") || name.equalsIgnoreCase("Cookie2"));
        }
        return predicate;
    }

    public <T> Flow.Publisher<HttpResponse<T>> exchange(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) {
        return new HttpResponsePublisher<T>(this, request, bodyHandler, null, this.executor().orElse(FlowSupport.SYNC_EXECUTOR));
    }

    public <T> Flow.Publisher<HttpResponse<T>> exchange(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, Function<HttpRequest, @Nullable HttpResponse.BodyHandler<T>> pushPromiseMapper) {
        return new HttpResponsePublisher<T>(this, request, bodyHandler, pushPromiseMapper, this.executor().orElse(FlowSupport.SYNC_EXECUTOR));
    }

    public HttpClient underlyingClient() {
        return this.backend;
    }

    public Optional<String> userAgent() {
        return this.userAgent;
    }

    public Optional<URI> baseUri() {
        return this.baseUri;
    }

    public Optional<Duration> requestTimeout() {
        return this.requestTimeout;
    }

    public Optional<Duration> headersTimeout() {
        return this.headersTimeout;
    }

    public Optional<Duration> readTimeout() {
        return this.readTimeout;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public List<Interceptor> backendInterceptors() {
        return this.backendInterceptors;
    }

    @Deprecated(since="1.5.0")
    public List<Interceptor> postDecorationInterceptors() {
        return this.backendInterceptors;
    }

    public HttpHeaders defaultHeaders() {
        return this.defaultHeaders;
    }

    public boolean autoAcceptEncoding() {
        return this.autoAcceptEncoding;
    }

    public Optional<HttpCache> cache() {
        return this.caches.stream().findFirst();
    }

    public List<HttpCache> caches() {
        return this.caches;
    }

    public Optional<AdapterCodec> adapterCodec() {
        return this.adapterCodec;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.backend.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.backend.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.redirectPolicy;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.backend.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.backend.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.backend.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.backend.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.backend.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.backend.executor();
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return this.backend.newWebSocketBuilder();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) throws IOException, InterruptedException {
        return new InterceptorChain<T>(this.backend, bodyHandler, null, this.mergedInterceptors).forward(request);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) {
        return new InterceptorChain<T>(this.backend, bodyHandler, null, this.mergedInterceptors).forwardAsync(request);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return new InterceptorChain<T>(this.backend, bodyHandler, pushPromiseHandler, this.mergedInterceptors).forwardAsync(request);
    }

    public <T> HttpResponse<T> send(HttpRequest request, Class<T> type) throws IOException, InterruptedException {
        return this.send(request, TypeRef.of(type));
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, Class<T> type) {
        return this.sendAsync(request, TypeRef.of(type));
    }

    public <T> HttpResponse<T> send(HttpRequest request, TypeRef<T> typeRef) throws IOException, InterruptedException {
        return new InterceptorChain<T>(this.backend, this.handlerOf(request, typeRef), null, this.mergedInterceptors).forward(request);
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, TypeRef<T> typeRef) {
        return new InterceptorChain<T>(this.backend, this.handlerOf(request, typeRef), null, this.mergedInterceptors).forwardAsync(request);
    }

    private <T> HttpResponse.BodyHandler<T> handlerOf(HttpRequest request, TypeRef<T> typeRef) {
        TypeRef<?> deferredValueTypeRef;
        Optional<AdapterCodec> adapterCodec = MutableRequest.adapterCodecOf(request).or(() -> this.adapterCodec);
        BodyAdapter.Hints hints = TaggableRequest.hintsOf(request);
        TypeRef<?> typeRef2 = deferredValueTypeRef = typeRef.isParameterizedType() && typeRef.rawType() == Supplier.class ? typeRef.resolveSupertype(Supplier.class).typeArgumentAt(0).orElseThrow(AssertionError::new) : null;
        if (typeRef.isRawType() && typeRef.rawType() == ResponsePayload.class || deferredValueTypeRef != null && deferredValueTypeRef.isRawType() && deferredValueTypeRef.rawType() == ResponsePayload.class) {
            BodyAdapter.Hints.Builder hintsBuilder = hints.mutate();
            adapterCodec.ifPresent(codec -> hintsBuilder.put(AdapterCodec.class, codec));
            this.executor().ifPresent(executor -> hintsBuilder.put(PayloadHandlerExecutor.class, new PayloadHandlerExecutor((Executor)executor)));
            hints = hintsBuilder.build();
        }
        AdapterCodec effectiveAdapterCodec = adapterCodec.orElseGet(AdapterCodec::installed);
        if (deferredValueTypeRef != null) {
            HttpResponse.BodyHandler<Supplier<?>> bodyHandler = effectiveAdapterCodec.deferredHandlerOf(deferredValueTypeRef, hints);
            return bodyHandler;
        }
        return effectiveAdapterCodec.handlerOf(typeRef, hints);
    }

    @CanIgnoreReturnValue
    private static URI validateUri(URI uri) {
        String scheme = uri.getScheme();
        Validate.requireArgument(scheme != null, "URI has no scheme: %s", uri);
        Validate.requireArgument(scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"), "Unsupported scheme: %s", scheme);
        Validate.requireArgument(uri.getHost() != null, "URI has no host: %s", uri);
        return uri;
    }

    private static <T> HttpResponse.PushPromiseHandler<T> transformPushPromiseHandler(HttpResponse.PushPromiseHandler<T> pushPromiseHandler, UnaryOperator<HttpResponse.BodyHandler<T>> bodyHandlerTransformer, UnaryOperator<HttpResponse<T>> responseTransformer) {
        return (initialRequest, pushRequest, acceptor) -> pushPromiseHandler.applyPushPromise(initialRequest, pushRequest, acceptor.compose(bodyHandlerTransformer).andThen(future -> future.thenApply((Function)responseTransformer)));
    }

    public static Builder newBuilder() {
        return Builder.create();
    }

    public static WithClientBuilder newBuilder(HttpClient backend) {
        return new WithClientBuilder(backend);
    }

    public static Methanol create() {
        return Methanol.newBuilder().build();
    }

    static {
        MethodHandle shutdown;
        logger = System.getLogger(Methanol.class.getName());
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            shutdown = lookup.findVirtual(HttpClient.class, "shutdown", MethodType.methodType(Void.TYPE));
        }
        catch (NoSuchMethodException e) {
            shutdown = null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (shutdown == null) {
            SHUTDOWN = null;
            AWAIT_TERMINATION = null;
            IS_TERMINATED = null;
            SHUTDOWN_NOW = null;
            CLOSE = null;
        } else {
            SHUTDOWN = shutdown;
            try {
                AWAIT_TERMINATION = lookup.findVirtual(HttpClient.class, "awaitTermination", MethodType.methodType(Boolean.TYPE, Duration.class));
                IS_TERMINATED = lookup.findVirtual(HttpClient.class, "isTerminated", MethodType.methodType(Boolean.TYPE));
                SHUTDOWN_NOW = lookup.findVirtual(HttpClient.class, "shutdownNow", MethodType.methodType(Void.TYPE));
                CLOSE = lookup.findVirtual(HttpClient.class, "close", MethodType.methodType(Void.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static final class ReadTimeoutInterceptor
    implements Interceptor {
        private final Duration readTimeout;
        private final Delayer delayer;

        ReadTimeoutInterceptor(Duration readTimeout, Delayer delayer) {
            this.readTimeout = readTimeout;
            this.delayer = delayer;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return this.withReadTimeout(chain).forward(request);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            return this.withReadTimeout(chain).forwardAsync(request);
        }

        private <T> Interceptor.Chain<T> withReadTimeout(Interceptor.Chain<T> chain) {
            return chain.with(bodyHandler -> MoreBodyHandlers.withReadTimeout(bodyHandler, this.readTimeout, this.delayer), pushPromiseHandler -> Methanol.transformPushPromiseHandler(pushPromiseHandler, bodyHandler -> MoreBodyHandlers.withReadTimeout(bodyHandler, this.readTimeout, this.delayer), UnaryOperator.identity()));
        }
    }

    private static final class HeadersTimeoutInterceptor
    implements Interceptor {
        private final Duration headersTimeout;
        private final Delayer delayer;

        HeadersTimeoutInterceptor(Duration headersTimeout, Delayer delayer) {
            this.headersTimeout = headersTimeout;
            this.delayer = delayer;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return Utils.get(this.interceptAsync(request, chain));
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            TimeoutTrigger timeoutTrigger = new TimeoutTrigger();
            Future<Void> triggerFuture = this.delayer.delay(timeoutTrigger::trigger, this.headersTimeout, FlowSupport.SYNC_EXECUTOR);
            timeoutTrigger.onCancellation(() -> triggerFuture.cancel(false));
            CompletableFuture responseFuture = this.withHeadersTimeout(chain, timeoutTrigger).forwardAsync(request);
            CompletableFuture responseFutureCopy = responseFuture.copy();
            timeoutTrigger.onTimeout(() -> {
                responseFutureCopy.completeExceptionally(new HttpHeadersTimeoutException("Couldn't receive headers on time"));
                responseFuture.cancel(true);
            });
            return responseFutureCopy;
        }

        private <T> Interceptor.Chain<T> withHeadersTimeout(Interceptor.Chain<T> chain, TimeoutTrigger timeoutTrigger) {
            return chain.with(bodyHandler -> responseInfo -> timeoutTrigger.cancel() ? bodyHandler.apply(responseInfo) : new TimedOutSubscriber());
        }

        private static final class TimedOutSubscriber<T>
        implements HttpResponse.BodySubscriber<T> {
            TimedOutSubscriber() {
            }

            @Override
            public CompletionStage<T> getBody() {
                return CompletableFuture.failedFuture(new HttpHeadersTimeoutException("couldn't receive headers ont time"));
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.cancel();
            }

            @Override
            public void onNext(List<ByteBuffer> item) {
                Objects.requireNonNull(item);
            }

            @Override
            public void onError(Throwable throwable) {
                Objects.requireNonNull(throwable);
                logger.log(System.Logger.Level.WARNING, "Exception received after headers timeout", throwable);
            }

            @Override
            public void onComplete() {
            }
        }

        private static final class TimeoutTrigger {
            private final CompletableFuture<Void> onTimeout = new CompletableFuture();

            TimeoutTrigger() {
            }

            void trigger() {
                this.onTimeout.complete(null);
            }

            void onTimeout(Runnable action) {
                this.onTimeout.thenRun(action);
            }

            void onCancellation(Runnable action) {
                this.onTimeout.whenComplete((__, e) -> {
                    if (e instanceof CancellationException) {
                        action.run();
                    }
                });
            }

            boolean cancel() {
                return this.onTimeout.cancel(false);
            }
        }
    }

    private static final class RewritingInterceptor
    implements Interceptor {
        private final Optional<URI> baseUri;
        private final Optional<Duration> requestTimeout;
        private final Optional<AdapterCodec> adapterCodec;
        private final HttpHeaders defaultHeaders;
        private final boolean autoAcceptEncoding;

        RewritingInterceptor(Optional<URI> baseUri, Optional<Duration> requestTimeout, Optional<AdapterCodec> adapterCodec, HttpHeaders defaultHeaders, boolean autoAcceptEncoding) {
            this.baseUri = baseUri;
            this.requestTimeout = requestTimeout;
            this.adapterCodec = adapterCodec;
            this.defaultHeaders = defaultHeaders;
            this.autoAcceptEncoding = autoAcceptEncoding;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            HttpRequest rewrittenRequest = this.rewriteRequest(request);
            return this.autoAcceptEncoding(rewrittenRequest) ? RewritingInterceptor.stripContentEncoding(RewritingInterceptor.decoding(chain).forward(rewrittenRequest)) : chain.forward(rewrittenRequest);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            HttpRequest rewrittenRequest = this.rewriteRequest(request);
            return this.autoAcceptEncoding(rewrittenRequest) ? RewritingInterceptor.decoding(chain).forwardAsync(rewrittenRequest).thenApply(RewritingInterceptor::stripContentEncoding) : chain.forwardAsync(rewrittenRequest);
        }

        private boolean autoAcceptEncoding(HttpRequest request) {
            return this.autoAcceptEncoding && !request.method().equalsIgnoreCase("HEAD");
        }

        private HttpRequest rewriteRequest(HttpRequest request) {
            Set<String> supportedEncodings;
            MutableRequest rewrittenRequest = MutableRequest.copyOf(request);
            if (rewrittenRequest.adapterCodec().isEmpty()) {
                this.adapterCodec.ifPresent(rewrittenRequest::adapterCodec);
            }
            this.baseUri.map(baseUri -> baseUri.resolve(request.uri())).ifPresent(rewrittenRequest::uri);
            Methanol.validateUri(rewrittenRequest.uri());
            Map<String, List<String>> originalHeadersMap = request.headers().map();
            Map<String, List<String>> defaultHeadersMap = this.defaultHeaders.map();
            defaultHeadersMap.forEach((name, values) -> {
                if (!originalHeadersMap.containsKey(name)) {
                    values.forEach(value -> rewrittenRequest.header((String)name, (String)value));
                }
            });
            if (this.autoAcceptEncoding && !originalHeadersMap.containsKey("Accept-Encoding") && !defaultHeadersMap.containsKey("Accept-Encoding") && !(supportedEncodings = BodyDecoder.Factory.installedBindings().keySet()).isEmpty()) {
                rewrittenRequest.header("Accept-Encoding", String.join((CharSequence)", ", supportedEncodings));
            }
            rewrittenRequest.mimeBody().map(MimeBody::mediaType).ifPresent(mediaType -> rewrittenRequest.setHeader("Content-Type", mediaType.toString()));
            if (request.timeout().isEmpty()) {
                this.requestTimeout.ifPresent(rewrittenRequest::timeout);
            }
            return rewrittenRequest.toImmutableRequest();
        }

        private static <T> Interceptor.Chain<T> decoding(Interceptor.Chain<T> chain) {
            return chain.with(MoreBodyHandlers::decoding, pushPromiseHandler -> Methanol.transformPushPromiseHandler(pushPromiseHandler, MoreBodyHandlers::decoding, RewritingInterceptor::stripContentEncoding));
        }

        private static <T> HttpResponse<T> stripContentEncoding(HttpResponse<T> response) {
            return response.headers().map().containsKey("Content-Encoding") ? ((ResponseBuilder)((ResponseBuilder)ResponseBuilder.from(response).removeHeader("Content-Encoding")).removeHeader("Content-Length")).build() : response;
        }
    }

    private static final class InterceptorChain<T>
    implements Interceptor.Chain<T> {
        private final HttpClient backend;
        private final HttpResponse.BodyHandler<T> bodyHandler;
        private final @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler;
        private final List<Interceptor> interceptors;
        private final int currentInterceptorIndex;

        InterceptorChain(HttpClient backend, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler, List<Interceptor> interceptors) {
            this(backend, bodyHandler, pushPromiseHandler, interceptors, 0);
        }

        private InterceptorChain(HttpClient backend, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler, List<Interceptor> interceptors, int currentInterceptorIndex) {
            this.backend = Objects.requireNonNull(backend);
            this.bodyHandler = Objects.requireNonNull(bodyHandler);
            this.pushPromiseHandler = pushPromiseHandler;
            this.interceptors = Objects.requireNonNull(interceptors);
            this.currentInterceptorIndex = currentInterceptorIndex;
        }

        @Override
        public HttpResponse.BodyHandler<T> bodyHandler() {
            return this.bodyHandler;
        }

        @Override
        public Optional<HttpResponse.PushPromiseHandler<T>> pushPromiseHandler() {
            return Optional.ofNullable(this.pushPromiseHandler);
        }

        @Override
        public Interceptor.Chain<T> withBodyHandler(HttpResponse.BodyHandler<T> bodyHandler) {
            return new InterceptorChain<T>(this.backend, bodyHandler, this.pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public Interceptor.Chain<T> withPushPromiseHandler(@Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
            return new InterceptorChain<T>(this.backend, this.bodyHandler, pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public <U> Interceptor.Chain<U> with(HttpResponse.BodyHandler<U> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<U> pushPromiseHandler) {
            return new InterceptorChain<U>(this.backend, bodyHandler, pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public HttpResponse<T> forward(HttpRequest request) throws IOException, InterruptedException {
            Objects.requireNonNull(request);
            return this.currentInterceptorIndex >= this.interceptors.size() ? this.backend.send(request, this.bodyHandler) : this.interceptors.get(this.currentInterceptorIndex).intercept(request, this.nextInterceptorChain());
        }

        @Override
        public CompletableFuture<HttpResponse<T>> forwardAsync(HttpRequest request) {
            Objects.requireNonNull(request);
            return this.currentInterceptorIndex >= this.interceptors.size() ? this.backend.sendAsync(request, this.bodyHandler, this.pushPromiseHandler) : this.interceptors.get(this.currentInterceptorIndex).interceptAsync(request, this.nextInterceptorChain());
        }

        private InterceptorChain<T> nextInterceptorChain() {
            return new InterceptorChain<T>(this.backend, this.bodyHandler, this.pushPromiseHandler, this.interceptors, this.currentInterceptorIndex + 1);
        }
    }

    public static class Builder
    extends BaseBuilder<Builder>
    implements HttpClient.Builder {
        private static final @Nullable MethodHandle LOCAL_ADDRESS;
        final HttpClient.Builder backendBuilder = HttpClient.newBuilder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder cache(HttpCache cache) {
            this.caches = List.of(cache);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder cacheChain(List<HttpCache> caches) {
            List<HttpCache> cachesCopy = List.copyOf(caches);
            Validate.requireArgument(!cachesCopy.isEmpty(), "Must have at least one cache in the chain");
            this.caches = cachesCopy;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder cookieHandler(CookieHandler cookieHandler) {
            this.backendBuilder.cookieHandler(cookieHandler);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder connectTimeout(Duration duration) {
            this.backendBuilder.connectTimeout(duration);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder sslContext(SSLContext sslContext) {
            this.backendBuilder.sslContext(sslContext);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder sslParameters(SSLParameters sslParameters) {
            this.backendBuilder.sslParameters(sslParameters);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.backendBuilder.executor(executor);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder followRedirects(HttpClient.Redirect policy) {
            this.redirectPolicy = Objects.requireNonNull(policy);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder version(HttpClient.Version version) {
            this.backendBuilder.version(version);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder priority(int priority) {
            this.backendBuilder.priority(priority);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder proxy(ProxySelector proxySelector) {
            this.backendBuilder.proxy(proxySelector);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder authenticator(Authenticator authenticator) {
            this.backendBuilder.authenticator(authenticator);
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        HttpClient buildBackend() {
            if (this.caches.isEmpty() && this.redirectPolicy != null) {
                this.backendBuilder.followRedirects(this.redirectPolicy);
            }
            return this.backendBuilder.build();
        }

        static Builder create() {
            return LOCAL_ADDRESS != null ? new BuilderForJava19AndLater() : new Builder();
        }

        static {
            MethodHandle localAddress;
            try {
                localAddress = MethodHandles.lookup().findVirtual(HttpClient.Builder.class, "localAddress", MethodType.methodType(HttpClient.Builder.class, InetAddress.class));
            }
            catch (NoSuchMethodException e) {
                localAddress = null;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            LOCAL_ADDRESS = localAddress;
        }

        private static final class BuilderForJava19AndLater
        extends Builder {
            BuilderForJava19AndLater() {
            }

            @Override
            public HttpClient.Builder localAddress(InetAddress localAddr) {
                try {
                    Validate.castNonNull(LOCAL_ADDRESS).invoke(this.backendBuilder, localAddr);
                    return this;
                }
                catch (Throwable e) {
                    Unchecked.propagateIfUnchecked(e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static final class WithClientBuilder
    extends BaseBuilder<WithClientBuilder> {
        private final HttpClient backend;

        WithClientBuilder(HttpClient backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        WithClientBuilder self() {
            return this;
        }

        @Override
        HttpClient buildBackend() {
            return this.backend;
        }
    }

    public static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        final HeadersBuilder defaultHeadersBuilder = new HeadersBuilder();
        @MonotonicNonNull String userAgent;
        @MonotonicNonNull URI baseUri;
        @MonotonicNonNull Duration requestTimeout;
        @MonotonicNonNull Duration headersTimeout;
        @MonotonicNonNull Delayer headersTimeoutDelayer;
        @MonotonicNonNull Duration readTimeout;
        @MonotonicNonNull Delayer readTimeoutDelayer;
        @MonotonicNonNull AdapterCodec adapterCodec;
        boolean autoAcceptEncoding = true;
        final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        final List<Interceptor> backendInterceptors = new ArrayList<Interceptor>();
        List<HttpCache> caches = List.of();
        @MonotonicNonNull HttpClient.Redirect redirectPolicy;

        BaseBuilder() {
        }

        @CanIgnoreReturnValue
        public final B apply(Consumer<? super B> consumer) {
            consumer.accept(this.self());
            return this.self();
        }

        @CanIgnoreReturnValue
        public B userAgent(String userAgent) {
            this.defaultHeadersBuilder.set("User-Agent", userAgent);
            this.userAgent = userAgent;
            return this.self();
        }

        @CanIgnoreReturnValue
        public B baseUri(String uri) {
            return this.baseUri(URI.create(uri));
        }

        @CanIgnoreReturnValue
        public B baseUri(URI uri) {
            this.baseUri = Methanol.validateUri(uri);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B defaultHeader(String name, String value) {
            this.defaultHeadersBuilder.add(name, value);
            if (name.equalsIgnoreCase("User-Agent")) {
                this.userAgent = value;
            }
            return this.self();
        }

        @CanIgnoreReturnValue
        public B defaultHeaders(String ... headers) {
            Validate.requireArgument(headers.length > 0 && headers.length % 2 == 0, "Illegal number of headers: %d", headers.length);
            for (int i = 0; i < headers.length; i += 2) {
                this.defaultHeader(headers[i], headers[i + 1]);
            }
            return this.self();
        }

        @CanIgnoreReturnValue
        public B defaultHeaders(Consumer<HeadersAccumulator<?>> configurator) {
            configurator.accept(this.defaultHeadersBuilder.asHeadersAccumulator());
            this.defaultHeadersBuilder.lastValue("User-Agent").ifPresent(userAgent -> {
                this.userAgent = userAgent;
            });
            return this.self();
        }

        @CanIgnoreReturnValue
        public B requestTimeout(Duration requestTimeout) {
            this.requestTimeout = Utils.requirePositiveDuration(requestTimeout);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B headersTimeout(Duration headersTimeout) {
            return this.headersTimeout(headersTimeout, Delayer.systemDelayer());
        }

        @CanIgnoreReturnValue
        public B headersTimeout(Duration headersTimeout, ScheduledExecutorService scheduler) {
            return this.headersTimeout(headersTimeout, Delayer.of(scheduler));
        }

        @CanIgnoreReturnValue
        B headersTimeout(Duration headersTimeout, Delayer delayer) {
            this.headersTimeout = Utils.requirePositiveDuration(headersTimeout);
            this.headersTimeoutDelayer = Objects.requireNonNull(delayer);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B readTimeout(Duration readTimeout) {
            return this.readTimeout(readTimeout, Delayer.systemDelayer());
        }

        @CanIgnoreReturnValue
        public B readTimeout(Duration readTimeout, ScheduledExecutorService scheduler) {
            return this.readTimeout(readTimeout, Delayer.of(scheduler));
        }

        @CanIgnoreReturnValue
        private B readTimeout(Duration readTimeout, Delayer delayer) {
            this.readTimeout = Utils.requirePositiveDuration(readTimeout);
            this.readTimeoutDelayer = Objects.requireNonNull(delayer);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B adapterCodec(AdapterCodec adapterCodec) {
            this.adapterCodec = Objects.requireNonNull(adapterCodec);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B autoAcceptEncoding(boolean autoAcceptEncoding) {
            this.autoAcceptEncoding = autoAcceptEncoding;
            return this.self();
        }

        @CanIgnoreReturnValue
        public B interceptor(Interceptor interceptor) {
            this.interceptors.add(Objects.requireNonNull(interceptor));
            return this.self();
        }

        @CanIgnoreReturnValue
        public B backendInterceptor(Interceptor interceptor) {
            this.backendInterceptors.add(Objects.requireNonNull(interceptor));
            return this.self();
        }

        @Deprecated(since="1.5.0")
        @CanIgnoreReturnValue
        @InlineMe(replacement="this.backendInterceptor(interceptor)")
        public final B postDecorationInterceptor(Interceptor interceptor) {
            return this.backendInterceptor(interceptor);
        }

        public Methanol build() {
            return SHUTDOWN != null ? new MethanolForJava21AndLater(this) : new Methanol(this);
        }

        abstract B self();

        abstract HttpClient buildBackend();
    }

    public static interface Interceptor {
        public <T> HttpResponse<T> intercept(HttpRequest var1, Chain<T> var2) throws IOException, InterruptedException;

        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest var1, Chain<T> var2);

        public static Interceptor create(final Function<HttpRequest, HttpRequest> operator) {
            Objects.requireNonNull(operator);
            return new Interceptor(){

                @Override
                public <T> HttpResponse<T> intercept(HttpRequest request, Chain<T> chain) throws IOException, InterruptedException {
                    return chain.forward((HttpRequest)operator.apply(request));
                }

                @Override
                public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Chain<T> chain) {
                    return chain.forwardAsync((HttpRequest)operator.apply(request));
                }
            };
        }

        public static interface Chain<T> {
            public HttpResponse.BodyHandler<T> bodyHandler();

            public Optional<HttpResponse.PushPromiseHandler<T>> pushPromiseHandler();

            public Chain<T> withBodyHandler(HttpResponse.BodyHandler<T> var1);

            public Chain<T> withPushPromiseHandler(@Nullable HttpResponse.PushPromiseHandler<T> var1);

            default public <U> Chain<U> with(HttpResponse.BodyHandler<U> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<U> pushPromiseHandler) {
                throw new UnsupportedOperationException();
            }

            default public Chain<T> with(UnaryOperator<HttpResponse.BodyHandler<T>> bodyHandlerTransformer) {
                return this.withBodyHandler((HttpResponse.BodyHandler)bodyHandlerTransformer.apply(this.bodyHandler()));
            }

            default public Chain<T> with(UnaryOperator<HttpResponse.BodyHandler<T>> bodyHandlerTransformer, UnaryOperator<HttpResponse.PushPromiseHandler<T>> pushPromiseHandlerTransformer) {
                return this.with((HttpResponse.BodyHandler)bodyHandlerTransformer.apply(this.bodyHandler()), this.pushPromiseHandler().map(pushPromiseHandlerTransformer).orElse(null));
            }

            public HttpResponse<T> forward(HttpRequest var1) throws IOException, InterruptedException;

            public CompletableFuture<HttpResponse<T>> forwardAsync(HttpRequest var1);
        }
    }

    private static final class MethanolForJava21AndLater
    extends Methanol {
        MethanolForJava21AndLater(BaseBuilder<?> builder) {
            super(builder);
        }

        @Override
        public void shutdown() {
            try {
                Validate.castNonNull(SHUTDOWN).invokeExact(this.underlyingClient());
            }
            catch (Throwable e) {
                Unchecked.propagateIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean awaitTermination(Duration duration) throws InterruptedException {
            try {
                return Validate.castNonNull(AWAIT_TERMINATION).invokeExact(this.underlyingClient(), duration);
            }
            catch (Throwable e) {
                Unchecked.propagateIfUnchecked(e);
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isTerminated() {
            try {
                return Validate.castNonNull(IS_TERMINATED).invokeExact(this.underlyingClient());
            }
            catch (Throwable e) {
                Unchecked.propagateIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void shutdownNow() {
            try {
                Validate.castNonNull(SHUTDOWN_NOW).invokeExact(this.underlyingClient());
            }
            catch (Throwable e) {
                Unchecked.propagateIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                Validate.castNonNull(CLOSE).invokeExact(this.underlyingClient());
            }
            catch (Throwable e) {
                Unchecked.propagateIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }
}

