/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol;

import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.MutableRequest;
import com.namelessmc.plugin.lib.methanol.TypeRef;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class TaggableRequest
extends HttpRequest {
    TaggableRequest() {
    }

    public <T> Optional<T> tag(Class<T> type) {
        return this.tag(TypeRef.of(type));
    }

    public <T> Optional<T> tag(TypeRef<T> typeRef) {
        return Optional.ofNullable(this.tags().get(Objects.requireNonNull(typeRef)));
    }

    public abstract BodyAdapter.Hints hints();

    abstract Map<TypeRef<?>, Object> tags();

    static BodyAdapter.Hints hintsOf(HttpRequest request) {
        return request instanceof TaggableRequest ? ((TaggableRequest)request).hints() : BodyAdapter.Hints.empty();
    }

    public static TaggableRequest from(HttpRequest request) {
        return request instanceof TaggableRequest ? (TaggableRequest)request : MutableRequest.copyOf(request).toImmutableRequest();
    }

    public static <T> Optional<T> tagOf(HttpRequest request, Class<T> type) {
        return request instanceof TaggableRequest ? ((TaggableRequest)request).tag(type) : Optional.empty();
    }

    public static <T> Optional<T> tagOf(HttpRequest request, TypeRef<T> typeRef) {
        return request instanceof TaggableRequest ? ((TaggableRequest)request).tag(typeRef) : Optional.empty();
    }

    public static interface Builder
    extends HttpRequest.Builder {
        @CanIgnoreReturnValue
        public Builder tag(Object var1);

        @CanIgnoreReturnValue
        public <T> Builder tag(Class<T> var1, T var2);

        @CanIgnoreReturnValue
        public <T> Builder tag(TypeRef<T> var1, T var2);

        @CanIgnoreReturnValue
        public Builder removeTag(Class<?> var1);

        @CanIgnoreReturnValue
        public Builder removeTag(TypeRef<?> var1);

        @Override
        @CanIgnoreReturnValue
        public Builder uri(URI var1);

        @Override
        @CanIgnoreReturnValue
        public Builder expectContinue(boolean var1);

        @Override
        @CanIgnoreReturnValue
        public Builder version(HttpClient.Version var1);

        @Override
        @CanIgnoreReturnValue
        public Builder header(String var1, String var2);

        @Override
        @CanIgnoreReturnValue
        public Builder headers(String ... var1);

        @Override
        @CanIgnoreReturnValue
        public Builder timeout(Duration var1);

        @Override
        @CanIgnoreReturnValue
        public Builder setHeader(String var1, String var2);

        @Override
        @CanIgnoreReturnValue
        public Builder GET();

        @Override
        @CanIgnoreReturnValue
        public Builder POST(HttpRequest.BodyPublisher var1);

        @Override
        @CanIgnoreReturnValue
        public Builder PUT(HttpRequest.BodyPublisher var1);

        @Override
        @CanIgnoreReturnValue
        public Builder DELETE();

        @Override
        @CanIgnoreReturnValue
        public Builder method(String var1, HttpRequest.BodyPublisher var2);

        @Override
        public Builder copy();

        @Override
        public TaggableRequest build();
    }
}

