/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.BodyAdapter;
import com.namelessmc.plugin.lib.methanol.MediaType;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.text.HttpCharMatchers;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Utils {
    private static final Clock SYSTEM_MILLIS_UTC = Clock.tickMillis(ZoneOffset.UTC);
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int BUFFER_SIZE;

    private Utils() {
    }

    public static boolean isValidToken(CharSequence token) {
        return token.length() != 0 && HttpCharMatchers.TOKEN_MATCHER.allMatch(token);
    }

    public static boolean isValidHeaderName(String name) {
        return name.startsWith(":") ? Utils.isValidToken(CharBuffer.wrap(name, 1, name.length())) : Utils.isValidToken(name);
    }

    @CanIgnoreReturnValue
    public static <S extends CharSequence> S requireValidToken(S token) {
        Validate.requireArgument(Utils.isValidToken(token), "illegal token: '%s'", token);
        return token;
    }

    @CanIgnoreReturnValue
    public static String requireValidHeaderName(String name) {
        Validate.requireArgument(Utils.isValidHeaderName(name), "illegal header name: '%s'", name);
        return name;
    }

    @CanIgnoreReturnValue
    public static String requireValidHeaderValue(String value) {
        Validate.requireArgument(HttpCharMatchers.FIELD_VALUE_MATCHER.allMatch(value), "illegal header value: '%s'", value);
        return value;
    }

    public static void requireValidHeader(String name, String value) {
        Utils.requireValidHeaderName(name);
        Utils.requireValidHeaderValue(value);
    }

    @CanIgnoreReturnValue
    public static Duration requirePositiveDuration(Duration duration) {
        Validate.requireArgument(!duration.isNegative() && !duration.isZero(), "non-positive duration: %s", duration);
        return duration;
    }

    @CanIgnoreReturnValue
    public static Duration requireNonNegativeDuration(Duration duration) {
        Validate.requireArgument(!duration.isNegative(), "negative duration: %s", duration);
        return duration;
    }

    public static int copyRemaining(ByteBuffer src, ByteBuffer dst) {
        int toCopy = Math.min(src.remaining(), dst.remaining());
        int srcLimit = src.limit();
        src.limit(src.position() + toCopy);
        dst.put(src);
        src.limit(srcLimit);
        return toCopy;
    }

    public static ByteBuffer copy(ByteBuffer buffer) {
        return ByteBuffer.allocate(buffer.remaining()).put(buffer).flip();
    }

    public static Clock systemMillisUtc() {
        return SYSTEM_MILLIS_UTC;
    }

    private static RuntimeException rethrowExecutionExceptionCause(ExecutionException exception) throws IOException, InterruptedException {
        Throwable clonedCause = Utils.tryCloneThrowable(exception.getCause());
        if (clonedCause instanceof RuntimeException) {
            throw (RuntimeException)clonedCause;
        }
        if (clonedCause instanceof Error) {
            throw (Error)clonedCause;
        }
        if (clonedCause instanceof IOException) {
            throw (IOException)clonedCause;
        }
        if (clonedCause instanceof InterruptedException) {
            throw (InterruptedException)clonedCause;
        }
        throw new IOException(clonedCause);
    }

    private static @Nullable Throwable tryCloneThrowable(@Nullable Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable throwableToClone = Utils.getDeepCompletionCause(t);
        if (!(throwableToClone instanceof RuntimeException || throwableToClone instanceof Error || throwableToClone instanceof IOException || throwableToClone instanceof InterruptedException)) {
            return null;
        }
        Class<?> throwableClass = throwableToClone.getClass();
        String message = throwableToClone.getMessage();
        try {
            return (Throwable)throwableClass.getConstructor(String.class, Throwable.class).newInstance(message, throwableToClone);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            try {
                Throwable cloned2 = (Throwable)throwableClass.getConstructor(String.class).newInstance(message);
                try {
                    return cloned2.initCause(throwableToClone);
                }
                catch (IllegalStateException ignored) {
                    return null;
                }
            }
            catch (ReflectiveOperationException cloned2) {
                try {
                    return (Throwable)throwableClass.getConstructor(Throwable.class).newInstance(throwableToClone);
                }
                catch (ReflectiveOperationException cloned2) {
                    try {
                        Throwable cloned3 = (Throwable)throwableClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        try {
                            return cloned3.initCause(throwableToClone);
                        }
                        catch (IllegalStateException ignored) {
                            return null;
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException2) {
                        return null;
                    }
                }
            }
        }
    }

    public static Throwable getDeepCompletionCause(Throwable t) {
        Throwable deeperCause;
        Throwable cause = t;
        while ((cause instanceof CompletionException || cause instanceof ExecutionException) && (deeperCause = cause.getCause()) != null) {
            cause = deeperCause;
        }
        return cause;
    }

    public static <T> T get(Future<T> future) throws IOException, InterruptedException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw Utils.rethrowExecutionExceptionCause(e);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw e;
        }
    }

    public static <T> T getIo(Future<T> future) throws IOException {
        try {
            return Utils.get(future);
        }
        catch (InterruptedException e) {
            throw Utils.toInterruptedIOException(e);
        }
    }

    public static String escapeAndQuoteValueIfNeeded(String value) {
        return Utils.isValidToken(value) ? value : Utils.escapeAndQuote(value);
    }

    private static String escapeAndQuote(String value) {
        StringBuilder escaped = new StringBuilder();
        escaped.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        escaped.append('\"');
        return escaped.toString();
    }

    public static boolean startsWithIgnoreCase(String source, String prefix) {
        return source.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static CompletionException toCompletionException(Throwable t) {
        return t instanceof CompletionException ? (CompletionException)t : new CompletionException(t);
    }

    public static InterruptedIOException toInterruptedIOException(InterruptedException e) {
        return (InterruptedIOException)new InterruptedIOException().initCause(e);
    }

    public static long remaining(List<ByteBuffer> buffers) {
        long remaining = 0L;
        for (ByteBuffer buffer : buffers) {
            remaining += (long)buffer.remaining();
        }
        return remaining;
    }

    public static long remaining(ByteBuffer[] buffers) {
        long remaining = 0L;
        for (ByteBuffer buffer : buffers) {
            remaining += (long)buffer.remaining();
        }
        return remaining;
    }

    public static BodyAdapter.Hints hintsOf(@Nullable MediaType mediaType) {
        return mediaType != null ? BodyAdapter.Hints.of(mediaType) : BodyAdapter.Hints.empty();
    }

    public static String toStringIdentityPrefix(Object object) {
        return object.getClass().getSimpleName() + "@" + Integer.toHexString(object.hashCode());
    }

    public static String forwardingObjectToString(Object forwardingObject, Object delegate) {
        return Utils.toStringIdentityPrefix(forwardingObject) + "[delegate=" + delegate + "]";
    }

    static {
        int bufferSize = Integer.getInteger("jdk.httpclient.bufsize", 16384);
        if (bufferSize <= 0) {
            bufferSize = 16384;
        }
        BUFFER_SIZE = bufferSize;
    }
}

