/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.methanol.MutableRequest;
import com.namelessmc.plugin.lib.methanol.ResponseBuilder;
import com.namelessmc.plugin.lib.methanol.TrackedResponse;
import com.namelessmc.plugin.lib.methanol.internal.extensions.HeadersBuilder;
import com.namelessmc.plugin.lib.methanol.internal.text.HeaderValueTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

public final class CacheResponseMetadata {
    private static final int VARINT_SHIFT = 7;
    private static final int VARINT_MASK = 127;
    private static final int VARINT_HAS_MORE_MASK = 128;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int FLAG_HAS_SSL_INFO = 1;
    private final URI uri;
    private final String requestMethod;
    private final HttpHeaders varyHeaders;
    private final int statusCode;
    private final HttpHeaders responseHeaders;
    private final Instant timeRequestSent;
    private final Instant timeResponseReceived;
    private final @Nullable SSLSession sslSession;

    private CacheResponseMetadata(URI uri, String requestMethod, HttpHeaders varyHeaders, int statusCode, HttpHeaders responseHeaders, Instant timeRequestSent, Instant timeResponseReceived, @Nullable SSLSession sslSession) {
        this.uri = uri;
        this.requestMethod = requestMethod;
        this.varyHeaders = varyHeaders;
        this.statusCode = statusCode;
        this.responseHeaders = responseHeaders;
        this.timeRequestSent = timeRequestSent;
        this.timeResponseReceived = timeResponseReceived;
        this.sslSession = sslSession;
    }

    HttpHeaders varyHeadersForTesting() {
        return this.varyHeaders;
    }

    public URI uri() {
        return this.uri;
    }

    public boolean matches(HttpRequest request) {
        return this.uri.equals(request.uri()) && this.requestMethod.equalsIgnoreCase(request.method()) && this.selectedBy(request.headers());
    }

    private boolean selectedBy(HttpHeaders requestHeaders) {
        return CacheResponseMetadata.varyFields(this.responseHeaders).stream().allMatch(name -> CacheResponseMetadata.unorderedEquals(this.varyHeaders.allValues((String)name), requestHeaders.allValues((String)name)));
    }

    private static boolean unorderedEquals(List<String> left, List<String> right) {
        if (left.size() != right.size()) {
            return false;
        }
        ArrayList<String> mutableOther = new ArrayList<String>(right);
        for (String value : left) {
            int i = mutableOther.indexOf(value);
            if (i < 0) {
                return false;
            }
            mutableOther.remove(i);
        }
        return true;
    }

    public ByteBuffer encode() {
        MetadataWriter writer = new MetadataWriter();
        writer.writeInt(this.sslSession != null ? 1 : 0);
        writer.writeUtf8(this.uri.toString());
        writer.writeUtf8(this.requestMethod);
        writer.writeHeaders(this.varyHeaders);
        writer.writeInt(this.statusCode);
        writer.writeHeaders(this.responseHeaders);
        writer.writeInstant(this.timeRequestSent);
        writer.writeInstant(this.timeResponseReceived);
        if (this.sslSession != null) {
            try {
                writer.writeSSLSession(this.sslSession);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return writer.snapshot();
    }

    public ResponseBuilder<?> toResponseBuilder() {
        return ((ResponseBuilder)ResponseBuilder.create().uri(this.uri).request(MutableRequest.create(this.uri).method(this.requestMethod, HttpRequest.BodyPublishers.noBody()).headers(this.varyHeaders).toImmutableRequest()).statusCode(this.statusCode).headers(this.responseHeaders)).timeRequestSent(this.timeRequestSent).timeResponseReceived(this.timeResponseReceived).sslSession(this.sslSession).version(HttpClient.Version.HTTP_1_1);
    }

    public static CacheResponseMetadata decode(ByteBuffer metadataBuffer) throws IOException {
        MetadataReader reader = new MetadataReader(metadataBuffer);
        int flags = reader.readInt();
        URI uri = CacheResponseMetadata.parseUri(reader.readUtf8String());
        String requestMethod = reader.readUtf8String();
        HttpHeaders varyHeaders = reader.readHeaders();
        int statusCode = reader.readInt();
        HttpHeaders headers = reader.readHeaders();
        Instant timeRequestSent = reader.readInstant();
        Instant timeResponseReceived = reader.readInstant();
        SSLSession sslSession = (flags & 1) != 0 ? reader.readSSLSession() : null;
        return new CacheResponseMetadata(uri, requestMethod, varyHeaders, statusCode, headers, timeRequestSent, timeResponseReceived, sslSession);
    }

    private static URI parseUri(String uri) throws IOException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("invalid URI", e);
        }
    }

    public static CacheResponseMetadata from(TrackedResponse<?> response) {
        return new CacheResponseMetadata(response.uri(), response.request().method(), CacheResponseMetadata.varyHeaders(response.request().headers(), response.headers()), response.statusCode(), response.headers(), response.timeRequestSent(), response.timeResponseReceived(), response.sslSession().orElse(null));
    }

    public static Set<String> varyFields(HttpHeaders headers) {
        List<String> values = headers.allValues("Vary");
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> fields = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String value : values) {
            HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value);
            do {
                fields.add(tokenizer.nextToken());
            } while (tokenizer.consumeDelimiter(','));
        }
        return Collections.unmodifiableSet(fields);
    }

    private static HttpHeaders varyHeaders(HttpHeaders requestHeaders, HttpHeaders responseHeaders) {
        HeadersBuilder builder = new HeadersBuilder();
        for (String name : CacheResponseMetadata.varyFields(responseHeaders)) {
            requestHeaders.allValues(name).forEach(value -> builder.addLenient(name, (String)value));
        }
        return builder.build();
    }

    private static final class CacheRecoveredSSLSession
    implements SSLSession {
        private final String cipherSuite;
        private final String protocol;
        private final List<java.security.cert.X509Certificate> peerCertificates;
        private final List<java.security.cert.X509Certificate> localCertificates;

        CacheRecoveredSSLSession(String cipherSuite, String protocol, List<java.security.cert.X509Certificate> peerCertificates, List<java.security.cert.X509Certificate> localCertificates) {
            this.cipherSuite = cipherSuite;
            this.protocol = protocol;
            this.localCertificates = localCertificates;
            this.peerCertificates = peerCertificates;
        }

        @Override
        public String getCipherSuite() {
            return this.cipherSuite;
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            this.requireAuthenticatedPeer();
            return (Certificate[])this.peerCertificates.toArray(Certificate[]::new);
        }

        @Override
        public @Nullable Certificate[] getLocalCertificates() {
            return this.localCertificates.isEmpty() ? null : (Certificate[])this.localCertificates.toArray(Certificate[]::new);
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            this.requireAuthenticatedPeer();
            return CacheRecoveredSSLSession.x509principal(this.peerCertificates);
        }

        @Override
        public @Nullable Principal getLocalPrincipal() {
            return this.localCertificates.isEmpty() ? null : CacheRecoveredSSLSession.x509principal(this.localCertificates);
        }

        private void requireAuthenticatedPeer() throws SSLPeerUnverifiedException {
            if (this.peerCertificates.isEmpty()) {
                throw new SSLPeerUnverifiedException("peer not authenticated");
            }
        }

        private static Principal x509principal(List<java.security.cert.X509Certificate> certificates) {
            return certificates.get(0).getSubjectX500Principal();
        }

        @Override
        public byte[] getId() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public @Nullable SSLSessionContext getSessionContext() {
            return null;
        }

        @Override
        public long getCreationTime() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public long getLastAccessedTime() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String name, Object value) {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public @Nullable Object getValue(String name) {
            return null;
        }

        @Override
        public void removeValue(String name) {
        }

        @Override
        public String[] getValueNames() {
            return new String[0];
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public @Nullable String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return -1;
        }

        @Override
        public int getPacketBufferSize() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        @Override
        public int getApplicationBufferSize() {
            throw CacheRecoveredSSLSession.unsupported();
        }

        private static UnsupportedOperationException unsupported() {
            throw new UnsupportedOperationException("SSLSession recovered from cache doesn't support this method");
        }
    }

    private static final class MetadataWriter {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        MetadataWriter() {
        }

        void writeInt(int value) {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }

        private void writeLong(long value) {
            this.writeVarint(value);
        }

        private void writeByteArray(byte[] array) {
            this.writeInt(array.length);
            this.buffer.write(array, 0, array.length);
        }

        void writeUtf8(String value) {
            this.writeByteArray(value.getBytes(StandardCharsets.UTF_8));
        }

        private void writeVarint(long value) {
            while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
                this.buffer.write((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
            this.buffer.write((int)value);
        }

        void writeInstant(Instant instant) {
            this.writeLong(instant.toEpochMilli());
        }

        void writeHeaders(HttpHeaders headers) {
            Map<String, List<String>> headersMap = headers.map();
            int deepHeaderCount = headersMap.values().stream().mapToInt(Collection::size).sum();
            this.writeInt(deepHeaderCount);
            headersMap.forEach((name, values) -> values.forEach(value -> this.writeUtf8(name + ":" + value)));
        }

        void writeSSLSession(SSLSession session) throws IOException {
            this.writeUtf8(session.getCipherSuite());
            this.writeUtf8(session.getProtocol());
            try {
                this.writeCertificates(session.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException e) {
                this.writeInt(0);
            }
            Certificate[] localCertificates = session.getLocalCertificates();
            if (localCertificates != null) {
                this.writeCertificates(localCertificates);
            } else {
                this.writeInt(0);
            }
        }

        private void writeCertificates(Certificate[] certificates) throws IOException {
            this.writeInt(certificates.length);
            try {
                for (Certificate cert : certificates) {
                    this.writeByteArray(cert.getEncoded());
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e);
            }
        }

        ByteBuffer snapshot() {
            return ByteBuffer.wrap(this.buffer.toByteArray());
        }
    }

    private static final class MetadataReader {
        private final ByteBuffer buffer;

        MetadataReader(ByteBuffer buffer) {
            this.buffer = buffer.slice();
        }

        int readInt() throws IOException {
            return (int)this.readVarint(32);
        }

        private long readLong() throws IOException {
            return this.readVarint(64);
        }

        private long readVarint(int sizeInBits) throws IOException {
            long value = 0L;
            for (int shift = 0; shift < sizeInBits; shift += 7) {
                long currentByte = this.requireByte() & 0xFF;
                value |= (currentByte & 0x7FL) << shift;
                if ((currentByte & 0x80L) != 0L) continue;
                return value;
            }
            throw new IOException("wrong varint format");
        }

        private byte requireByte() throws EOFException {
            try {
                return this.buffer.get();
            }
            catch (BufferUnderflowException e) {
                throw this.endOfInput();
            }
        }

        private CharBuffer readUtf8Chars() throws IOException {
            int length = this.readInt();
            int originalLimit = this.buffer.limit();
            try {
                this.buffer.limit(this.buffer.position() + length);
            }
            catch (IllegalArgumentException e) {
                throw this.endOfInput();
            }
            CharBuffer value = StandardCharsets.UTF_8.decode(this.buffer);
            this.buffer.limit(originalLimit);
            return value;
        }

        String readUtf8String() throws IOException {
            return this.readUtf8Chars().toString();
        }

        HttpHeaders readHeaders() throws IOException {
            HeadersBuilder builder = new HeadersBuilder();
            int count = this.readInt();
            for (int i = 0; i < count; ++i) {
                this.addHeader(builder, this.readUtf8Chars());
            }
            return builder.build();
        }

        private void addHeader(HeadersBuilder builder, CharBuffer header) throws IOException {
            int separatorIndex = this.indexOfHeaderSeparator(header, 0);
            if (separatorIndex == 0) {
                separatorIndex = this.indexOfHeaderSeparator(header, 1);
            }
            if (separatorIndex <= 0) {
                throw new IOException("malformed header");
            }
            int originalLimit = header.limit();
            String name = header.limit(separatorIndex).toString();
            String value = header.limit(originalLimit).position(separatorIndex + 1).toString();
            builder.add(name.trim(), value.trim());
        }

        private int indexOfHeaderSeparator(CharBuffer buffer, int offset) {
            for (int p = offset; p < buffer.limit(); ++p) {
                if (buffer.get(p) != ':') continue;
                return p;
            }
            return -1;
        }

        private byte[] readByteArray() throws IOException {
            int length = this.readInt();
            byte[] array = new byte[length];
            try {
                this.buffer.get(array);
            }
            catch (BufferUnderflowException e) {
                throw new EOFException("expected " + length + " bytes (position = " + this.buffer.position() + ")");
            }
            return array;
        }

        private List<java.security.cert.X509Certificate> readCertificates(CertificateFactory factory) throws IOException, CertificateException {
            ArrayList<java.security.cert.X509Certificate> certificates = new ArrayList<java.security.cert.X509Certificate>();
            int count = this.readInt();
            for (int i = 0; i < count; ++i) {
                byte[] certBytes = this.readByteArray();
                certificates.add((java.security.cert.X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes)));
            }
            return Collections.unmodifiableList(certificates);
        }

        SSLSession readSSLSession() throws IOException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String cipherSuite = this.readUtf8String();
                String protocol = this.readUtf8String();
                List<java.security.cert.X509Certificate> peerCertificates = this.readCertificates(certificateFactory);
                List<java.security.cert.X509Certificate> localCertificates = this.readCertificates(certificateFactory);
                return new CacheRecoveredSSLSession(cipherSuite, protocol, peerCertificates, localCertificates);
            }
            catch (CertificateException e) {
                throw new IOException(e);
            }
        }

        Instant readInstant() throws IOException {
            return Instant.ofEpochMilli(this.readLong());
        }

        private EOFException endOfInput() {
            return new EOFException("unexpected end of input (position = " + this.buffer.position() + ")");
        }
    }
}

