/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.EnsuresNonNullIf;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.MonotonicNonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.errorprone-annotations.concurrent.GuardedBy;
import com.namelessmc.plugin.lib.methanol.internal.DebugUtils;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.Validate;
import com.namelessmc.plugin.lib.methanol.internal.cache.FileIO;
import com.namelessmc.plugin.lib.methanol.internal.cache.Store;
import com.namelessmc.plugin.lib.methanol.internal.cache.StoreCorruptionException;
import com.namelessmc.plugin.lib.methanol.internal.cache.TestableStore;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.Delayer;
import com.namelessmc.plugin.lib.methanol.internal.concurrent.SerialExecutor;
import com.namelessmc.plugin.lib.methanol.internal.function.ThrowingRunnable;
import com.namelessmc.plugin.lib.methanol.internal.function.Unchecked;
import com.namelessmc.plugin.lib.methanol.internal.util.Compare;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.zip.CRC32C;

public final class DiskStore
implements Store,
TestableStore {
    private static final System.Logger logger = System.getLogger(DiskStore.class.getName());
    private static final ThreadLocal<Boolean> isIndexExecutor = ThreadLocal.withInitial(() -> false);
    private static final int MAX_ENTRY_COUNT = 1000000;
    static final long INDEX_MAGIC = 7882834714441969516L;
    static final long ENTRY_MAGIC = 8891064658374387837L;
    static final int STORE_VERSION = 2;
    static final int INDEX_HEADER_SIZE = 24;
    static final int INDEX_ENTRY_SIZE = 26;
    static final int ENTRY_TRAILER_SIZE = 40;
    static final long INT_MASK = 0xFFFFFFFFL;
    static final int SHORT_MASK = 65535;
    static final String LOCK_FILENAME = ".lock";
    static final String INDEX_FILENAME = "index";
    static final String TEMP_INDEX_FILENAME = "index.tmp";
    static final String ENTRY_FILE_SUFFIX = ".ch3oh";
    static final String TEMP_ENTRY_FILE_SUFFIX = ".ch3oh.tmp";
    static final String ISOLATED_FILE_PREFIX = "RIP_";
    private final long maxSize;
    private final int appVersion;
    private final Path directory;
    private final Hasher hasher;
    private final SerialExecutor indexExecutor;
    private final IndexOperator indexOperator;
    private final IndexWriteScheduler indexWriteScheduler;
    private final EvictionScheduler evictionScheduler;
    private final DirectoryLock directoryLock;
    private final ConcurrentHashMap<Hash, Entry> entries = new ConcurrentHashMap();
    private final AtomicLong size = new AtomicLong();
    private final AtomicLong lruClock = new AtomicLong();
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    @GuardedBy(value="closeLock")
    private boolean closed;

    private DiskStore(Builder builder, boolean debugIndexOps) throws IOException {
        this.maxSize = builder.maxSize();
        this.appVersion = builder.appVersion();
        this.directory = builder.directory();
        this.hasher = builder.hasher();
        this.indexExecutor = new SerialExecutor(debugIndexOps ? DiskStore.toDebuggingIndexExecutorDelegate(builder.executor()) : builder.executor());
        this.indexOperator = debugIndexOps ? new DebugIndexOperator(this.directory, this.appVersion) : new IndexOperator(this.directory, this.appVersion);
        this.indexWriteScheduler = new IndexWriteScheduler(this.indexOperator, this.indexExecutor, this::indexEntriesSnapshot, builder.indexUpdateDelay(), builder.delayer(), builder.clock());
        this.evictionScheduler = new EvictionScheduler(this, builder.executor());
        if (debugIndexOps) {
            isIndexExecutor.set(true);
        }
        try {
            this.directoryLock = this.initialize();
        }
        finally {
            if (debugIndexOps) {
                isIndexExecutor.set(false);
            }
        }
    }

    Clock clock() {
        return this.indexWriteScheduler.clock();
    }

    Delayer delayer() {
        return this.indexWriteScheduler.delayer();
    }

    private DirectoryLock initialize() throws IOException {
        DirectoryLock lock = DirectoryLock.acquire(Files.createDirectories(this.directory, new FileAttribute[0]));
        long totalSize = 0L;
        long maxLastUsed = -1L;
        for (IndexEntry indexEntry : this.indexOperator.recoverEntries()) {
            this.entries.put(indexEntry.hash, new Entry(indexEntry));
            totalSize += indexEntry.size;
            maxLastUsed = Math.max(maxLastUsed, indexEntry.lastUsed);
        }
        this.size.set(totalSize);
        this.lruClock.set(maxLastUsed + 1L);
        if (totalSize > this.maxSize) {
            this.evictionScheduler.schedule();
        }
        return lock;
    }

    public Path directory() {
        return this.directory;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Store.Viewer> view(String key) throws IOException {
        Objects.requireNonNull(key);
        this.closeLock.readLock().lock();
        try {
            this.requireNotClosed();
            Entry entry = this.entries.get(this.hasher.hash(key));
            Optional<Object> optional = Optional.ofNullable(entry != null ? entry.view(key) : null);
            return optional;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public CompletableFuture<Optional<Store.Viewer>> view(String key, Executor executor) {
        return Unchecked.supplyAsync(() -> this.view(key), executor);
    }

    @Override
    public Optional<Store.Editor> edit(String key) throws IOException {
        Objects.requireNonNull(key);
        this.closeLock.readLock().lock();
        try {
            this.requireNotClosed();
            Optional<Store.Editor> optional = Optional.ofNullable(this.entries.computeIfAbsent(this.hasher.hash(key), x$0 -> new Entry((Hash)x$0)).edit(key, -1));
            return optional;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public CompletableFuture<Optional<Store.Editor>> edit(String key, Executor executor) {
        return Unchecked.supplyAsync(() -> this.edit(key), executor);
    }

    @Override
    public Iterator<Store.Viewer> iterator() {
        return new ConcurrentViewerIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) throws IOException {
        Objects.requireNonNull(key);
        this.closeLock.readLock().lock();
        try {
            int[] versionHolder;
            String keyIfKnown;
            this.requireNotClosed();
            Entry entry = this.entries.get(this.hasher.hash(key));
            if (entry != null && ((keyIfKnown = entry.keyIfKnown(versionHolder = new int[1])) == null || key.equals(keyIfKnown) || key.equals(entry.currentEditorKey()))) {
                boolean bl = this.removeEntry(entry, versionHolder[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public void clear() throws IOException {
        this.closeLock.readLock().lock();
        try {
            this.requireNotClosed();
            for (Entry entry : this.entries.values()) {
                this.removeEntry(entry);
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public long size() {
        return this.size.get();
    }

    @Override
    public void dispose() throws IOException {
        this.doClose(true);
        this.size.set(0L);
    }

    @Override
    public void close() throws IOException {
        this.doClose(false);
    }

    private void doClose(boolean disposing) throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.entries.values().forEach(Entry::freeze);
        try (DirectoryLock directoryLock = this.directoryLock;){
            if (disposing) {
                this.indexWriteScheduler.shutdown();
                DiskStore.deleteStoreContent(this.directory);
            } else {
                this.evictExcessiveEntries();
                this.indexWriteScheduler.forceSchedule();
                this.indexWriteScheduler.shutdown();
            }
        }
        this.indexExecutor.shutdown();
        this.evictionScheduler.shutdown();
        this.entries.clear();
    }

    @Override
    public void flush() throws IOException {
        this.indexWriteScheduler.forceSchedule();
    }

    public String toString() {
        boolean closed;
        this.closeLock.readLock().lock();
        try {
            closed = this.closed;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
        return Utils.toStringIdentityPrefix(this) + "[directory=" + this.directory + ", fileSystem=" + this.directory.getFileSystem() + ", appVersion=" + this.appVersion + ", maxSize=" + this.maxSize + ", size=" + this.size + ", " + (closed ? "CLOSED" : "OPEN") + "]";
    }

    private Set<IndexEntry> indexEntriesSnapshot() {
        HashSet<IndexEntry> snapshot = new HashSet<IndexEntry>();
        for (Entry entry : this.entries.values()) {
            IndexEntry indexEntry = entry.toIndexEntry();
            if (indexEntry == null) continue;
            snapshot.add(indexEntry);
        }
        return Collections.unmodifiableSet(snapshot);
    }

    @CanIgnoreReturnValue
    private boolean removeEntry(Entry entry) throws IOException {
        return this.removeEntry(entry, -1);
    }

    @CanIgnoreReturnValue
    private boolean removeEntry(Entry entry, int targetVersion) throws IOException {
        long evictedSize = this.evict(entry, targetVersion);
        if (evictedSize >= 0L) {
            this.size.addAndGet(-evictedSize);
            return true;
        }
        return false;
    }

    private long evict(Entry entry, int targetVersion) throws IOException {
        long evictedSize = entry.evict(targetVersion);
        if (evictedSize >= 0L) {
            this.entries.remove(entry.hash, entry);
            this.indexWriteScheduler.trySchedule();
        }
        return evictedSize;
    }

    private boolean evictExcessiveEntriesIfOpen() throws IOException {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            this.evictExcessiveEntries();
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private void evictExcessiveEntries() throws IOException {
        Iterator<Entry> lruIterator = null;
        long currentSize = this.size.get();
        while (currentSize > this.maxSize) {
            if (lruIterator == null) {
                lruIterator = this.entriesSnapshotInLruOrder().iterator();
            }
            if (!lruIterator.hasNext()) break;
            long evictedSize = this.evict(lruIterator.next(), -1);
            if (evictedSize >= 0L) {
                currentSize = this.size.addAndGet(-evictedSize);
                continue;
            }
            currentSize = this.size.get();
        }
    }

    private Collection<Entry> entriesSnapshotInLruOrder() {
        TreeMap<IndexEntry, Entry> lruEntries = new TreeMap<IndexEntry, Entry>(IndexEntry.LRU_ORDER);
        for (Entry entry : this.entries.values()) {
            IndexEntry indexEntry = entry.toIndexEntry();
            if (indexEntry == null) continue;
            lruEntries.put(indexEntry, entry);
        }
        return Collections.unmodifiableCollection(lruEntries.values());
    }

    private void requireNotClosed() {
        assert (this.holdsCloseLock());
        Validate.requireState(!this.closed, "closed");
    }

    private boolean holdsCloseLock() {
        ReentrantReadWriteLock lock = (ReentrantReadWriteLock)this.closeLock;
        return lock.isWriteLocked() || lock.getReadLockCount() > 0;
    }

    int indexWriteCount() {
        Validate.requireState(this.indexOperator instanceof DebugIndexOperator, "not debugging!");
        return ((DebugIndexOperator)this.indexOperator).writeCount();
    }

    long lruTime() {
        return this.lruClock.get();
    }

    @Override
    public List<String> entriesOnUnderlyingStorageForTesting(String key) {
        Hash hash = this.hasher.hash(key);
        Path path = this.directory.resolve(hash.toHexString() + ENTRY_FILE_SUFFIX);
        Store.Viewer viewer = new Entry(hash).view(key);
        try {
            List<String> list;
            List<String> list2 = list = viewer != null ? List.of(path.toString()) : List.of();
            if (viewer != null) {
                viewer.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (viewer != null) {
                    try {
                        viewer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static Executor toDebuggingIndexExecutorDelegate(Executor delegate) {
        return runnable -> delegate.execute(() -> {
            isIndexExecutor.set(true);
            try {
                runnable.run();
            }
            finally {
                isIndexExecutor.set(false);
            }
        });
    }

    private static void checkValue(long expected, long found, String msg) throws StoreCorruptionException {
        if (expected != found) {
            throw new StoreCorruptionException(String.format("%s; expected: %#x, found: %#x", msg, expected, found));
        }
    }

    private static void checkValue(boolean valueIsValid, String msg, long value) throws StoreCorruptionException {
        if (!valueIsValid) {
            throw new StoreCorruptionException(String.format("%s: %d", msg, value));
        }
    }

    private static int getNonNegativeInt(ByteBuffer buffer) throws StoreCorruptionException {
        int value = buffer.getInt();
        DiskStore.checkValue(value >= 0, "Expected a value >= 0", value);
        return value;
    }

    private static long getNonNegativeLong(ByteBuffer buffer) throws StoreCorruptionException {
        long value = buffer.getLong();
        DiskStore.checkValue(value >= 0L, "Expected a value >= 0", value);
        return value;
    }

    private static long getPositiveLong(ByteBuffer buffer) throws StoreCorruptionException {
        long value = buffer.getLong();
        DiskStore.checkValue(value > 0L, "Expected a positive value", value);
        return value;
    }

    private static @Nullable Hash entryFileToHash(String filename) {
        assert (filename.endsWith(ENTRY_FILE_SUFFIX) || filename.endsWith(TEMP_ENTRY_FILE_SUFFIX));
        int suffixLength = filename.endsWith(ENTRY_FILE_SUFFIX) ? ENTRY_FILE_SUFFIX.length() : TEMP_ENTRY_FILE_SUFFIX.length();
        return Hash.tryParse(filename.substring(0, filename.length() - suffixLength));
    }

    private static void replace(Path source, Path target) throws IOException {
        Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void deleteStoreContent(Path directory) throws IOException {
        Path lockFile = directory.resolve(LOCK_FILENAME);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, file -> !file.equals(lockFile));){
            for (Path file2 : stream) {
                DiskStore.safeDeleteIfExists(file2);
            }
        }
        catch (DirectoryIteratorException e) {
            throw e.getCause();
        }
    }

    private static void isolatedDeleteIfExists(Path file) throws IOException {
        try {
            Files.deleteIfExists(DiskStore.isolate(file));
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static Path isolate(Path file) throws IOException {
        while (true) {
            String randomFilename = ISOLATED_FILE_PREFIX + Long.toHexString(ThreadLocalRandom.current().nextLong());
            try {
                return Files.move(file, file.resolveSibling(randomFilename), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AccessDeniedException | FileAlreadyExistsException fileSystemException) {
                continue;
            }
            break;
        }
    }

    private static void safeDeleteIfExists(Path file) throws IOException {
        String filename;
        Path filenameComponent = file.getFileName();
        String string = filename = filenameComponent != null ? filenameComponent.toString() : "";
        if (filename.endsWith(ENTRY_FILE_SUFFIX)) {
            DiskStore.isolatedDeleteIfExists(file);
        } else if (filename.startsWith(ISOLATED_FILE_PREFIX)) {
            try {
                Files.deleteIfExists(file);
            }
            catch (AccessDeniedException accessDeniedException) {}
        } else {
            Files.deleteIfExists(file);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.WARNING, "Exception thrown when closing: " + closeable, (Throwable)e);
        }
    }

    private static void deleteIfExistsQuietly(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.WARNING, "Exception thrown when deleting: " + path, (Throwable)e);
        }
    }

    private static boolean keyMismatches(@Nullable String keyIfKnown, @Nullable String expectedKeyIfKnown) {
        return keyIfKnown != null && expectedKeyIfKnown != null && !keyIfKnown.equals(expectedKeyIfKnown);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long DEFAULT_INDEX_UPDATE_DELAY_MILLIS = 2000L;
        private static final Duration DEFAULT_INDEX_UPDATE_DELAY;
        private static final int UNSET_NUMBER = -1;
        private long maxSize = -1L;
        private @MonotonicNonNull Path directory;
        private @MonotonicNonNull Executor executor;
        private int appVersion = -1;
        private @MonotonicNonNull Hasher hasher;
        private @MonotonicNonNull Clock clock;
        private @MonotonicNonNull Delayer delayer;
        private @MonotonicNonNull Duration indexUpdateDelay;
        private boolean debugIndexOps;

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder directory(Path directory) {
            this.directory = Objects.requireNonNull(directory);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxSize(long maxSize) {
            Validate.requireArgument(maxSize > 0L, "Expected a positive max size");
            this.maxSize = maxSize;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder hasher(Hasher hasher) {
            this.hasher = Objects.requireNonNull(hasher);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder delayer(Delayer delayer) {
            this.delayer = Objects.requireNonNull(delayer);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder indexUpdateDelay(Duration duration) {
            this.indexUpdateDelay = Utils.requireNonNegativeDuration(duration);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder debugIndexOps(boolean on) {
            this.debugIndexOps = on;
            return this;
        }

        public DiskStore build() throws IOException {
            return new DiskStore(this, this.debugIndexOps || DebugUtils.isAssertionsEnabled());
        }

        long maxSize() {
            long maxSize = this.maxSize;
            Validate.requireState(maxSize != -1L, "Expected maxSize to bet set");
            return maxSize;
        }

        int appVersion() {
            int appVersion = this.appVersion;
            Validate.requireState(appVersion != -1, "Expected appVersion to be set");
            return appVersion;
        }

        Path directory() {
            return this.ensureSet(this.directory, "directory");
        }

        Executor executor() {
            return this.ensureSet(this.executor, "executor");
        }

        Hasher hasher() {
            return Objects.requireNonNullElse(this.hasher, Hasher.TRUNCATED_SHA_256);
        }

        Clock clock() {
            return Objects.requireNonNullElse(this.clock, Utils.systemMillisUtc());
        }

        Duration indexUpdateDelay() {
            return Objects.requireNonNullElse(this.indexUpdateDelay, DEFAULT_INDEX_UPDATE_DELAY);
        }

        Delayer delayer() {
            return Objects.requireNonNullElse(this.delayer, Delayer.systemDelayer());
        }

        @CanIgnoreReturnValue
        private <T> T ensureSet(T property, String name) {
            Validate.requireState(property != null, "Expected %s to bet set", name);
            return property;
        }

        static {
            long millis = Long.getLong("com.namelessmc.plugin.lib.methanol.internal.cache.DiskStore.indexUpdateDelayMillis", 2000L);
            if (millis < 0L) {
                millis = 2000L;
            }
            DEFAULT_INDEX_UPDATE_DELAY = Duration.ofMillis(millis);
        }
    }

    private static final class DiskEditor
    implements Store.Editor {
        private final Entry entry;
        private final String key;
        private final FileChannel channel;
        private final DiskEntryWriter writer;
        private final AtomicBoolean closed = new AtomicBoolean();

        DiskEditor(Entry entry, String key, FileChannel channel) {
            this.entry = entry;
            this.key = key;
            this.channel = channel;
            this.writer = new DiskEntryWriter();
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Store.EntryWriter writer() {
            return this.writer;
        }

        @Override
        public void commit(ByteBuffer metadata) throws IOException {
            Objects.requireNonNull(metadata);
            Validate.requireState(this.closed.compareAndSet(false, true), "closed");
            this.internalCommit(metadata);
        }

        @Override
        public CompletableFuture<Void> commit(ByteBuffer metadata, Executor executor) {
            Objects.requireNonNull(metadata);
            Validate.requireState(this.closed.compareAndSet(false, true), "closed");
            return Unchecked.runAsync(() -> this.internalCommit(metadata), executor);
        }

        private void internalCommit(ByteBuffer metadata) throws IOException {
            long[] crc32cHolder = new long[1];
            long dataSize = this.writer.dataSizeIfWritten(crc32cHolder);
            this.entry.commit(this, this.key, metadata, this.channel, dataSize, crc32cHolder[0]);
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.entry.discardIfCurrentEdit(this);
            }
        }

        public void setClosed() {
            this.closed.set(true);
        }

        private final class DiskEntryWriter
        implements Store.EntryWriter {
            private final Lock lock = new ReentrantLock();
            private final CRC32C crc32C = new CRC32C();
            private long position;
            private boolean isWritten;

            DiskEntryWriter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int write(ByteBuffer src) throws IOException {
                Objects.requireNonNull(src);
                Validate.requireState(!DiskEditor.this.closed.get(), "closed");
                this.lock.lock();
                try {
                    int srcPosition = src.position();
                    int written = FileIO.write(DiskEditor.this.channel, src);
                    this.crc32C.update(src.position(srcPosition));
                    this.position += (long)written;
                    this.isWritten = true;
                    int n = written;
                    return n;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public CompletableFuture<Integer> write(ByteBuffer src, Executor executor) {
                Objects.requireNonNull(src);
                return Unchecked.supplyAsync(() -> this.write(src), executor);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long write(List<ByteBuffer> srcs) throws IOException {
                Objects.requireNonNull(srcs);
                Validate.requireState(!DiskEditor.this.closed.get(), "closed");
                this.lock.lock();
                try {
                    ByteBuffer[] srcsArray = (ByteBuffer[])srcs.toArray(ByteBuffer[]::new);
                    int[] srcPositions = new int[srcsArray.length];
                    for (int i = 0; i < srcsArray.length; ++i) {
                        srcPositions[i] = srcsArray[i].position();
                    }
                    long written = FileIO.write(DiskEditor.this.channel, srcsArray);
                    for (int i = 0; i < srcsArray.length; ++i) {
                        this.crc32C.update(srcsArray[i].position(srcPositions[i]));
                    }
                    this.position += written;
                    this.isWritten = true;
                    long l = written;
                    return l;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public CompletableFuture<Long> write(List<ByteBuffer> srcs, Executor executor) {
                Objects.requireNonNull(srcs);
                return Unchecked.supplyAsync(() -> this.write(srcs), executor);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            long dataSizeIfWritten(long[] crc32cHolder) {
                this.lock.lock();
                try {
                    if (this.isWritten) {
                        crc32cHolder[0] = this.crc32C.getValue();
                        long l = this.position;
                        return l;
                    }
                    long l = -1L;
                    return l;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    private final class DiskViewer
    implements Store.Viewer {
        private final Entry entry;
        private final int entryVersion;
        private final EntryDescriptor descriptor;
        private final FileChannel channel;
        private final AtomicBoolean closed = new AtomicBoolean();
        private final AtomicBoolean createdFirstReader = new AtomicBoolean();

        DiskViewer(Entry entry, int entryVersion, EntryDescriptor descriptor, FileChannel channel) {
            this.entry = entry;
            this.entryVersion = entryVersion;
            this.descriptor = descriptor;
            this.channel = channel;
        }

        @Override
        public String key() {
            return this.descriptor.key;
        }

        @Override
        public ByteBuffer metadata() {
            return this.descriptor.metadata.duplicate();
        }

        @Override
        public Store.EntryReader newReader() {
            return this.createdFirstReader.compareAndSet(false, true) ? new ScatteringDiskEntryReader() : new DiskEntryReader();
        }

        @Override
        public Optional<Store.Editor> edit() throws IOException {
            return Optional.ofNullable(this.entry.edit(this.key(), this.entryVersion));
        }

        @Override
        public CompletableFuture<Optional<Store.Editor>> edit(Executor executor) {
            return Unchecked.supplyAsync(this::edit, executor);
        }

        @Override
        public long dataSize() {
            return this.descriptor.dataSize;
        }

        @Override
        public long entrySize() {
            return (long)this.descriptor.metadata.remaining() + this.descriptor.dataSize;
        }

        @Override
        public boolean removeEntry() throws IOException {
            return DiskStore.this.removeEntry(this.entry, this.entryVersion);
        }

        @Override
        public void close() {
            DiskStore.closeQuietly(this.channel);
            if (this.closed.compareAndSet(false, true)) {
                this.entry.decrementViewerCount();
            }
        }

        private final class ScatteringDiskEntryReader
        extends DiskEntryReader {
            ScatteringDiskEntryReader() {
            }

            @Override
            int readBytes(ByteBuffer dst) throws IOException {
                return FileIO.read(DiskViewer.this.channel, dst);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long read(List<ByteBuffer> dsts) throws IOException {
                Objects.requireNonNull(dsts);
                this.lock.lock();
                try {
                    long available = DiskViewer.this.descriptor.dataSize - this.position;
                    if (available <= 0L) {
                        long l = -1L;
                        return l;
                    }
                    ArrayList<ByteBuffer> boundedDsts = new ArrayList<ByteBuffer>(dsts.size());
                    long maxReadableSoFar = 0L;
                    for (ByteBuffer dst : dsts) {
                        int dstMaxReadable = (int)Math.min((long)dst.remaining(), available - maxReadableSoFar);
                        boundedDsts.add(dst.duplicate().limit(dst.position() + dstMaxReadable));
                        if ((maxReadableSoFar = Math.addExact(maxReadableSoFar, (long)dstMaxReadable)) < available) continue;
                        break;
                    }
                    long read = FileIO.read(DiskViewer.this.channel, (ByteBuffer[])boundedDsts.toArray(ByteBuffer[]::new));
                    this.position += read;
                    for (ByteBuffer boundedDst : boundedDsts) {
                        this.crc32C.update(boundedDst.rewind());
                    }
                    this.checkCrc32cIfEndOfStream();
                    for (int i = 0; i < boundedDsts.size(); ++i) {
                        dsts.get(i).position(((ByteBuffer)boundedDsts.get(i)).position());
                    }
                    long l = read;
                    return l;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private class DiskEntryReader
        implements Store.EntryReader {
            final Lock lock = new ReentrantLock();
            final CRC32C crc32C = new CRC32C();
            long position;

            DiskEntryReader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(ByteBuffer dst) throws IOException {
                Objects.requireNonNull(dst);
                this.lock.lock();
                try {
                    long available = DiskViewer.this.descriptor.dataSize - this.position;
                    if (available <= 0L) {
                        int n = -1;
                        return n;
                    }
                    int maxReadable = (int)Math.min(available, (long)dst.remaining());
                    ByteBuffer boundedDst = dst.duplicate().limit(dst.position() + maxReadable);
                    int read = this.readBytes(boundedDst);
                    this.position += (long)read;
                    this.crc32C.update(boundedDst.rewind());
                    this.checkCrc32cIfEndOfStream();
                    dst.position(dst.position() + read);
                    int n = read;
                    return n;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public CompletableFuture<Integer> read(ByteBuffer dst, Executor executor) {
                return Unchecked.supplyAsync(() -> this.read(dst), executor);
            }

            @Override
            public long read(List<ByteBuffer> dsts) throws IOException {
                long totalRead = 0L;
                block0: for (ByteBuffer dst : dsts) {
                    while (dst.hasRemaining()) {
                        int read = this.read(dst);
                        if (read >= 0) {
                            totalRead += (long)read;
                            continue;
                        }
                        if (totalRead > 0L) break block0;
                        return -1L;
                    }
                }
                return totalRead;
            }

            @Override
            public CompletableFuture<Long> read(List<ByteBuffer> dsts, Executor executor) {
                return Unchecked.supplyAsync(() -> this.read(dsts), executor);
            }

            int readBytes(ByteBuffer dst) throws IOException {
                return FileIO.read(DiskViewer.this.channel, dst, this.position);
            }

            void checkCrc32cIfEndOfStream() throws StoreCorruptionException {
                if (this.position == DiskViewer.this.descriptor.dataSize) {
                    DiskStore.checkValue(this.crc32C.getValue(), DiskViewer.this.descriptor.dataCrc32c, "Unexpected data checksum");
                }
            }
        }
    }

    private final class Entry {
        static final int ANY_VERSION = -1;
        final Hash hash;
        private final ReentrantLock lock = new ReentrantLock();
        @GuardedBy(value="lock")
        private long lastUsed;
        @GuardedBy(value="lock")
        private long size;
        @GuardedBy(value="lock")
        private int viewerCount;
        @GuardedBy(value="lock")
        private @Nullable DiskEditor currentEditor;
        @GuardedBy(value="lock")
        private int version;
        @GuardedBy(value="lock")
        private boolean readable;
        @GuardedBy(value="lock")
        private boolean writable;
        private @MonotonicNonNull Path lazyEntryFile;
        private @MonotonicNonNull Path lazyTempEntryFile;
        @GuardedBy(value="lock")
        private @MonotonicNonNull EntryDescriptor cachedDescriptor;

        Entry(Hash hash) {
            this.hash = hash;
            this.lastUsed = -1L;
            this.readable = false;
            this.writable = true;
        }

        Entry(IndexEntry indexEntry) {
            this.hash = indexEntry.hash;
            this.lastUsed = indexEntry.lastUsed;
            this.size = indexEntry.size;
            this.readable = true;
            this.writable = true;
        }

        @Nullable IndexEntry toIndexEntry() {
            this.lock.lock();
            try {
                IndexEntry indexEntry = this.readable ? new IndexEntry(this.hash, this.lastUsed, this.size) : null;
                return indexEntry;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Nullable Store.Viewer view(@Nullable String expectedKey) throws IOException {
            Store.Viewer viewer = this.openViewerForKey(expectedKey);
            if (viewer != null) {
                DiskStore.this.indexWriteScheduler.trySchedule();
            }
            return viewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private @Nullable Store.Viewer openViewerForKey(@Nullable String expectedKey) throws IOException {
            this.lock.lock();
            if (!this.readable) {
                Store.Viewer viewer = null;
                this.lock.unlock();
                return viewer;
            }
            {
                Store.Viewer viewer;
                EntryDescriptor descriptor;
                FileChannel channel;
                FileChannelCloseable closeable;
                block15: {
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                    closeable = new FileChannelCloseable(FileChannel.open(this.entryFile(), StandardOpenOption.READ));
                    channel = closeable.channel();
                    descriptor = this.readDescriptorForKey(channel, expectedKey);
                    if (descriptor != null) break block15;
                    Store.Viewer viewer2 = null;
                    closeable.close();
                    this.lock.unlock();
                    return viewer2;
                }
                try {
                    Store.Viewer viewer3 = this.createViewer(channel, this.version, descriptor);
                    closeable.keepOpen();
                    viewer = viewer3;
                }
                catch (Throwable throwable) {}
                closeable.close();
                this.lock.unlock();
                return viewer;
                {
                    try {
                        try {
                            closeable.close();
                            throw throwable;
                        }
                        catch (Throwable throwable) {
                            throwable.addSuppressed(throwable);
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException missingEntryFile) {
                        logger.log(System.Logger.Level.WARNING, "Dropping entry with missing file", (Throwable)missingEntryFile);
                        this.lock.unlock();
                    }
                }
            }
            try {
                DiskStore.this.removeEntry(this);
                return null;
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "Exception while deleting already non-existent entry");
            }
            return null;
        }

        @GuardedBy(value="lock")
        private @Nullable EntryDescriptor readDescriptorForKey(FileChannel channel, @Nullable String expectedKey) throws IOException {
            EntryDescriptor descriptor = this.cachedDescriptor;
            if (descriptor == null) {
                descriptor = this.readDescriptor(channel);
            }
            if (DiskStore.keyMismatches(descriptor.key, expectedKey)) {
                return null;
            }
            this.cachedDescriptor = descriptor;
            return descriptor;
        }

        @GuardedBy(value="lock")
        private EntryDescriptor readDescriptor(FileChannel channel) throws IOException {
            long fileSize = channel.size();
            ByteBuffer trailer = FileIO.read(channel, 40, fileSize - 40L);
            long magic = trailer.getLong();
            int storeVersion = trailer.getInt();
            int appVersion = trailer.getInt();
            int keySize = DiskStore.getNonNegativeInt(trailer);
            int metadataSize = DiskStore.getNonNegativeInt(trailer);
            long dataSize = DiskStore.getNonNegativeLong(trailer);
            long dataCrc32c = (long)trailer.getInt() & 0xFFFFFFFFL;
            long epilogueCrc32c = (long)trailer.getInt() & 0xFFFFFFFFL;
            DiskStore.checkValue(8891064658374387837L, magic, "Not in entry file format");
            DiskStore.checkValue(2L, storeVersion, "Unexpected store version");
            DiskStore.checkValue(DiskStore.this.appVersion, appVersion, "Unexpected app version");
            ByteBuffer keyAndMetadata = FileIO.read(channel, keySize + metadataSize, dataSize);
            String key = StandardCharsets.UTF_8.decode(keyAndMetadata.limit(keySize)).toString();
            ByteBuffer metadata = ByteBuffer.allocate(keyAndMetadata.limit(keySize + metadataSize).remaining()).put(keyAndMetadata).flip().asReadOnlyBuffer();
            CRC32C crc32c = new CRC32C();
            crc32c.update(keyAndMetadata.rewind());
            crc32c.update(trailer.rewind().limit(trailer.limit() - 4));
            DiskStore.checkValue(crc32c.getValue(), epilogueCrc32c, "Unexpected epilogue checksum");
            return new EntryDescriptor(key, metadata, dataSize, dataCrc32c);
        }

        @GuardedBy(value="lock")
        private Store.Viewer createViewer(FileChannel channel, int version, EntryDescriptor descriptor) {
            DiskViewer viewer = new DiskViewer(this, version, descriptor, channel);
            ++this.viewerCount;
            this.lastUsed = DiskStore.this.lruClock.getAndIncrement();
            return viewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable Store.Editor edit(String key, int targetVersion) throws IOException {
            this.lock.lock();
            try {
                DiskEditor editor;
                if (!this.writable || this.currentEditor != null || targetVersion != -1 && targetVersion != this.version) {
                    Store.Editor editor2 = null;
                    return editor2;
                }
                this.currentEditor = editor = new DiskEditor(this, key, FileChannel.open(this.tempEntryFile(), StandardOpenOption.WRITE, StandardOpenOption.CREATE));
                DiskEditor diskEditor = editor;
                return diskEditor;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit(DiskEditor editor, String key, ByteBuffer metadata, FileChannel editorChannel, long dataSize, long dataCrc32c) throws IOException {
            long sizeDifference;
            long newSize;
            this.lock.lock();
            try {
                EntryDescriptor committedDescriptor;
                Validate.requireState(this.currentEditor == editor, "Edit discarded");
                this.currentEditor = null;
                Validate.requireState(this.writable, "Committing a non-discarded edit to a non-writable entry");
                boolean editInPlace = dataSize < 0L && this.readable;
                try (FileChannel fileChannel = editorChannel;
                     AbstractInterruptibleChannel existingEntryChannel = editInPlace ? FileChannel.open(this.entryFile(), StandardOpenOption.READ, StandardOpenOption.WRITE) : null;){
                    AbstractInterruptibleChannel targetChannel = editorChannel;
                    EntryDescriptor existingEntryDescriptor = null;
                    if (existingEntryChannel != null && (existingEntryDescriptor = this.readDescriptorForKey((FileChannel)existingEntryChannel, key)) != null) {
                        targetChannel = existingEntryChannel;
                        committedDescriptor = new EntryDescriptor(key, metadata, existingEntryDescriptor.dataSize, existingEntryDescriptor.dataCrc32c);
                        DiskStore.closeQuietly(editorChannel);
                        DiskStore.replace(this.entryFile(), this.tempEntryFile());
                        this.readable = false;
                        DiskStore.this.size.addAndGet(-this.size);
                        this.size = 0L;
                    } else {
                        committedDescriptor = new EntryDescriptor(key, metadata, Math.max(dataSize, 0L), dataCrc32c);
                    }
                    int written = FileIO.write((FileChannel)targetChannel, committedDescriptor.encodeToEpilogue(DiskStore.this.appVersion), committedDescriptor.dataSize);
                    if (existingEntryDescriptor != null) {
                        ((FileChannel)targetChannel).truncate(committedDescriptor.dataSize + (long)written);
                    }
                    ((FileChannel)targetChannel).force(false);
                }
                catch (IOException e) {
                    this.discardCurrentEdit(editor);
                    throw e;
                }
                if (this.viewerCount > 0) {
                    DiskStore.isolatedDeleteIfExists(this.entryFile());
                }
                DiskStore.replace(this.tempEntryFile(), this.entryFile());
                ++this.version;
                newSize = (long)committedDescriptor.metadata.remaining() + committedDescriptor.dataSize;
                sizeDifference = newSize - this.size;
                this.size = newSize;
                this.readable = true;
                this.lastUsed = DiskStore.this.lruClock.getAndIncrement();
                this.cachedDescriptor = committedDescriptor;
            }
            finally {
                this.lock.unlock();
            }
            long newStoreSize = DiskStore.this.size.addAndGet(sizeDifference);
            if (newSize > DiskStore.this.maxSize) {
                DiskStore.this.removeEntry(this);
                return;
            }
            if (newStoreSize > DiskStore.this.maxSize) {
                DiskStore.this.evictionScheduler.schedule();
            }
            DiskStore.this.indexWriteScheduler.trySchedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long evict(int targetVersion) throws IOException {
            this.lock.lock();
            try {
                if (!this.writable || targetVersion != -1 && targetVersion != this.version) {
                    long l = -1L;
                    return l;
                }
                if (this.viewerCount > 0) {
                    DiskStore.isolatedDeleteIfExists(this.entryFile());
                } else {
                    Files.deleteIfExists(this.entryFile());
                }
                this.discardCurrentEdit();
                this.readable = false;
                this.writable = false;
                long l = this.size;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        void freeze() {
            this.lock.lock();
            try {
                this.writable = false;
                this.discardCurrentEdit();
            }
            finally {
                this.lock.unlock();
            }
        }

        @GuardedBy(value="lock")
        private void discardCurrentEdit() {
            DiskEditor editor = this.currentEditor;
            if (editor != null) {
                this.currentEditor = null;
                this.discardCurrentEdit(editor);
            }
        }

        @GuardedBy(value="lock")
        private void discardCurrentEdit(DiskEditor editor) {
            if (!this.readable) {
                DiskStore.this.entries.remove(this.hash, this);
            }
            editor.setClosed();
            DiskStore.closeQuietly(editor.channel);
            DiskStore.deleteIfExistsQuietly(this.tempEntryFile());
        }

        void discardIfCurrentEdit(DiskEditor editor) {
            this.lock.lock();
            try {
                if (editor == this.currentEditor) {
                    this.currentEditor = null;
                    this.discardCurrentEdit(editor);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void decrementViewerCount() {
            this.lock.lock();
            try {
                --this.viewerCount;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable String keyIfKnown(int[] versionHolder) {
            this.lock.lock();
            try {
                EntryDescriptor descriptor = this.cachedDescriptor;
                if (descriptor != null) {
                    versionHolder[0] = this.version;
                    String string = descriptor.key;
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Nullable String currentEditorKey() {
            this.lock.lock();
            try {
                DiskEditor editor = this.currentEditor;
                String string = editor != null ? editor.key() : null;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }

        Path entryFile() {
            Path entryFile = this.lazyEntryFile;
            if (entryFile == null) {
                this.lazyEntryFile = entryFile = DiskStore.this.directory.resolve(this.hash.toHexString() + DiskStore.ENTRY_FILE_SUFFIX);
            }
            return entryFile;
        }

        Path tempEntryFile() {
            Path entryFile = this.lazyTempEntryFile;
            if (entryFile == null) {
                this.lazyTempEntryFile = entryFile = DiskStore.this.directory.resolve(this.hash.toHexString() + DiskStore.TEMP_ENTRY_FILE_SUFFIX);
            }
            return entryFile;
        }
    }

    private static final class EntryDescriptor {
        final String key;
        final ByteBuffer metadata;
        final long dataSize;
        final long dataCrc32c;

        EntryDescriptor(String key, ByteBuffer metadata, long dataSize, long dataCrc32c) {
            this.key = key;
            this.metadata = metadata.asReadOnlyBuffer();
            this.dataSize = dataSize;
            this.dataCrc32c = dataCrc32c;
        }

        ByteBuffer encodeToEpilogue(int appVersion) {
            ByteBuffer encodedKey = StandardCharsets.UTF_8.encode(this.key);
            int keySize = encodedKey.remaining();
            int metadataSize = this.metadata.remaining();
            ByteBuffer epilogue = ByteBuffer.allocate(keySize + metadataSize + 40).put(encodedKey).put(this.metadata.duplicate()).putLong(8891064658374387837L).putInt(2).putInt(appVersion).putInt(keySize).putInt(metadataSize).putLong(this.dataSize).putInt((int)this.dataCrc32c);
            CRC32C crc32c = new CRC32C();
            crc32c.update(epilogue.flip());
            return epilogue.limit(epilogue.capacity()).putInt((int)crc32c.getValue()).flip();
        }
    }

    private static final class IndexEntry {
        static final Comparator<IndexEntry> LRU_ORDER = Comparator.comparingLong(entry -> entry.lastUsed);
        final Hash hash;
        final long lastUsed;
        final long size;

        IndexEntry(Hash hash, long lastUsed, long size) {
            this.hash = hash;
            this.lastUsed = lastUsed;
            this.size = size;
        }

        IndexEntry(ByteBuffer buffer) throws StoreCorruptionException {
            this.hash = new Hash(buffer);
            this.lastUsed = buffer.getLong();
            this.size = DiskStore.getPositiveLong(buffer);
        }

        void writeTo(ByteBuffer buffer) {
            this.hash.writeTo(buffer);
            buffer.putLong(this.lastUsed);
            buffer.putLong(this.size);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IndexEntry)) {
                return false;
            }
            return this.hash.equals(((IndexEntry)obj).hash);
        }
    }

    public static final class Hash {
        static final int BYTES = 10;
        static final int HEX_STRING_LENGTH = 20;
        private final long upper64Bits;
        private final short lower16Bits;
        private @MonotonicNonNull String lazyHex;

        public Hash(ByteBuffer buffer) {
            this(buffer.getLong(), buffer.getShort());
        }

        Hash(long upper64Bits, short lower16Bits) {
            this.upper64Bits = upper64Bits;
            this.lower16Bits = lower16Bits;
        }

        void writeTo(ByteBuffer buffer) {
            buffer.putLong(this.upper64Bits);
            buffer.putShort(this.lower16Bits);
        }

        String toHexString() {
            Object hex = this.lazyHex;
            if (hex == null) {
                this.lazyHex = hex = Hash.toPaddedHexString(this.upper64Bits, 8) + Hash.toPaddedHexString(this.lower16Bits & 0xFFFF, 2);
            }
            return hex;
        }

        public int hashCode() {
            return Long.hashCode(this.upper64Bits) ^ Short.hashCode(this.lower16Bits);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Hash)) {
                return false;
            }
            Hash other = (Hash)obj;
            return this.upper64Bits == other.upper64Bits && this.lower16Bits == other.lower16Bits;
        }

        public String toString() {
            return this.toHexString();
        }

        static @Nullable Hash tryParse(String hex) {
            if (hex.length() != 20) {
                return null;
            }
            try {
                return new Hash(Long.parseUnsignedLong(hex, 0, 16, 16), (short)Integer.parseInt(hex, 16, hex.length(), 16));
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }

        private static String toPaddedHexString(long value, int size) {
            Object hex = Long.toHexString(value);
            int padding = (size << 1) - ((String)hex).length();
            assert (padding >= 0);
            if (padding > 0) {
                hex = "0".repeat(padding) + (String)hex;
            }
            return hex;
        }
    }

    private static final class DirectoryLock
    implements AutoCloseable {
        private final Path lockFile;
        private final FileChannel channel;

        private DirectoryLock(Path lockFile, FileChannel channel) {
            this.lockFile = lockFile;
            this.channel = channel;
        }

        @Override
        public void close() {
            DiskStore.deleteIfExistsQuietly(this.lockFile);
            DiskStore.closeQuietly(this.channel);
        }

        static DirectoryLock acquire(Path directory) throws IOException {
            DirectoryLock directoryLock;
            Path lockFile = directory.resolve(DiskStore.LOCK_FILENAME);
            FileChannelCloseable closeable = new FileChannelCloseable(FileChannel.open(lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
            try {
                FileChannel channel = closeable.channel();
                FileLock fileLock = channel.tryLock();
                if (fileLock == null) {
                    throw new IOException("Store directory <" + directory + "> already in use");
                }
                DirectoryLock lock = new DirectoryLock(lockFile, channel);
                closeable.keepOpen();
                directoryLock = lock;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    DiskStore.deleteIfExistsQuietly(lockFile);
                    throw e;
                }
            }
            closeable.close();
            return directoryLock;
        }
    }

    private static final class EvictionScheduler {
        private static final int RUN = 1;
        private static final int KEEP_ALIVE = 2;
        private static final int SHUTDOWN = 4;
        private static final VarHandle SYNC;
        private final DiskStore store;
        private final Executor executor;
        private volatile int sync;

        EvictionScheduler(DiskStore store, Executor executor) {
            this.store = store;
            this.executor = executor;
        }

        void schedule() {
            int s;
            while (((s = this.sync) & 4) == 0) {
                int bit = (s & 1) == 0 ? 1 : 2;
                if (!SYNC.compareAndSet(this, s, s | bit)) continue;
                if (bit != 1) break;
                this.executor.execute(this::runEviction);
                break;
            }
        }

        private void runEviction() {
            int s;
            while (((s = this.sync) & 4) == 0) {
                int bit;
                try {
                    if (!this.store.evictExcessiveEntriesIfOpen()) {
                        break;
                    }
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "Exception thrown when evicting entries in background", (Throwable)e);
                }
                if (!SYNC.compareAndSet(this, s, s & ~(bit = (s & 2) != 0 ? 2 : 1)) || bit != 1) continue;
                break;
            }
        }

        void shutdown() {
            SYNC.getAndBitwiseOr(this, 4);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                SYNC = lookup.findVarHandle(EvictionScheduler.class, "sync", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class IndexWriteScheduler {
        private static final VarHandle SCHEDULED_WRITE_TASK;
        private static final WriteTask TOMBSTONE;
        private final IndexOperator indexOperator;
        private final Executor indexExecutor;
        private final Supplier<Set<IndexEntry>> indexEntriesSnapshotSupplier;
        private final Duration period;
        private final Delayer delayer;
        private final Clock clock;
        private @MonotonicNonNull WriteTask scheduledWriteTask;
        private final Phaser runningTaskAwaiter = new Phaser(1);

        IndexWriteScheduler(IndexOperator indexOperator, Executor indexExecutor, Supplier<Set<IndexEntry>> indexEntriesSnapshotSupplier, Duration period, Delayer delayer, Clock clock) {
            this.indexOperator = indexOperator;
            this.indexExecutor = indexExecutor;
            this.indexEntriesSnapshotSupplier = indexEntriesSnapshotSupplier;
            this.period = period;
            this.delayer = delayer;
            this.clock = clock;
        }

        Clock clock() {
            return this.clock;
        }

        Delayer delayer() {
            return this.delayer;
        }

        void trySchedule() {
            Duration delay;
            RunnableWriteTask newTask;
            WriteTask currentTask;
            Instant now = this.clock.instant();
            do {
                Instant nextFireTime;
                Instant instant = nextFireTime = (currentTask = this.scheduledWriteTask) != null ? currentTask.fireTime() : null;
                if (nextFireTime == null) {
                    delay = Duration.ZERO;
                    continue;
                }
                if (currentTask == TOMBSTONE || nextFireTime.isAfter(now)) {
                    return;
                }
                Duration idleness = Duration.between(nextFireTime, now);
                delay = Compare.max(this.period.minus(idleness), Duration.ZERO);
            } while (!SCHEDULED_WRITE_TASK.compareAndSet(this, currentTask, newTask = new RunnableWriteTask(now.plus(delay))));
            this.delayer.delay(newTask::runUnchecked, delay, this.indexExecutor);
        }

        void forceSchedule() throws IOException {
            Utils.getIo(this.forceScheduleAsync());
        }

        private CompletableFuture<Void> forceScheduleAsync() {
            RunnableWriteTask newTask;
            WriteTask currentTask;
            Instant now = this.clock.instant();
            do {
                Validate.requireState((currentTask = this.scheduledWriteTask) != TOMBSTONE, "Shutdown");
            } while (!SCHEDULED_WRITE_TASK.compareAndSet(this, currentTask, newTask = new RunnableWriteTask(now)));
            if (currentTask != null) {
                currentTask.cancel();
            }
            return Unchecked.runAsync(newTask, this.indexExecutor);
        }

        void shutdown() throws InterruptedIOException {
            this.scheduledWriteTask = TOMBSTONE;
            try {
                this.runningTaskAwaiter.awaitAdvanceInterruptibly(this.runningTaskAwaiter.arriveAndDeregister());
                assert (this.runningTaskAwaiter.isTerminated());
            }
            catch (InterruptedException e) {
                throw Utils.toInterruptedIOException(e);
            }
        }

        static {
            try {
                SCHEDULED_WRITE_TASK = MethodHandles.lookup().findVarHandle(IndexWriteScheduler.class, "scheduledWriteTask", WriteTask.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
            TOMBSTONE = new WriteTask(){

                @Override
                Instant fireTime() {
                    return Instant.MIN;
                }

                @Override
                void cancel() {
                }
            };
        }

        private final class RunnableWriteTask
        extends WriteTask
        implements ThrowingRunnable {
            private final Instant fireTime;
            private volatile boolean cancelled;

            RunnableWriteTask(Instant fireTime) {
                this.fireTime = fireTime;
            }

            @Override
            Instant fireTime() {
                return this.fireTime;
            }

            @Override
            void cancel() {
                this.cancelled = true;
            }

            @Override
            public void run() throws IOException {
                if (!this.cancelled && IndexWriteScheduler.this.runningTaskAwaiter.register() >= 0) {
                    try {
                        IndexWriteScheduler.this.indexOperator.writeIndex(IndexWriteScheduler.this.indexEntriesSnapshotSupplier.get());
                    }
                    finally {
                        IndexWriteScheduler.this.runningTaskAwaiter.arriveAndDeregister();
                    }
                }
            }

            void runUnchecked() {
                try {
                    this.run();
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "Exception thrown when writing the index", (Throwable)e);
                }
            }
        }

        private static abstract class WriteTask {
            private WriteTask() {
            }

            abstract Instant fireTime();

            abstract void cancel();
        }
    }

    private static final class DebugIndexOperator
    extends IndexOperator {
        private static final VarHandle RUNNING_OPERATION;
        private final AtomicInteger writeCount = new AtomicInteger(0);
        private @Nullable String runningOperation;

        DebugIndexOperator(Path directory, int appVersion) {
            super(directory, appVersion);
        }

        @Override
        Set<IndexEntry> readIndex() throws IOException {
            this.enter("readIndex");
            try {
                Set<IndexEntry> set = super.readIndex();
                return set;
            }
            finally {
                this.exit();
            }
        }

        @Override
        void writeIndex(Set<IndexEntry> entries) throws IOException {
            this.enter("writeIndex");
            try {
                super.writeIndex(entries);
                this.writeCount.incrementAndGet();
            }
            finally {
                this.exit();
            }
        }

        private void enter(String operation) {
            Object currentOperation;
            if (!isIndexExecutor.get().booleanValue()) {
                logger.log(System.Logger.Level.ERROR, () -> "IndexOperator::" + operation + " isn't called by the index executor");
            }
            if ((currentOperation = RUNNING_OPERATION.compareAndExchange(this, null, operation)) != null) {
                logger.log(System.Logger.Level.ERROR, () -> "IndexOperator::" + operation + " is called while IndexOperator::" + currentOperation + " is running");
            }
        }

        private void exit() {
            this.runningOperation = null;
        }

        int writeCount() {
            return this.writeCount.get();
        }

        static {
            try {
                RUNNING_OPERATION = MethodHandles.lookup().findVarHandle(DebugIndexOperator.class, "runningOperation", String.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class IndexOperator {
        private final Path directory;
        private final Path indexFile;
        private final Path tempIndexFile;
        private final int appVersion;

        IndexOperator(Path directory, int appVersion) {
            this.directory = directory;
            this.indexFile = directory.resolve(DiskStore.INDEX_FILENAME);
            this.tempIndexFile = directory.resolve(DiskStore.TEMP_INDEX_FILENAME);
            this.appVersion = appVersion;
        }

        Set<IndexEntry> recoverEntries() throws IOException {
            Map<Hash, EntryFiles> diskEntries = this.scanDirectoryForEntries();
            Set<IndexEntry> indexEntries = this.readOrCreateIndex();
            HashSet<IndexEntry> retainedIndexEntries = new HashSet<IndexEntry>(indexEntries.size());
            HashSet<Path> filesToDelete = new HashSet<Path>();
            for (IndexEntry indexEntry : indexEntries) {
                EntryFiles entryFiles = diskEntries.get(indexEntry.hash);
                if (entryFiles == null) continue;
                if (entryFiles.cleanFile != null) {
                    retainedIndexEntries.add(indexEntry);
                }
                if (entryFiles.dirtyFile == null) continue;
                filesToDelete.add(entryFiles.dirtyFile);
            }
            if (retainedIndexEntries.size() != diskEntries.size()) {
                HashMap<Hash, EntryFiles> untrackedEntries = new HashMap<Hash, EntryFiles>(diskEntries);
                retainedIndexEntries.forEach(entries -> untrackedEntries.remove(entries.hash));
                for (EntryFiles entryFiles : untrackedEntries.values()) {
                    if (entryFiles.cleanFile != null) {
                        filesToDelete.add(entryFiles.cleanFile);
                    }
                    if (entryFiles.dirtyFile == null) continue;
                    filesToDelete.add(entryFiles.dirtyFile);
                }
            }
            for (Path path : filesToDelete) {
                DiskStore.safeDeleteIfExists(path);
            }
            return Collections.unmodifiableSet(retainedIndexEntries);
        }

        private Set<IndexEntry> readOrCreateIndex() throws IOException {
            try {
                return this.readIndex();
            }
            catch (NoSuchFileException e) {
                return Set.of();
            }
            catch (StoreCorruptionException | EOFException e) {
                logger.log(System.Logger.Level.WARNING, "Dropping store content due to an unreadable index", (Throwable)e);
                DiskStore.deleteStoreContent(this.directory);
                return Set.of();
            }
        }

        Set<IndexEntry> readIndex() throws IOException {
            try (FileChannel channel = FileChannel.open(this.indexFile, StandardOpenOption.READ);){
                ByteBuffer header = FileIO.read(channel, 24);
                DiskStore.checkValue(7882834714441969516L, header.getLong(), "Not in index format");
                DiskStore.checkValue(2L, header.getInt(), "Unexpected store version");
                DiskStore.checkValue(this.appVersion, header.getInt(), "Unexpected app version");
                long entryCount = header.getLong();
                DiskStore.checkValue(entryCount >= 0L && entryCount <= 1000000L, "Invalid entry count", entryCount);
                if (entryCount == 0L) {
                    Set<IndexEntry> set = Set.of();
                    return set;
                }
                int intEntryCount = (int)entryCount;
                int entryTableSize = intEntryCount * 26;
                ByteBuffer entryTable = FileIO.read(channel, entryTableSize);
                HashSet<IndexEntry> entries = new HashSet<IndexEntry>(intEntryCount);
                for (int i = 0; i < intEntryCount; ++i) {
                    entries.add(new IndexEntry(entryTable));
                }
                Set<IndexEntry> set = Collections.unmodifiableSet(entries);
                return set;
            }
        }

        void writeIndex(Set<IndexEntry> entries) throws IOException {
            Validate.requireArgument(entries.size() <= 1000000, "Too many entries");
            try (FileChannel channel = FileChannel.open(this.tempIndexFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                ByteBuffer index = ByteBuffer.allocate(24 + 26 * entries.size()).putLong(7882834714441969516L).putInt(2).putInt(this.appVersion).putLong(entries.size());
                entries.forEach(entry -> entry.writeTo(index));
                FileIO.write(channel, index.flip());
                channel.force(false);
            }
            DiskStore.replace(this.tempIndexFile, this.indexFile);
        }

        private Map<Hash, EntryFiles> scanDirectoryForEntries() throws IOException {
            HashMap<Hash, EntryFiles> diskEntries = new HashMap<Hash, EntryFiles>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.directory);){
                for (Path file : stream) {
                    Hash hash;
                    Path filenameComponent = file.getFileName();
                    String filename = filenameComponent != null ? filenameComponent.toString() : "";
                    if (filename.equals(DiskStore.INDEX_FILENAME) || filename.equals(DiskStore.TEMP_INDEX_FILENAME) || filename.equals(DiskStore.LOCK_FILENAME)) continue;
                    if ((filename.endsWith(DiskStore.ENTRY_FILE_SUFFIX) || filename.endsWith(DiskStore.TEMP_ENTRY_FILE_SUFFIX)) && (hash = DiskStore.entryFileToHash(filename)) != null) {
                        EntryFiles files = diskEntries.computeIfAbsent(hash, __ -> new EntryFiles());
                        if (filename.endsWith(DiskStore.ENTRY_FILE_SUFFIX)) {
                            files.cleanFile = file;
                            continue;
                        }
                        files.dirtyFile = file;
                        continue;
                    }
                    if (filename.startsWith(DiskStore.ISOLATED_FILE_PREFIX)) {
                        DiskStore.safeDeleteIfExists(file);
                        continue;
                    }
                    logger.log(System.Logger.Level.WARNING, "Unrecognized file or directory found during initialization <" + file + ">. " + System.lineSeparator() + "It is generally not a good idea to let the store directory be used by other entities.");
                }
            }
            return diskEntries;
        }

        private static final class EntryFiles {
            @MonotonicNonNull Path cleanFile;
            @MonotonicNonNull Path dirtyFile;

            EntryFiles() {
            }
        }
    }

    @FunctionalInterface
    public static interface Hasher {
        public static final Hasher TRUNCATED_SHA_256 = Hasher::truncatedSha256Hash;

        public Hash hash(String var1);

        private static Hash truncatedSha256Hash(String key) {
            return new Hash(ByteBuffer.wrap(Sha256MessageDigestFactory.create().digest(key.getBytes(StandardCharsets.UTF_8))).limit(10));
        }
    }

    private static final class Sha256MessageDigestFactory {
        private static final @Nullable MessageDigest TEMPLATE = Sha256MessageDigestFactory.lookupTemplateIfCloneable();

        private Sha256MessageDigestFactory() {
        }

        static MessageDigest create() {
            if (TEMPLATE == null) {
                return Sha256MessageDigestFactory.lookup();
            }
            try {
                return (MessageDigest)TEMPLATE.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static @Nullable MessageDigest lookupTemplateIfCloneable() {
            try {
                return (MessageDigest)Sha256MessageDigestFactory.lookup().clone();
            }
            catch (CloneNotSupportedException ignored) {
                return null;
            }
        }

        private static MessageDigest lookup() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException("SHA-256 not available!", e);
            }
        }
    }

    private final class ConcurrentViewerIterator
    implements Iterator<Store.Viewer> {
        private final Iterator<Entry> entryIterator;
        private @Nullable Store.Viewer nextViewer;
        private @Nullable Store.Viewer currentViewer;

        ConcurrentViewerIterator() {
            this.entryIterator = DiskStore.this.entries.values().iterator();
        }

        @Override
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        public boolean hasNext() {
            return this.nextViewer != null || this.findNext();
        }

        @Override
        public Store.Viewer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Store.Viewer viewer = Validate.castNonNull(this.nextViewer);
            this.nextViewer = null;
            this.currentViewer = viewer;
            return viewer;
        }

        @Override
        public void remove() {
            Store.Viewer viewer = this.currentViewer;
            Validate.requireState(viewer != null, "next() must be called before remove()");
            this.currentViewer = null;
            try {
                Validate.castNonNull(viewer).removeEntry();
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "Exception thrown when removing entry", (Throwable)e);
            }
        }

        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        private boolean findNext() {
            while (this.entryIterator.hasNext()) {
                Entry entry = this.entryIterator.next();
                try {
                    Store.Viewer viewer = this.view(entry);
                    if (viewer == null) continue;
                    this.nextViewer = viewer;
                    return true;
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown when iterating over entries", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    return false;
                }
            }
            return false;
        }

        private @Nullable Store.Viewer view(Entry entry) throws IOException {
            DiskStore.this.closeLock.readLock().lock();
            try {
                Validate.requireState(!DiskStore.this.closed, "Closed");
                Store.Viewer viewer = entry.view(null);
                return viewer;
            }
            finally {
                DiskStore.this.closeLock.readLock().unlock();
            }
        }
    }

    private static final class FileChannelCloseable
    implements Closeable {
        private final FileChannel channel;
        private boolean close = true;

        FileChannelCloseable(FileChannel channel) {
            this.channel = channel;
        }

        FileChannel channel() {
            return this.channel;
        }

        void keepOpen() {
            this.close = false;
        }

        @Override
        public void close() throws IOException {
            if (this.close) {
                this.channel.close();
            }
        }
    }
}

