/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.methanol.internal.Validate;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import java.util.Optional;

public class HttpDates {
    private static final System.Logger logger = System.getLogger(HttpDates.class.getName());
    private static final DateTimeFormatter PREFERRED_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
    private static final List<DateTimeFormatter> FORMATTERS = List.of(PREFERRED_FORMATTER, DateTimeFormatter.ofPattern("EEEE, dd-MMM-uu HH:mm:ss 'GMT'"), DateTimeFormatter.ofPattern("EEE MMM ppd HH:mm:ss uuuu"), DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'UTC'"));

    private HttpDates() {
    }

    public static String formatHttpDate(LocalDateTime dateTime) {
        return PREFERRED_FORMATTER.format(dateTime);
    }

    public static boolean isHttpDate(String value) {
        return HttpDates.tryParseHttpDate0(value, false).isPresent();
    }

    static Optional<LocalDateTime> tryParseHttpDate(String value) {
        return HttpDates.tryParseHttpDate0(value, true);
    }

    private static Optional<LocalDateTime> tryParseHttpDate0(String value, boolean logFailure) {
        TemporalAccessor parsedTemporal = null;
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                parsedTemporal = formatter.parse(value);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        DateTimeException malformedHttpDate = null;
        if (parsedTemporal != null) {
            try {
                LocalDateTime dateTime = LocalDateTime.from(parsedTemporal);
                ZoneOffset offset = parsedTemporal.query(TemporalQueries.offset());
                return Optional.of(offset == null || offset.equals(ZoneOffset.UTC) ? dateTime : HttpDates.toUtcDateTime(dateTime.toInstant(offset)));
            }
            catch (DateTimeException e) {
                malformedHttpDate = e;
            }
        }
        if (logFailure) {
            logger.log(System.Logger.Level.WARNING, () -> "Malformed or unrecognized HTTP date: " + value, (Throwable)malformedHttpDate);
        }
        return Optional.empty();
    }

    public static Duration parseDeltaSeconds(String value) {
        long secondsLong = Long.parseLong(value);
        Validate.requireArgument(secondsLong >= 0L, "Delta seconds can't be negative");
        int secondsInt = (int)Math.min(secondsLong, Integer.MAX_VALUE);
        return Duration.ofSeconds(secondsInt);
    }

    static Optional<Duration> tryParseDeltaSeconds(String value) {
        try {
            return Optional.of(HttpDates.parseDeltaSeconds(value));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    static LocalDateTime toUtcDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }
}

