/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.methanol.internal.cache;

import com.namelessmc.plugin.lib.errorprone-annotations.CanIgnoreReturnValue;
import com.namelessmc.plugin.lib.methanol.internal.Utils;
import com.namelessmc.plugin.lib.methanol.internal.flow.FlowSupport;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface Store
extends Closeable,
Flushable {
    public long maxSize();

    default public Optional<Viewer> view(String key) throws IOException {
        return Utils.getIo(this.view(key, FlowSupport.SYNC_EXECUTOR));
    }

    public CompletableFuture<Optional<Viewer>> view(String var1, Executor var2);

    default public Optional<Editor> edit(String key) throws IOException {
        return Utils.getIo(this.edit(key, FlowSupport.SYNC_EXECUTOR));
    }

    public CompletableFuture<Optional<Editor>> edit(String var1, Executor var2);

    public Iterator<Viewer> iterator() throws IOException;

    @CanIgnoreReturnValue
    public boolean remove(String var1) throws IOException;

    @CanIgnoreReturnValue
    default public boolean removeAll(List<String> keys) throws IOException {
        boolean removedAny = false;
        for (String key : keys) {
            removedAny |= this.remove(key);
        }
        return removedAny;
    }

    public void clear() throws IOException;

    public long size() throws IOException;

    public void dispose() throws IOException;

    @Override
    public void close() throws IOException;

    @Override
    public void flush() throws IOException;

    public static interface EntryWriter {
        default public int write(ByteBuffer src) throws IOException {
            return (int)this.write(List.of(src));
        }

        default public CompletableFuture<Integer> write(ByteBuffer src, Executor executor) {
            return this.write(List.of(src), executor).thenApply(Long::intValue);
        }

        default public long write(List<ByteBuffer> srcs) throws IOException {
            return Utils.getIo(this.write(srcs, FlowSupport.SYNC_EXECUTOR));
        }

        public CompletableFuture<Long> write(List<ByteBuffer> var1, Executor var2);
    }

    public static interface EntryReader {
        default public int read(ByteBuffer dst) throws IOException {
            return (int)this.read(List.of(dst));
        }

        default public CompletableFuture<Integer> read(ByteBuffer dst, Executor executor) {
            return this.read(List.of(dst), executor).thenApply(Long::intValue);
        }

        default public long read(List<ByteBuffer> dsts) throws IOException {
            return Utils.getIo(this.read(dsts, FlowSupport.SYNC_EXECUTOR));
        }

        public CompletableFuture<Long> read(List<ByteBuffer> var1, Executor var2);
    }

    public static interface Editor
    extends Closeable {
        public String key();

        public EntryWriter writer();

        default public void commit(ByteBuffer metadata) throws IOException {
            Utils.getIo(this.commit(metadata, FlowSupport.SYNC_EXECUTOR));
        }

        public CompletableFuture<Void> commit(ByteBuffer var1, Executor var2);

        @Override
        public void close();
    }

    public static interface Viewer
    extends Closeable {
        public String key();

        public ByteBuffer metadata();

        public EntryReader newReader();

        public long dataSize();

        public long entrySize();

        default public Optional<Editor> edit() throws IOException {
            return Utils.getIo(this.edit(FlowSupport.SYNC_EXECUTOR));
        }

        public CompletableFuture<Optional<Editor>> edit(Executor var1);

        public boolean removeEntry() throws IOException;

        @Override
        public void close();
    }
}

