/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.lib.nameless-api;

import com.google.gson.GsonBuilder;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.Nullable;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.lib.methanol.Methanol;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.RequestHandler;
import com.namelessmc.plugin.lib.nameless-api.logger.ApiLogger;
import com.namelessmc.plugin.lib.nameless-api.logger.PrintStreamLogger;
import com.namelessmc.plugin.lib.nameless-api.logger.Slf4jLogger;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import javax.net.ssl.SSLParameters;

public class NamelessApiBuilder {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat SSLParameters SSL_PARAMETERS = new SSLParameters();
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL apiUrl;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String apiKey;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration timeout = Duration.ofSeconds(10L);
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int responseSizeLimit = 0x2000000;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String userAgent = "Nameless-Java-API";
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger debugLogger = null;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxySelector proxy = null;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Authenticator authenticator = null;
    private  @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat HttpClient.Version httpVersion = null;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean pettyJsonRequests = false;

    NamelessApiBuilder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL apiUrl, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String apiKey) {
        try {
            this.apiUrl = apiUrl.toString().endsWith("/") ? apiUrl : new URL(String.valueOf(apiUrl) + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.apiKey = apiKey;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder userAgent(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder stdErrDebugLogger() {
        this.debugLogger = PrintStreamLogger.DEFAULT_INSTANCE;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder slf4jDebugLogger() {
        this.debugLogger = Slf4jLogger.DEFAULT_INSTANCE;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder customDebugLogger(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiLogger debugLogger) {
        this.debugLogger = debugLogger;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder timeout(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration timeout) {
        this.timeout = Objects.requireNonNull(timeout);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder withProxy(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ProxySelector proxy) {
        this.proxy = proxy;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder authenticator(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder pettyJsonRequests() {
        this.pettyJsonRequests = true;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder responseSizeLimit(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat int responseSizeLimitBytes) {
        this.responseSizeLimit = responseSizeLimitBytes;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessApiBuilder httpVersion( @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat HttpClient.Version httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI build() {
        Methanol.Builder methanolBuilder = (Methanol.Builder)((Methanol.Builder)((Methanol.Builder)((Methanol.Builder)((Methanol.Builder)((Methanol.Builder)Methanol.newBuilder().defaultHeaders("Authorization", "Bearer " + this.apiKey, "X-API-Key", this.apiKey)).userAgent(this.userAgent)).autoAcceptEncoding(true)).readTimeout(this.timeout)).requestTimeout(this.timeout)).connectTimeout(this.timeout).headersTimeout(this.timeout);
        if (this.proxy != null) {
            methanolBuilder.proxy(this.proxy);
        }
        if (this.authenticator != null) {
            methanolBuilder.authenticator(this.authenticator);
        }
        if (this.httpVersion != null) {
            methanolBuilder.version(this.httpVersion);
        }
        methanolBuilder.sslParameters(SSL_PARAMETERS);
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        if (this.pettyJsonRequests) {
            gsonBuilder.setPrettyPrinting();
        }
        return new NamelessAPI(new RequestHandler(this.apiUrl, (Methanol)methanolBuilder.build(), gsonBuilder.create(), this.debugLogger, this.responseSizeLimit), this.apiUrl, this.apiKey);
    }

    static {
        SSL_PARAMETERS.setProtocols(new String[]{"TLSv1.3", "TLSv1.2"});
    }
}

