/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.sponge7;

import com.google.inject.Inject;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.lib.adventure.platform.spongeapi.SpongeAudiences;
import com.namelessmc.plugin.lib.checker-framework.checker.formatter.qual.UnknownFormat;
import com.namelessmc.plugin.lib.checker-framework.checker.initialization.qual.Initialized;
import com.namelessmc.plugin.lib.checker-framework.checker.nonempty.qual.UnknownNonEmpty;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.NonNull;
import com.namelessmc.plugin.lib.checker-framework.checker.nullness.qual.UnknownKeyFor;
import com.namelessmc.plugin.lib.checker-framework.checker.optional.qual.MaybePresent;
import com.namelessmc.plugin.lib.checker-framework.checker.regex.qual.UnknownRegex;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeAliased;
import com.namelessmc.plugin.lib.checker-framework.common.aliasing.qual.MaybeLeaked;
import com.namelessmc.plugin.sponge7.Slf4jLogger;
import com.namelessmc.plugin.sponge7.SpongeCommandProxy;
import com.namelessmc.plugin.sponge7.SpongeDataSender;
import com.namelessmc.plugin.sponge7.SpongeEventProxy;
import com.namelessmc.plugin.sponge7.SpongeScheduler;
import com.namelessmc.plugin.sponge7.audiences.SpongeAudienceProvider;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="namelessmc", name="NamelessMC", version="3.4.2", description="Integration with NamelessMC websites")
public class SpongeNamelessPlugin {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;

    @Inject
    public SpongeNamelessPlugin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat SpongeAudiences audiences, @ConfigDir(sharedRoot=false) @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Logger logger, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Game game) {
        this.plugin = new NamelessPlugin(dataDirectory, new SpongeScheduler(this), config -> new Slf4jLogger((ConfigurationHandler)config, logger), Path.of("logs", "latest.log"), "sponge7", Sponge.getPlatform().getMinecraftVersion().getName());
        this.plugin.setAudienceProvider(new SpongeAudienceProvider(this.plugin.config(), audiences, game.getServer()));
        this.plugin.registerReloadable(new SpongeDataSender(this.plugin));
        Sponge.getEventManager().registerListeners((Object)this, (Object)new SpongeEventProxy(this.plugin));
    }

    @Listener
    public void onServerStart(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat GameStartedServerEvent event) {
        this.plugin.load();
        SpongeCommandProxy.registerCommands(this.plugin, this);
    }

    @Listener
    public void reload(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat GameReloadEvent event) {
        this.plugin.unload();
        this.plugin.load();
    }
}

