/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.command.AbstractScheduler;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.derkutils.Tristate;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessApiBuilder;
import com.namelessmc.plugin.lib.nameless-api.NamelessVersion;
import com.namelessmc.plugin.lib.nameless-api.Website;
import com.namelessmc.plugin.lib.nameless-api.exception.ApiException;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import com.namelessmc.plugin.lib.nameless-api.exception.UnknownNamelessVersionException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpClient;
import java.time.Duration;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class ApiProvider
implements Reloadable {
    private static final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String USER_AGENT = "Nameless-Plugin/3.4.2";
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduler scheduler;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Tristate<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI> cachedApi;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat URL apiUrl;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String apiKey;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean debug;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Duration timeout;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean bypassVersionCheck;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean forceHttp1;

    public ApiProvider(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduler scheduler, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config) {
        this.scheduler = scheduler;
        this.logger = logger;
        this.config = config;
        this.cachedApi = Tristate.unknown();
    }

    @Override
    public void unload() {
        this.cachedApi = Tristate.unknown();
        this.apiUrl = null;
        this.apiKey = null;
        this.timeout = null;
    }

    @Override
    public void load() {
        CommentedConfigurationNode config = (CommentedConfigurationNode)this.config.main().node(new Object[]{"api"});
        try {
            String rawUrl = ((CommentedConfigurationNode)config.node(new Object[]{"url"})).getString();
            if (rawUrl != null) {
                this.apiUrl = new URL(rawUrl);
            }
        }
        catch (MalformedURLException e) {
            this.logger.severe("You have entered an invalid API URL. Please get an up-to-date API URL from StaffCP > Configuration > API and reload the plugin.");
            return;
        }
        this.apiKey = ((CommentedConfigurationNode)config.node(new Object[]{"key"})).getString();
        this.debug = ((CommentedConfigurationNode)config.node(new Object[]{"debug"})).getBoolean();
        Duration timeout = ConfigurationHandler.getDuration(config.node(new Object[]{"timeout"}));
        if (timeout != null) {
            this.timeout = timeout;
        } else {
            this.logger.warning("Invalid API timeout, using 10 seconds.");
            this.timeout = Duration.ofSeconds(10L);
        }
        this.bypassVersionCheck = ((CommentedConfigurationNode)config.node(new Object[]{"bypass-version-check"})).getBoolean();
        this.forceHttp1 = ((CommentedConfigurationNode)config.node(new Object[]{"force-http-1"})).getBoolean();
        this.scheduler.runAsync(this::api);
    }

    @Deprecated
    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String isApiWorkingMetric() {
        if (!this.cachedApi.known()) {
            return "Unknown";
        }
        return this.cachedApi.present() ? "Working" : "Not working";
    }

    public synchronized @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI api() {
        block10: {
            if (this.cachedApi.known()) {
                return this.cachedApi.value();
            }
            if (this.apiUrl == null || this.apiKey == null || this.apiKey.isEmpty()) {
                this.logger.severe("You have not entered an API URL and API key in the config or the API URL or API key is invalid. Please get your site's API URL and API key from StaffCP > Configuration > API and reload the plugin.");
                this.cachedApi = Tristate.knownEmpty();
            } else {
                try {
                    NamelessApiBuilder builder = NamelessAPI.builder(this.apiUrl, this.apiKey).userAgent(USER_AGENT).customDebugLogger(this.debug ? this.logger.getApiLogger() : null).timeout(this.timeout);
                    if (this.forceHttp1) {
                        builder.httpVersion(HttpClient.Version.HTTP_1_1);
                    }
                    NamelessAPI api = builder.build();
                    Website info = api.website();
                    if (this.bypassVersionCheck) {
                        this.logger.warning("Bypassing version checks, use at your own risk!");
                        this.cachedApi = Tristate.known(api);
                        break block10;
                    }
                    try {
                        NamelessVersion version = info.parsedVersion();
                        if (NamelessVersion.isSupportedByJavaApi(version)) {
                            this.logger.fine("Website connection appears to be working.");
                            this.cachedApi = Tristate.known(api);
                            break block10;
                        }
                        this.logger.severe("Your website runs a version of NamelessMC (" + String.valueOf((Object)version) + ") that is not supported by this version of the plugin. Please update your NamelessMC website and/or the plugin.");
                        this.cachedApi = Tristate.knownEmpty();
                    }
                    catch (UnknownNamelessVersionException ignored) {
                        this.logger.severe("The plugin doesn't recognize the NamelessMC version you are using. Ensure you are running a recent version of the plugin and NamelessMC v2. If no updated version is available, you can bypass the version check at your own risk by adding `bypass-version-check: true` in the api section in main.yml.");
                        this.cachedApi = Tristate.knownEmpty();
                    }
                }
                catch (NamelessException e) {
                    this.logger.logException(e);
                    this.cachedApi = e instanceof ApiException ? Tristate.knownEmpty() : Tristate.unknown();
                }
            }
        }
        return this.cachedApi.value();
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessAPI apiIfCached() {
        return this.cachedApi.present() ? this.cachedApi.value() : null;
    }
}

