/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.event.NamelessJoinEvent;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class JoinNotRegisteredMessage
implements Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventSubscription subscription;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String registerCommand;

    JoinNotRegisteredMessage(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void load() {
        CommentedConfigurationNode conf = this.plugin.config().main();
        if (!conf.node("not-registered-join-message").getBoolean()) {
            return;
        }
        CommentedConfigurationNode commands = this.plugin.config().commands();
        if (!commands.hasChild("register")) {
            this.plugin.logger().warning("not-registered-join-message is enabled, but the register command is disabled");
            return;
        }
        this.registerCommand = commands.node("register").getString();
        this.subscription = this.plugin.events().subscribe(NamelessJoinEvent.class, event -> this.onJoin(event.player().uuid()));
    }

    private void onJoin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID uuid) {
        String registerCommand = this.registerCommand;
        if (registerCommand == null) {
            throw new IllegalStateException("Register command cannot be null");
        }
        this.plugin.scheduler().runAsync(() -> {
            NamelessUser user;
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            try {
                user = api.userByMinecraftUuid(uuid);
            }
            catch (NamelessException e) {
                this.plugin.logger().logException(e);
                return;
            }
            if (user == null) {
                this.plugin.scheduler().runSync(() -> {
                    NamelessPlayer audience = this.plugin.audiences().player(uuid);
                    if (audience != null) {
                        Component message = this.plugin.language().get(LanguageHandler.Term.JOIN_NOT_REGISTERED, "register_command", registerCommand);
                        audience.sendMessage(message);
                    }
                });
            }
        });
    }
}

