/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.NamelessPlugin;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import com.namelessmc.plugin.common.event.NamelessJoinEvent;
import com.namelessmc.plugin.lib.configurate.CommentedConfigurationNode;
import com.namelessmc.plugin.lib.event.EventSubscription;
import com.namelessmc.plugin.lib.nameless-api.NamelessAPI;
import com.namelessmc.plugin.lib.nameless-api.NamelessUser;
import com.namelessmc.plugin.lib.nameless-api.exception.NamelessException;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class JoinNotificationsMessage
implements Reloadable {
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventSubscription subscription;

    JoinNotificationsMessage(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void unload() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    @Override
    public void load() {
        if (((CommentedConfigurationNode)this.plugin.config().main().node(new Object[]{"join-notifications"})).getBoolean()) {
            this.subscription = this.plugin.events().subscribe(NamelessJoinEvent.class, event -> this.onJoin(event.player().uuid()));
        }
    }

    private void onJoin(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UUID uuid) {
        this.plugin.scheduler().runAsync(() -> {
            NamelessAPI api = this.plugin.apiProvider().api();
            if (api == null) {
                return;
            }
            try {
                NamelessUser user = api.userByMinecraftUuid(uuid);
                if (user == null) {
                    return;
                }
                int notifications = user.notificationCount();
                if (notifications == 0) {
                    return;
                }
                this.plugin.scheduler().runSync(() -> {
                    String notificationsCommand = ((CommentedConfigurationNode)this.plugin.config().commands().node(new Object[]{"get-notifications"})).getString();
                    if (notificationsCommand == null) {
                        this.plugin.logger().warning("Notifications command must be enabled for join-notifications feature");
                        return;
                    }
                    NamelessPlayer audience = this.plugin.audiences().player(uuid);
                    if (audience == null) {
                        this.plugin.logger().warning("Player left before we were able to send notifications message");
                        return;
                    }
                    Component message = this.plugin.language().get(LanguageHandler.Term.JOIN_NOTIFICATIONS, "notifications_command", notificationsCommand);
                    audience.sendMessage(message);
                });
            }
            catch (NamelessException e) {
                this.plugin.logger().logException(e);
            }
        });
    }
}

