/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.audiences.NamelessPlayer;
import java.util.Set;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;

public class LuckPermsPermissions
extends AbstractPermissions {
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat LuckPerms api;

    @Override
    public void unload() {
        this.api = null;
    }

    @Override
    public void load() {
        try {
            this.api = LuckPermsProvider.get();
        }
        catch (IllegalStateException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat boolean isUsable() {
        return this.api != null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> getGroups() {
        if (this.api == null) {
            throw new AbstractPermissions.ProviderNotUsableException(this);
        }
        return this.api.getGroupManager().getLoadedGroups().stream().map(Group::getName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String> getPlayerGroups(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlayer player) {
        if (this.api == null) {
            throw new AbstractPermissions.ProviderNotUsableException(this);
        }
        User user = this.api.getUserManager().getUser(player.uuid());
        if (user == null) {
            return null;
        }
        return user.getNodes().stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).map(InheritanceNode::getGroupName).collect(Collectors.toSet());
    }
}

