/*
 * Decompiled with CFR 0.152.
 */
package com.namelessmc.plugin.common;

import com.namelessmc.plugin.common.AbstractPermissions;
import com.namelessmc.plugin.common.AnnouncementTask;
import com.namelessmc.plugin.common.ApiProvider;
import com.namelessmc.plugin.common.ConfigurationHandler;
import com.namelessmc.plugin.common.DateFormatter;
import com.namelessmc.plugin.common.GroupSync;
import com.namelessmc.plugin.common.JoinNotRegisteredMessage;
import com.namelessmc.plugin.common.JoinNotificationsMessage;
import com.namelessmc.plugin.common.LanguageHandler;
import com.namelessmc.plugin.common.LuckPermsPermissions;
import com.namelessmc.plugin.common.Metrics;
import com.namelessmc.plugin.common.Reloadable;
import com.namelessmc.plugin.common.Store;
import com.namelessmc.plugin.common.SyncBanToWebsite;
import com.namelessmc.plugin.common.UserCache;
import com.namelessmc.plugin.common.Websend;
import com.namelessmc.plugin.common.audiences.AbstractAudienceProvider;
import com.namelessmc.plugin.common.command.AbstractScheduler;
import com.namelessmc.plugin.common.event.NamelessEvent;
import com.namelessmc.plugin.common.logger.AbstractLogger;
import com.namelessmc.plugin.lib.event.EventBus;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.formatter.qual.FormatBottom;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nonempty.qual.NonEmpty;
import org.checkerframework.checker.nonempty.qual.UnknownNonEmpty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.checker.regex.qual.RegexBottom;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;

public class NamelessPlugin {
    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin instance;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduler scheduler;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler configuration;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiProvider api;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat LanguageHandler language;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat DateFormatter dateFormatter;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UserCache userCache;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventBus<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessEvent> eventBus;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat GroupSync groupSync;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Reloadable>> reloadables = List.of(new ArrayList(), new ArrayList(), new ArrayList());
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractPermissions> permissionAdapters = new ArrayList<AbstractPermissions>();
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractPermissions chosenPermissionAdapter;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractAudienceProvider audienceProvider;

    public NamelessPlugin(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path dataDirectory, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduler scheduler, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Function<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger> loggerInstantiator, @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Path logPath, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformInternalName, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat String platformVersion) {
        instance = this;
        this.scheduler = scheduler;
        this.configuration = this.registerReloadable(new ConfigurationHandler(dataDirectory));
        this.logger = this.registerReloadable(loggerInstantiator.apply(this.configuration));
        this.registerReloadable(new ConfigurationHandler.PostLoadChecker(this.configuration, this.logger), Reloadable.Order.LAST);
        this.api = this.registerReloadable(new ApiProvider(scheduler, this.logger, this.configuration));
        this.language = this.registerReloadable(new LanguageHandler(dataDirectory, this.configuration, this.logger));
        this.dateFormatter = this.registerReloadable(new DateFormatter(this.configuration));
        this.userCache = this.registerReloadable(new UserCache(this));
        this.eventBus = EventBus.create(NamelessEvent.class);
        this.registerReloadable(new AnnouncementTask(this));
        this.registerReloadable(new JoinNotificationsMessage(this));
        this.registerReloadable(new JoinNotRegisteredMessage(this));
        this.registerReloadable(new Metrics(this, platformInternalName, platformVersion));
        this.registerReloadable(new Store(this));
        this.registerReloadable(new SyncBanToWebsite(this));
        this.registerReloadable(new Websend(this, logPath));
        this.groupSync = this.registerReloadable(new GroupSync(this));
        this.registerPermissionAdapter(new LuckPermsPermissions());
        this.registerReloadable(new PermissionAdapterSelector(), Reloadable.Order.FIRST);
        int javaVer = Runtime.version().feature();
        if (javaVer > 11 && javaVer < 17) {
            this.logger.warning("You are running Java version " + javaVer + " which is non-LTS and no longer receives bug fixes or security fixes. Please update to Java 17.");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ConfigurationHandler config() {
        return this.configuration;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractLogger logger() {
        return this.logger;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat ApiProvider apiProvider() {
        return this.api;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat LanguageHandler language() {
        return this.language;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractScheduler scheduler() {
        return this.scheduler;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractAudienceProvider audiences() {
        return this.audienceProvider;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat UserCache userCache() {
        return this.userCache;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat EventBus<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessEvent> events() {
        return this.eventBus;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat GroupSync groupSync() {
        return this.groupSync;
    }

    public @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractPermissions permissions() {
        return this.chosenPermissionAdapter;
    }

    public void setAudienceProvider(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat AbstractAudienceProvider audienceProvider) {
        this.audienceProvider = audienceProvider;
    }

    public void unload() {
        for (Reloadable.Order order : Reloadable.Order.values()) {
            for (Reloadable reloadable : this.reloadables.get(order.ordinal())) {
                this.logger.fine(() -> "Unloading " + String.valueOf((Object)order) + ": " + reloadable.getClass().getSimpleName());
                reloadable.unload();
            }
        }
    }

    public void load() {
        for (Reloadable.Order order : Reloadable.Order.values()) {
            for (Reloadable reloadable : this.reloadables.get(order.ordinal())) {
                this.logger.fine(() -> "Loading " + String.valueOf((Object)order) + ": " + reloadable.getClass().getSimpleName());
                reloadable.load();
            }
        }
    }

    public <T extends Reloadable> T registerReloadable(T reloadable) {
        return this.registerReloadable(reloadable, Reloadable.Order.NORMAL);
    }

    public <T extends Reloadable> T registerReloadable(T reloadable, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Reloadable.Order order) {
        this.reloadables.get(order.ordinal()).add(reloadable);
        return reloadable;
    }

    public void unregisterReloadable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present @UnknownNonEmpty @NonEmpty @UnknownRegex @RegexBottom @UnknownFormat @FormatBottom ?> clazz) {
        for (Reloadable.Order order : Reloadable.Order.values()) {
            this.reloadables.get(order.ordinal()).removeIf(reloadable -> reloadable.getClass().equals(clazz));
        }
    }

    public <T extends AbstractPermissions> T registerPermissionAdapter(T adapter) {
        this.logger.fine(() -> "Registered permission adapter: " + adapter.getClass().getSimpleName());
        this.permissionAdapters.add(adapter);
        return adapter;
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownNonEmpty @UnknownRegex @UnknownFormat NamelessPlugin instance() {
        return instance;
    }

    private class PermissionAdapterSelector
    implements Reloadable {
        private PermissionAdapterSelector() {
        }

        @Override
        public void unload() {
            NamelessPlugin.this.chosenPermissionAdapter = null;
            for (AbstractPermissions permissions : NamelessPlugin.this.permissionAdapters) {
                permissions.unload();
            }
        }

        @Override
        public void load() {
            for (int i = NamelessPlugin.this.permissionAdapters.size() - 1; i >= 0; --i) {
                AbstractPermissions permissions = NamelessPlugin.this.permissionAdapters.get(i);
                NamelessPlugin.this.logger.fine(() -> "Reloading permissions: " + permissions.getClass().getSimpleName());
                permissions.load();
                if (!permissions.isUsable()) continue;
                NamelessPlugin.this.logger.fine(() -> "Chosen permission adapter: " + permissions.getClass().getSimpleName());
                NamelessPlugin.this.chosenPermissionAdapter = permissions;
                break;
            }
            if (NamelessPlugin.this.chosenPermissionAdapter == null) {
                NamelessPlugin.this.logger.fine("Found no usable permission adapter");
            }
        }
    }
}

